/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiModifyRequest;
import discord4j.discordjson.json.GuildEmojiModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableGuildEmojiModifyRequest
implements GuildEmojiModifyRequest {
    private final String name_value;
    private final boolean name_absent;
    private final List<String> roles_value;
    private final boolean roles_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildEmojiModifyRequest(Possible<String> name, Possible<List<String>> roles) {
        Possible<String> name$impl = name;
        Possible<List<String>> roles$impl = roles;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.roles_value = roles$impl.toOptional().orElse(null);
        this.roles_absent = roles$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableGuildEmojiModifyRequest(ImmutableGuildEmojiModifyRequest original, Possible<String> name, Possible<List<String>> roles) {
        Possible<String> name$impl = name;
        Possible<List<String>> roles$impl = roles;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.roles_value = roles$impl.toOptional().orElse(null);
        this.roles_absent = roles$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    @JsonProperty(value="roles")
    public Possible<List<String>> roles() {
        return this.roles_absent ? Possible.absent() : Possible.of(this.roles_value);
    }

    public ImmutableGuildEmojiModifyRequest withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildEmojiModifyRequest(this, newValue, this.roles());
    }

    public ImmutableGuildEmojiModifyRequest withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildEmojiModifyRequest(this, (Possible<String>)newValue, this.roles());
    }

    public ImmutableGuildEmojiModifyRequest withRoles(Possible<List<String>> possible) {
        Possible<List<String>> newValue = Objects.requireNonNull(possible);
        return new ImmutableGuildEmojiModifyRequest(this, this.name(), newValue);
    }

    public ImmutableGuildEmojiModifyRequest withRoles(Iterable<String> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableGuildEmojiModifyRequest(this, this.name(), (Possible<List<String>>)newValue);
    }

    @SafeVarargs
    public final ImmutableGuildEmojiModifyRequest withRoles(String ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableGuildEmojiModifyRequest(this, this.name(), (Possible<List<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildEmojiModifyRequest && this.equalTo(0, (ImmutableGuildEmojiModifyRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildEmojiModifyRequest another) {
        return this.name().equals(another.name()) && Objects.equals(this.roles_value, another.roles_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + Objects.hashCode(this.roles_value);
        return h;
    }

    public String toString() {
        return "GuildEmojiModifyRequest{name=" + this.name().toString() + ", roles=" + Objects.toString(this.roles_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildEmojiModifyRequest fromJson(Json json) {
        Builder builder = ImmutableGuildEmojiModifyRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.roles != null) {
            builder.roles(json.roles);
        }
        return builder.build();
    }

    public static ImmutableGuildEmojiModifyRequest of(Possible<String> name, Possible<List<String>> roles) {
        return new ImmutableGuildEmojiModifyRequest(name, roles);
    }

    public static ImmutableGuildEmojiModifyRequest copyOf(GuildEmojiModifyRequest instance) {
        if (instance instanceof ImmutableGuildEmojiModifyRequest) {
            return (ImmutableGuildEmojiModifyRequest)instance;
        }
        return ImmutableGuildEmojiModifyRequest.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isRolesPresent() {
        return !this.roles_absent;
    }

    public List<String> rolesOrElse(List<String> defaultValue) {
        return !this.roles_absent ? this.roles_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private List<String> roles_list = null;

        private Builder() {
        }

        public final Builder from(EmojiModifyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(GuildEmojiModifyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            EmojiModifyRequest instance;
            long bits = 0L;
            if (object instanceof EmojiModifyRequest) {
                instance = (EmojiModifyRequest)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
            }
            if (object instanceof GuildEmojiModifyRequest) {
                instance = (GuildEmojiModifyRequest)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
                this.roles(instance.roles());
            }
        }

        @JsonProperty(value="name")
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addRole(String element) {
            this.roles_getOrCreate().add(element);
            return this;
        }

        public Builder addAllRoles(List<String> elements) {
            this.roles_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="roles")
        public Builder roles(Possible<List<String>> elements) {
            this.roles_list = null;
            elements.toOptional().ifPresent(e -> this.roles_getOrCreate().addAll((Collection<String>)e));
            return this;
        }

        public Builder roles(List<String> elements) {
            this.roles_list = new ArrayList<String>(elements);
            return this;
        }

        public Builder roles(Iterable<String> elements) {
            this.roles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public ImmutableGuildEmojiModifyRequest build() {
            return new ImmutableGuildEmojiModifyRequest(null, this.name_build(), this.roles_build());
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<List<String>> roles_build() {
            return this.roles_list == null ? Possible.absent() : Possible.of(this.roles_list);
        }

        private List<String> roles_getOrCreate() {
            if (this.roles_list == null) {
                this.roles_list = new ArrayList<String>();
            }
            return this.roles_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildEmojiModifyRequest {
        Possible<String> name = Possible.absent();
        Possible<List<String>> roles = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(Possible<String> name) {
            this.name = name;
        }

        @JsonProperty(value="roles")
        public void setRoles(Possible<List<String>> roles) {
            this.roles = roles;
        }

        @Override
        public Possible<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<String>> roles() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildEmojiModifyRequest, attribute initializers form cycle " + attributes;
        }
    }
}

