/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiCreateRequest;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableEmojiCreateRequest
implements EmojiCreateRequest {
    private final String name;
    private final String image;

    private ImmutableEmojiCreateRequest(String name, String image) {
        this.name = Objects.requireNonNull(name, "name");
        this.image = Objects.requireNonNull(image, "image");
    }

    private ImmutableEmojiCreateRequest(ImmutableEmojiCreateRequest original, String name, String image) {
        this.name = name;
        this.image = image;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="image")
    public String image() {
        return this.image;
    }

    public final ImmutableEmojiCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableEmojiCreateRequest(this, newValue, this.image);
    }

    public final ImmutableEmojiCreateRequest withImage(String value) {
        String newValue = Objects.requireNonNull(value, "image");
        if (this.image.equals(newValue)) {
            return this;
        }
        return new ImmutableEmojiCreateRequest(this, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmojiCreateRequest && this.equalTo(0, (ImmutableEmojiCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmojiCreateRequest another) {
        return this.name.equals(another.name) && this.image.equals(another.image);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.image.hashCode();
        return h;
    }

    public String toString() {
        return "EmojiCreateRequest{name=" + this.name + ", image=" + this.image + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEmojiCreateRequest fromJson(Json json) {
        Builder builder = ImmutableEmojiCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.image != null) {
            builder.image(json.image);
        }
        return builder.build();
    }

    public static ImmutableEmojiCreateRequest of(String name, String image) {
        return new ImmutableEmojiCreateRequest(name, image);
    }

    public static ImmutableEmojiCreateRequest copyOf(EmojiCreateRequest instance) {
        if (instance instanceof ImmutableEmojiCreateRequest) {
            return (ImmutableEmojiCreateRequest)instance;
        }
        return ImmutableEmojiCreateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IMAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String image;

        private Builder() {
        }

        public final Builder from(EmojiCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.image(instance.image());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="image")
        public final Builder image(String image) {
            this.image = Objects.requireNonNull(image, "image");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEmojiCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEmojiCreateRequest(null, this.name, this.image);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("image");
            }
            return "Cannot build EmojiCreateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EmojiCreateRequest {
        @Nullable
        String name;
        @Nullable
        String image;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="image")
        public void setImage(String image) {
            this.image = image;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String image() {
            throw new UnsupportedOperationException();
        }
    }
}

