/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.BaseOnboardingPromptData;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableBaseOnboardingPromptData
implements BaseOnboardingPromptData {
    private final int type;
    private final String title;
    private final boolean singleSelect;
    private final boolean required;
    private final boolean inOnboarding;

    private ImmutableBaseOnboardingPromptData(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding) {
        this.type = type;
        this.title = Objects.requireNonNull(title, "title");
        this.singleSelect = singleSelect;
        this.required = required;
        this.inOnboarding = inOnboarding;
    }

    private ImmutableBaseOnboardingPromptData(ImmutableBaseOnboardingPromptData original, int type, String title, boolean singleSelect, boolean required, boolean inOnboarding) {
        this.type = type;
        this.title = title;
        this.singleSelect = singleSelect;
        this.required = required;
        this.inOnboarding = inOnboarding;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="single_select")
    public boolean singleSelect() {
        return this.singleSelect;
    }

    @Override
    @JsonProperty(value="required")
    public boolean required() {
        return this.required;
    }

    @Override
    @JsonProperty(value="in_onboarding")
    public boolean inOnboarding() {
        return this.inOnboarding;
    }

    public final ImmutableBaseOnboardingPromptData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptData(this, value, this.title, this.singleSelect, this.required, this.inOnboarding);
    }

    public final ImmutableBaseOnboardingPromptData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptData(this, this.type, newValue, this.singleSelect, this.required, this.inOnboarding);
    }

    public final ImmutableBaseOnboardingPromptData withSingleSelect(boolean value) {
        if (this.singleSelect == value) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptData(this, this.type, this.title, value, this.required, this.inOnboarding);
    }

    public final ImmutableBaseOnboardingPromptData withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptData(this, this.type, this.title, this.singleSelect, value, this.inOnboarding);
    }

    public final ImmutableBaseOnboardingPromptData withInOnboarding(boolean value) {
        if (this.inOnboarding == value) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptData(this, this.type, this.title, this.singleSelect, this.required, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseOnboardingPromptData && this.equalTo(0, (ImmutableBaseOnboardingPromptData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseOnboardingPromptData another) {
        return this.type == another.type && this.title.equals(another.title) && this.singleSelect == another.singleSelect && this.required == another.required && this.inOnboarding == another.inOnboarding;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Boolean.hashCode(this.singleSelect);
        h += (h << 5) + Boolean.hashCode(this.required);
        h += (h << 5) + Boolean.hashCode(this.inOnboarding);
        return h;
    }

    public String toString() {
        return "BaseOnboardingPromptData{type=" + this.type + ", title=" + this.title + ", singleSelect=" + this.singleSelect + ", required=" + this.required + ", inOnboarding=" + this.inOnboarding + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBaseOnboardingPromptData fromJson(Json json) {
        Builder builder = ImmutableBaseOnboardingPromptData.builder();
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.singleSelectIsSet) {
            builder.singleSelect(json.singleSelect);
        }
        if (json.requiredIsSet) {
            builder.required(json.required);
        }
        if (json.inOnboardingIsSet) {
            builder.inOnboarding(json.inOnboarding);
        }
        return builder.build();
    }

    public static ImmutableBaseOnboardingPromptData of(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding) {
        return new ImmutableBaseOnboardingPromptData(type, title, singleSelect, required, inOnboarding);
    }

    public static ImmutableBaseOnboardingPromptData copyOf(BaseOnboardingPromptData instance) {
        if (instance instanceof ImmutableBaseOnboardingPromptData) {
            return (ImmutableBaseOnboardingPromptData)instance;
        }
        return ImmutableBaseOnboardingPromptData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_SINGLE_SELECT = 4L;
        private static final long INIT_BIT_REQUIRED = 8L;
        private static final long INIT_BIT_IN_ONBOARDING = 16L;
        private long initBits = 31L;
        private int type;
        @Nullable
        private String title;
        private boolean singleSelect;
        private boolean required;
        private boolean inOnboarding;

        private Builder() {
        }

        public final Builder from(BaseOnboardingPromptData instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.title(instance.title());
            this.singleSelect(instance.singleSelect());
            this.required(instance.required());
            this.inOnboarding(instance.inOnboarding());
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="single_select")
        public final Builder singleSelect(boolean singleSelect) {
            this.singleSelect = singleSelect;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="required")
        public final Builder required(boolean required) {
            this.required = required;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="in_onboarding")
        public final Builder inOnboarding(boolean inOnboarding) {
            this.inOnboarding = inOnboarding;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableBaseOnboardingPromptData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseOnboardingPromptData(null, this.type, this.title, this.singleSelect, this.required, this.inOnboarding);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("singleSelect");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("required");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("inOnboarding");
            }
            return "Cannot build BaseOnboardingPromptData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BaseOnboardingPromptData {
        int type;
        boolean typeIsSet;
        @Nullable
        String title;
        boolean singleSelect;
        boolean singleSelectIsSet;
        boolean required;
        boolean requiredIsSet;
        boolean inOnboarding;
        boolean inOnboardingIsSet;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="single_select")
        public void setSingleSelect(boolean singleSelect) {
            this.singleSelect = singleSelect;
            this.singleSelectIsSet = true;
        }

        @JsonProperty(value="required")
        public void setRequired(boolean required) {
            this.required = required;
            this.requiredIsSet = true;
        }

        @JsonProperty(value="in_onboarding")
        public void setInOnboarding(boolean inOnboarding) {
            this.inOnboarding = inOnboarding;
            this.inOnboardingIsSet = true;
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean singleSelect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean required() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean inOnboarding() {
            throw new UnsupportedOperationException();
        }
    }
}

