/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AvatarDecorationData;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableAvatarDecorationData
implements AvatarDecorationData {
    private final String asset;
    private final long skuId_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAvatarDecorationData(String asset, Id skuId) {
        this.asset = Objects.requireNonNull(asset, "asset");
        Id skuId$impl = skuId;
        this.skuId_value = skuId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableAvatarDecorationData(ImmutableAvatarDecorationData original, String asset, Id skuId) {
        this.asset = asset;
        Id skuId$impl = skuId;
        this.skuId_value = skuId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="asset")
    public String asset() {
        return this.asset;
    }

    @Override
    @JsonProperty(value="sku_id")
    public Id skuId() {
        return Id.of((long)this.skuId_value);
    }

    public final ImmutableAvatarDecorationData withAsset(String value) {
        String newValue = Objects.requireNonNull(value, "asset");
        if (this.asset.equals(newValue)) {
            return this;
        }
        return new ImmutableAvatarDecorationData(this, newValue, this.skuId());
    }

    public ImmutableAvatarDecorationData withSkuId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableAvatarDecorationData(this, this.asset, newValue);
    }

    public ImmutableAvatarDecorationData withSkuId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableAvatarDecorationData(this, this.asset, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAvatarDecorationData && this.equalTo(0, (ImmutableAvatarDecorationData)another);
    }

    private boolean equalTo(int synthetic, ImmutableAvatarDecorationData another) {
        return this.asset.equals(another.asset) && Objects.equals(this.skuId_value, another.skuId_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.asset.hashCode();
        h += (h << 5) + Objects.hashCode(this.skuId_value);
        return h;
    }

    public String toString() {
        return "AvatarDecorationData{asset=" + this.asset + ", skuId=" + Objects.toString(this.skuId_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAvatarDecorationData fromJson(Json json) {
        Builder builder = ImmutableAvatarDecorationData.builder();
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.skuId != null) {
            builder.skuId(json.skuId);
        }
        return builder.build();
    }

    public static ImmutableAvatarDecorationData of(String asset, Id skuId) {
        return new ImmutableAvatarDecorationData(asset, skuId);
    }

    public static ImmutableAvatarDecorationData copyOf(AvatarDecorationData instance) {
        if (instance instanceof ImmutableAvatarDecorationData) {
            return (ImmutableAvatarDecorationData)instance;
        }
        return ImmutableAvatarDecorationData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ASSET = 1L;
        private long initBits = 1L;
        private Id skuId_id = null;
        @Nullable
        private String asset;

        private Builder() {
        }

        public final Builder from(AvatarDecorationData instance) {
            Objects.requireNonNull(instance, "instance");
            this.asset(instance.asset());
            this.skuId(instance.skuId());
            return this;
        }

        @JsonProperty(value="asset")
        public final Builder asset(String asset) {
            this.asset = Objects.requireNonNull(asset, "asset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder skuId(String value) {
            this.skuId_id = Id.of((String)value);
            return this;
        }

        public Builder skuId(long value) {
            this.skuId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="sku_id")
        public Builder skuId(Id value) {
            this.skuId_id = value;
            return this;
        }

        public ImmutableAvatarDecorationData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAvatarDecorationData(null, this.asset, this.skuId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("asset");
            }
            return "Cannot build AvatarDecorationData, some of required attributes are not set " + attributes;
        }

        private Id skuId_build() {
            return this.skuId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements AvatarDecorationData {
        @Nullable
        String asset;
        @Nullable
        Id skuId;

        Json() {
        }

        @JsonProperty(value="asset")
        public void setAsset(String asset) {
            this.asset = asset;
        }

        @JsonProperty(value="sku_id")
        public void setSkuId(Id skuId) {
            this.skuId = skuId;
        }

        @Override
        public String asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id skuId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build AvatarDecorationData, attribute initializers form cycle " + attributes;
        }
    }
}

