/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.UserEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class UserEditSpec
implements UserEditSpecGenerator {
    private final String username_value;
    private final boolean username_absent;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final UserEditSpec INSTANCE = UserEditSpec.validate(new UserEditSpec());

    private UserEditSpec() {
        Possible username$impl = Possible.absent();
        Possible avatar$impl = Possible.absent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private UserEditSpec(Possible<String> username, Possible<Image> avatar) {
        Possible<String> username$impl = username;
        Possible<Image> avatar$impl = avatar;
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> username() {
        return this.username_absent ? Possible.absent() : Possible.of((Object)this.username_value);
    }

    @Override
    public Possible<Image> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of((Object)this.avatar_value);
    }

    public UserEditSpec withUsername(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return UserEditSpec.validate(new UserEditSpec(newValue, this.avatar()));
    }

    public UserEditSpec withUsername(String value) {
        Possible newValue = Possible.of((Object)value);
        return UserEditSpec.validate(new UserEditSpec((Possible<String>)newValue, this.avatar()));
    }

    public UserEditSpec withAvatar(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return UserEditSpec.validate(new UserEditSpec(this.username(), newValue));
    }

    public UserEditSpec withAvatar(Image value) {
        Possible newValue = Possible.of((Object)value);
        return UserEditSpec.validate(new UserEditSpec(this.username(), (Possible<Image>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserEditSpec && this.equalTo(0, (UserEditSpec)another);
    }

    private boolean equalTo(int synthetic, UserEditSpec another) {
        return this.username().equals(another.username()) && this.avatar().equals(another.avatar());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username().hashCode();
        h += (h << 5) + this.avatar().hashCode();
        return h;
    }

    public String toString() {
        return "UserEditSpec{username=" + this.username().toString() + ", avatar=" + this.avatar().toString() + "}";
    }

    public static UserEditSpec create() {
        return INSTANCE;
    }

    private static UserEditSpec validate(UserEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static UserEditSpec copyOf(UserEditSpecGenerator instance) {
        if (instance instanceof UserEditSpec) {
            return (UserEditSpec)instance;
        }
        return UserEditSpec.builder().from(instance).build();
    }

    public boolean isUsernamePresent() {
        return !this.username_absent;
    }

    public String usernameOrElse(String defaultValue) {
        return !this.username_absent ? this.username_value : defaultValue;
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> username_possible = Possible.absent();
        private Possible<Image> avatar_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(UserEditSpec instance) {
            return this.from((UserEditSpecGenerator)instance);
        }

        final Builder from(UserEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.username());
            this.avatar(instance.avatar());
            return this;
        }

        public Builder username(Possible<String> value) {
            this.username_possible = value;
            return this;
        }

        public Builder username(String value) {
            this.username_possible = Possible.of((Object)value);
            return this;
        }

        public Builder avatar(Possible<Image> value) {
            this.avatar_possible = value;
            return this;
        }

        public Builder avatar(Image value) {
            this.avatar_possible = Possible.of((Object)value);
            return this;
        }

        public UserEditSpec build() {
            return UserEditSpec.validate(new UserEditSpec(this.username_build(), this.avatar_build()));
        }

        private Possible<String> username_build() {
            return this.username_possible;
        }

        private Possible<Image> avatar_build() {
            return this.avatar_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build UserEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

