/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.spec.UserEditMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class UserEditMono
extends UserEditMonoGenerator {
    private final String username_value;
    private final boolean username_absent;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private final GatewayDiscordClient gateway;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private UserEditMono(GatewayDiscordClient gateway) {
        this.gateway = Objects.requireNonNull(gateway, "gateway");
        Possible username$impl = Possible.absent();
        Possible avatar$impl = Possible.absent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private UserEditMono(Possible<String> username, Possible<Image> avatar, GatewayDiscordClient gateway) {
        Possible<String> username$impl = username;
        Possible<Image> avatar$impl = avatar;
        this.gateway = gateway;
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> username() {
        return this.username_absent ? Possible.absent() : Possible.of((Object)this.username_value);
    }

    @Override
    public Possible<Image> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of((Object)this.avatar_value);
    }

    @Override
    public GatewayDiscordClient gateway() {
        return this.gateway;
    }

    public UserEditMono withUsername(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new UserEditMono(newValue, this.avatar(), this.gateway);
    }

    public UserEditMono withUsername(String value) {
        Possible newValue = Possible.of((Object)value);
        return new UserEditMono((Possible<String>)newValue, this.avatar(), this.gateway);
    }

    public UserEditMono withAvatar(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return new UserEditMono(this.username(), newValue, this.gateway);
    }

    public UserEditMono withAvatar(Image value) {
        Possible newValue = Possible.of((Object)value);
        return new UserEditMono(this.username(), (Possible<Image>)newValue, this.gateway);
    }

    public final UserEditMono withGateway(GatewayDiscordClient value) {
        if (this.gateway == value) {
            return this;
        }
        GatewayDiscordClient newValue = Objects.requireNonNull(value, "gateway");
        return new UserEditMono(this.username(), this.avatar(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserEditMono && this.equalTo(0, (UserEditMono)another);
    }

    private boolean equalTo(int synthetic, UserEditMono another) {
        return this.username().equals(another.username()) && this.avatar().equals(another.avatar()) && this.gateway.equals(another.gateway);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username().hashCode();
        h += (h << 5) + this.avatar().hashCode();
        h += (h << 5) + this.gateway.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "UserEditMono{username=" + this.username().toString() + ", avatar=" + this.avatar().toString() + ", gateway=" + this.gateway + "}";
    }

    public static UserEditMono of(GatewayDiscordClient gateway) {
        return new UserEditMono(gateway);
    }

    static UserEditMono copyOf(UserEditMonoGenerator instance) {
        if (instance instanceof UserEditMono) {
            return (UserEditMono)instance;
        }
        return UserEditMono.of(instance.gateway()).withUsername((Possible<String>)instance.username()).withAvatar((Possible<Image>)instance.avatar());
    }

    public boolean isUsernamePresent() {
        return !this.username_absent;
    }

    public String usernameOrElse(String defaultValue) {
        return !this.username_absent ? this.username_value : defaultValue;
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build UserEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

