/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.ImmutableSoundboardSoundCreateRequest;
import discord4j.discordjson.json.SoundboardSoundCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface SoundboardSoundCreateSpecGenerator
extends AuditSpec<SoundboardSoundCreateRequest> {
    public String name();

    public String sound();

    public Possible<Optional<Double>> volume();

    public Possible<Optional<EmojiData>> emoji();

    @Override
    default public SoundboardSoundCreateRequest asRequest() {
        ImmutableSoundboardSoundCreateRequest.Builder builder = SoundboardSoundCreateRequest.builder();
        if (!this.emoji().isAbsent() && Possible.flatOpt(this.emoji()).isPresent()) {
            EmojiData emoji = (EmojiData)Possible.flatOpt(this.emoji()).get();
            builder.emojiId(Possible.of((Object)emoji.id()));
            builder.emojiName(Possible.ofNullable((Object)emoji.name()));
        }
        builder.name(this.name());
        builder.sound(this.sound());
        builder.volume(this.volume());
        return builder.build();
    }
}

