/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.Guild;
import discord4j.core.spec.SoundboardSoundCreateMonoGenerator;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class SoundboardSoundCreateMono
extends SoundboardSoundCreateMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name;
    private final String sound;
    private final Double volume_value;
    private final boolean volume_absent;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SoundboardSoundCreateMono(String name, String sound, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.sound = Objects.requireNonNull(sound, "sound");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible volume$impl = Possible.absent();
        Possible emoji$impl = Possible.absent();
        this.volume_value = Possible.flatOpt((Possible)volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt((Possible)emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    private SoundboardSoundCreateMono(@reactor.util.annotation.Nullable String reason, String name, String sound, Possible<Optional<Double>> volume, Possible<Optional<EmojiData>> emoji, Guild guild) {
        this.reason = reason;
        this.name = name;
        this.sound = sound;
        Possible<Optional<Double>> volume$impl = volume;
        Possible<Optional<EmojiData>> emoji$impl = emoji;
        this.guild = guild;
        this.volume_value = Possible.flatOpt(volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt(emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String sound() {
        return this.sound;
    }

    @Override
    public Possible<Optional<Double>> volume() {
        return this.volume_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.volume_value));
    }

    @Override
    public Possible<Optional<EmojiData>> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emoji_value));
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final SoundboardSoundCreateMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new SoundboardSoundCreateMono(value, this.name, this.sound, this.volume(), this.emoji(), this.guild);
    }

    public final SoundboardSoundCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new SoundboardSoundCreateMono(this.reason, newValue, this.sound, this.volume(), this.emoji(), this.guild);
    }

    public final SoundboardSoundCreateMono withSound(String value) {
        String newValue = Objects.requireNonNull(value, "sound");
        if (this.sound.equals(newValue)) {
            return this;
        }
        return new SoundboardSoundCreateMono(this.reason, this.name, newValue, this.volume(), this.emoji(), this.guild);
    }

    public SoundboardSoundCreateMono withVolume(Possible<Optional<Double>> value) {
        Possible<Optional<Double>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, newValue, this.emoji(), this.guild);
    }

    @Deprecated
    public SoundboardSoundCreateMono withVolume(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, (Possible<Optional<Double>>)newValue, this.emoji(), this.guild);
    }

    public SoundboardSoundCreateMono withVolumeOrNull(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, (Possible<Optional<Double>>)newValue, this.emoji(), this.guild);
    }

    public SoundboardSoundCreateMono withEmoji(Possible<Optional<EmojiData>> value) {
        Possible<Optional<EmojiData>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, this.volume(), newValue, this.guild);
    }

    @Deprecated
    public SoundboardSoundCreateMono withEmoji(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, this.volume(), (Possible<Optional<EmojiData>>)newValue, this.guild);
    }

    public SoundboardSoundCreateMono withEmojiOrNull(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, this.volume(), (Possible<Optional<EmojiData>>)newValue, this.guild);
    }

    public final SoundboardSoundCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new SoundboardSoundCreateMono(this.reason, this.name, this.sound, this.volume(), this.emoji(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SoundboardSoundCreateMono && this.equalTo(0, (SoundboardSoundCreateMono)another);
    }

    private boolean equalTo(int synthetic, SoundboardSoundCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.sound.equals(another.sound) && this.volume().equals(another.volume()) && this.emoji().equals(another.emoji()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.sound.hashCode();
        h += (h << 5) + this.volume().hashCode();
        h += (h << 5) + this.emoji().hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "SoundboardSoundCreateMono{reason=" + this.reason + ", name=" + this.name + ", sound=" + this.sound + ", volume=" + this.volume().toString() + ", emoji=" + this.emoji().toString() + ", guild=" + this.guild + "}";
    }

    public static SoundboardSoundCreateMono of(String name, String sound, Guild guild) {
        return new SoundboardSoundCreateMono(name, sound, guild);
    }

    static SoundboardSoundCreateMono copyOf(SoundboardSoundCreateMonoGenerator instance) {
        if (instance instanceof SoundboardSoundCreateMono) {
            return (SoundboardSoundCreateMono)instance;
        }
        return SoundboardSoundCreateMono.of(instance.name(), instance.sound(), instance.guild()).withReason(instance.reason()).withVolume((Possible<Optional<Double>>)instance.volume()).withEmoji((Possible<Optional<EmojiData>>)instance.emoji());
    }

    public boolean isVolumePresent() {
        return !this.volume_absent;
    }

    public Double volumeOrElse(Double defaultValue) {
        return !this.volume_absent ? this.volume_value : defaultValue;
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSoundCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

