/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.RoleEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class RoleEditSpec
implements RoleEditSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final PermissionSet permissions_value;
    private final boolean permissions_absent;
    private final Color color_value;
    private final boolean color_absent;
    private final Boolean hoist_value;
    private final boolean hoist_absent;
    private final Boolean mentionable_value;
    private final boolean mentionable_absent;
    private final String icon_value;
    private final boolean icon_absent;
    private final String unicodeEmoji_value;
    private final boolean unicodeEmoji_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final RoleEditSpec INSTANCE = RoleEditSpec.validate(new RoleEditSpec());

    private RoleEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible permissions$impl = Possible.absent();
        Possible color$impl = Possible.absent();
        Possible hoist$impl = Possible.absent();
        Possible mentionable$impl = Possible.absent();
        Possible icon$impl = Possible.absent();
        Possible unicodeEmoji$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.hoist_value = hoist$impl.toOptional().orElse(null);
        this.hoist_absent = hoist$impl.isAbsent();
        this.mentionable_value = mentionable$impl.toOptional().orElse(null);
        this.mentionable_absent = mentionable$impl.isAbsent();
        this.icon_value = Possible.flatOpt((Possible)icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.unicodeEmoji_value = Possible.flatOpt((Possible)unicodeEmoji$impl).orElse(null);
        this.unicodeEmoji_absent = unicodeEmoji$impl.isAbsent();
        this.initShim = null;
    }

    private RoleEditSpec(@reactor.util.annotation.Nullable String reason, Possible<String> name, Possible<PermissionSet> permissions, Possible<Color> color, Possible<Boolean> hoist, Possible<Boolean> mentionable, Possible<Optional<String>> icon, Possible<Optional<String>> unicodeEmoji) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<PermissionSet> permissions$impl = permissions;
        Possible<Color> color$impl = color;
        Possible<Boolean> hoist$impl = hoist;
        Possible<Boolean> mentionable$impl = mentionable;
        Possible<Optional<String>> icon$impl = icon;
        Possible<Optional<String>> unicodeEmoji$impl = unicodeEmoji;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.hoist_value = hoist$impl.toOptional().orElse(null);
        this.hoist_absent = hoist$impl.isAbsent();
        this.mentionable_value = mentionable$impl.toOptional().orElse(null);
        this.mentionable_absent = mentionable$impl.isAbsent();
        this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.unicodeEmoji_value = Possible.flatOpt(unicodeEmoji$impl).orElse(null);
        this.unicodeEmoji_absent = unicodeEmoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<PermissionSet> permissions() {
        return this.permissions_absent ? Possible.absent() : Possible.of((Object)this.permissions_value);
    }

    @Override
    public Possible<Color> color() {
        return this.color_absent ? Possible.absent() : Possible.of((Object)this.color_value);
    }

    @Override
    public Possible<Boolean> hoist() {
        return this.hoist_absent ? Possible.absent() : Possible.of((Object)this.hoist_value);
    }

    @Override
    public Possible<Boolean> mentionable() {
        return this.mentionable_absent ? Possible.absent() : Possible.of((Object)this.mentionable_value);
    }

    @Override
    public Possible<Optional<String>> icon() {
        return this.icon_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.icon_value));
    }

    @Override
    public Possible<Optional<String>> unicodeEmoji() {
        return this.unicodeEmoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.unicodeEmoji_value));
    }

    public final RoleEditSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return RoleEditSpec.validate(new RoleEditSpec(value, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, newValue, this.permissions(), this.color(), this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, (Possible<String>)newValue, this.permissions(), this.color(), this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withPermissions(Possible<PermissionSet> value) {
        Possible<PermissionSet> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withPermissions(PermissionSet value) {
        Possible newValue = Possible.of((Object)value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), (Possible<PermissionSet>)newValue, this.color(), this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withColor(Possible<Color> value) {
        Possible<Color> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), newValue, this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withColor(Color value) {
        Possible newValue = Possible.of((Object)value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), (Possible<Color>)newValue, this.hoist(), this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withHoist(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), newValue, this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withHoist(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), (Possible<Boolean>)newValue, this.mentionable(), this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withMentionable(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue, this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withMentionable(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), (Possible<Boolean>)newValue, this.icon(), this.unicodeEmoji()));
    }

    public RoleEditSpec withIcon(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), newValue, this.unicodeEmoji()));
    }

    @Deprecated
    public RoleEditSpec withIcon(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), (Possible<Optional<String>>)newValue, this.unicodeEmoji()));
    }

    public RoleEditSpec withIconOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), (Possible<Optional<String>>)newValue, this.unicodeEmoji()));
    }

    public RoleEditSpec withUnicodeEmoji(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), this.icon(), newValue));
    }

    @Deprecated
    public RoleEditSpec withUnicodeEmoji(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), this.icon(), (Possible<Optional<String>>)newValue));
    }

    public RoleEditSpec withUnicodeEmojiOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), this.icon(), (Possible<Optional<String>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RoleEditSpec && this.equalTo(0, (RoleEditSpec)another);
    }

    private boolean equalTo(int synthetic, RoleEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.permissions().equals(another.permissions()) && this.color().equals(another.color()) && this.hoist().equals(another.hoist()) && this.mentionable().equals(another.mentionable()) && this.icon().equals(another.icon()) && this.unicodeEmoji().equals(another.unicodeEmoji());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.permissions().hashCode();
        h += (h << 5) + this.color().hashCode();
        h += (h << 5) + this.hoist().hashCode();
        h += (h << 5) + this.mentionable().hashCode();
        h += (h << 5) + this.icon().hashCode();
        h += (h << 5) + this.unicodeEmoji().hashCode();
        return h;
    }

    public String toString() {
        return "RoleEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", permissions=" + this.permissions().toString() + ", color=" + this.color().toString() + ", hoist=" + this.hoist().toString() + ", mentionable=" + this.mentionable().toString() + ", icon=" + this.icon().toString() + ", unicodeEmoji=" + this.unicodeEmoji().toString() + "}";
    }

    public static RoleEditSpec create() {
        return INSTANCE;
    }

    private static RoleEditSpec validate(RoleEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static RoleEditSpec copyOf(RoleEditSpecGenerator instance) {
        if (instance instanceof RoleEditSpec) {
            return (RoleEditSpec)instance;
        }
        return RoleEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPermissionsPresent() {
        return !this.permissions_absent;
    }

    public PermissionSet permissionsOrElse(PermissionSet defaultValue) {
        return !this.permissions_absent ? this.permissions_value : defaultValue;
    }

    public boolean isColorPresent() {
        return !this.color_absent;
    }

    public Color colorOrElse(Color defaultValue) {
        return !this.color_absent ? this.color_value : defaultValue;
    }

    public boolean isHoistPresent() {
        return !this.hoist_absent;
    }

    public Boolean hoistOrElse(Boolean defaultValue) {
        return !this.hoist_absent ? this.hoist_value : defaultValue;
    }

    public boolean isMentionablePresent() {
        return !this.mentionable_absent;
    }

    public Boolean mentionableOrElse(Boolean defaultValue) {
        return !this.mentionable_absent ? this.mentionable_value : defaultValue;
    }

    public boolean isIconPresent() {
        return !this.icon_absent;
    }

    public String iconOrElse(String defaultValue) {
        return !this.icon_absent ? this.icon_value : defaultValue;
    }

    public boolean isUnicodeEmojiPresent() {
        return !this.unicodeEmoji_absent;
    }

    public String unicodeEmojiOrElse(String defaultValue) {
        return !this.unicodeEmoji_absent ? this.unicodeEmoji_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<PermissionSet> permissions_possible = Possible.absent();
        private Possible<Color> color_possible = Possible.absent();
        private Possible<Boolean> hoist_possible = Possible.absent();
        private Possible<Boolean> mentionable_possible = Possible.absent();
        private Possible<Optional<String>> icon_possible = Possible.absent();
        private Possible<Optional<String>> unicodeEmoji_possible = Possible.absent();
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(RoleEditSpec instance) {
            return this.from((RoleEditSpecGenerator)instance);
        }

        final Builder from(RoleEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.permissions(instance.permissions());
            this.color(instance.color());
            this.hoist(instance.hoist());
            this.mentionable(instance.mentionable());
            this.icon(instance.icon());
            this.unicodeEmoji(instance.unicodeEmoji());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        public Builder permissions(Possible<PermissionSet> value) {
            this.permissions_possible = value;
            return this;
        }

        public Builder permissions(PermissionSet value) {
            this.permissions_possible = Possible.of((Object)value);
            return this;
        }

        public Builder color(Possible<Color> value) {
            this.color_possible = value;
            return this;
        }

        public Builder color(Color value) {
            this.color_possible = Possible.of((Object)value);
            return this;
        }

        public Builder hoist(Possible<Boolean> value) {
            this.hoist_possible = value;
            return this;
        }

        public Builder hoist(Boolean value) {
            this.hoist_possible = Possible.of((Object)value);
            return this;
        }

        public Builder mentionable(Possible<Boolean> value) {
            this.mentionable_possible = value;
            return this;
        }

        public Builder mentionable(Boolean value) {
            this.mentionable_possible = Possible.of((Object)value);
            return this;
        }

        public Builder icon(Possible<Optional<String>> value) {
            this.icon_possible = value;
            return this;
        }

        @Deprecated
        public Builder icon(@Nullable String value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder iconOrNull(@Nullable String value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder unicodeEmoji(Possible<Optional<String>> value) {
            this.unicodeEmoji_possible = value;
            return this;
        }

        @Deprecated
        public Builder unicodeEmoji(@Nullable String value) {
            this.unicodeEmoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder unicodeEmojiOrNull(@Nullable String value) {
            this.unicodeEmoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public RoleEditSpec build() {
            return RoleEditSpec.validate(new RoleEditSpec(this.reason, this.name_build(), this.permissions_build(), this.color_build(), this.hoist_build(), this.mentionable_build(), this.icon_build(), this.unicodeEmoji_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<PermissionSet> permissions_build() {
            return this.permissions_possible;
        }

        private Possible<Color> color_build() {
            return this.color_possible;
        }

        private Possible<Boolean> hoist_build() {
            return this.hoist_possible;
        }

        private Possible<Boolean> mentionable_build() {
            return this.mentionable_possible;
        }

        private Possible<Optional<String>> icon_build() {
            return this.icon_possible;
        }

        private Possible<Optional<String>> unicodeEmoji_build() {
            return this.unicodeEmoji_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build RoleEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

