/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.MessageCreateMonoGenerator;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class MessageCreateMono
extends MessageCreateMonoGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String nonce_value;
    private final boolean nonce_absent;
    private final Boolean enforceNonce_value;
    private final boolean enforceNonce_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final Snowflake messageReferenceId_value;
    private final boolean messageReferenceId_absent;
    private final MessageReferenceData messageReference_value;
    private final boolean messageReference_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private final List<Snowflake> stickersIds_value;
    private final boolean stickersIds_absent;
    private final PollCreateData poll_value;
    private final boolean poll_absent;
    private final List<Message.Flag> flags_value;
    private final boolean flags_absent;
    private final MessageChannel channel;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private MessageCreateMono(MessageChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        Possible content$impl = Possible.absent();
        Possible nonce$impl = Possible.absent();
        Possible enforceNonce$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible messageReferenceId$impl = Possible.absent();
        Possible messageReference$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        Possible stickersIds$impl = Possible.absent();
        Possible poll$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReferenceId_value = messageReferenceId$impl.toOptional().orElse(null);
        this.messageReferenceId_absent = messageReferenceId$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.stickersIds_value = stickersIds$impl.toOptional().orElse(null);
        this.stickersIds_absent = stickersIds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageCreateMono(Possible<String> content, Possible<String> nonce, Possible<Boolean> enforceNonce, Possible<Boolean> tts, Possible<List<EmbedCreateSpec>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<Snowflake> messageReferenceId, Possible<MessageReferenceData> messageReference, Possible<List<TopLevelMessageComponent>> components, Possible<List<Snowflake>> stickersIds, Possible<PollCreateData> poll, Possible<List<Message.Flag>> flags, MessageChannel channel) {
        Possible<String> content$impl = content;
        Possible<String> nonce$impl = nonce;
        Possible<Boolean> enforceNonce$impl = enforceNonce;
        Possible<Boolean> tts$impl = tts;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<Snowflake> messageReferenceId$impl = messageReferenceId;
        Possible<MessageReferenceData> messageReference$impl = messageReference;
        Possible<List<TopLevelMessageComponent>> components$impl = components;
        Possible<List<Snowflake>> stickersIds$impl = stickersIds;
        Possible<PollCreateData> poll$impl = poll;
        Possible<List<Message.Flag>> flags$impl = flags;
        this.channel = channel;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReferenceId_value = messageReferenceId$impl.toOptional().orElse(null);
        this.messageReferenceId_absent = messageReferenceId$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.stickersIds_value = stickersIds$impl.toOptional().orElse(null);
        this.stickersIds_absent = stickersIds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<String> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of((Object)this.nonce_value);
    }

    @Override
    public Possible<Boolean> enforceNonce() {
        return this.enforceNonce_absent ? Possible.absent() : Possible.of((Object)this.enforceNonce_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    @Deprecated
    public Possible<Snowflake> messageReferenceId() {
        return this.messageReferenceId_absent ? Possible.absent() : Possible.of((Object)this.messageReferenceId_value);
    }

    @Override
    public Possible<MessageReferenceData> messageReference() {
        return this.messageReference_absent ? Possible.absent() : Possible.of((Object)this.messageReference_value);
    }

    @Override
    public Possible<List<TopLevelMessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public Possible<List<Snowflake>> stickersIds() {
        return this.stickersIds_absent ? Possible.absent() : Possible.of(this.stickersIds_value);
    }

    @Override
    public Possible<PollCreateData> poll() {
        return this.poll_absent ? Possible.absent() : Possible.of((Object)this.poll_value);
    }

    @Override
    public Possible<List<Message.Flag>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(this.flags_value);
    }

    @Override
    public MessageChannel channel() {
        return this.channel;
    }

    public MessageCreateMono withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(newValue, this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono((Possible<String>)newValue, this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withNonce(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), newValue, this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withNonce(String value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), (Possible<String>)newValue, this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withEnforceNonce(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withEnforceNonce(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), (Possible<Boolean>)newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), (Possible<Boolean>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    @SafeVarargs
    public final MessageCreateMono withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public final MessageCreateMono withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public final MessageCreateMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(elements, true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public final MessageCreateMono withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public final MessageCreateMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(elements, true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, newValue, this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, (Possible<AllowedMentions>)newValue, this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withMessageReferenceId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withMessageReferenceId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Snowflake>)newValue, this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withMessageReference(Possible<MessageReferenceData> value) {
        Possible<MessageReferenceData> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), newValue, this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withMessageReference(MessageReferenceData value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), (Possible<MessageReferenceData>)newValue, this.components(), this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withComponents(Possible<List<TopLevelMessageComponent>> possible) {
        Possible<List<TopLevelMessageComponent>> newValue = Objects.requireNonNull(possible);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), newValue, this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withComponents(Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), (Possible<List<TopLevelMessageComponent>>)newValue, this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    @SafeVarargs
    public final MessageCreateMono withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), (Possible<List<TopLevelMessageComponent>>)newValue, this.stickersIds(), this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withStickersIds(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), newValue, this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withStickersIds(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), (Possible<List<Snowflake>>)newValue, this.poll(), this.flags(), this.channel);
    }

    @SafeVarargs
    public final MessageCreateMono withStickersIds(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), (Possible<List<Snowflake>>)newValue, this.poll(), this.flags(), this.channel);
    }

    public MessageCreateMono withPoll(Possible<PollCreateData> value) {
        Possible<PollCreateData> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), newValue, this.flags(), this.channel);
    }

    public MessageCreateMono withPoll(PollCreateData value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), (Possible<PollCreateData>)newValue, this.flags(), this.channel);
    }

    public MessageCreateMono withFlags(Possible<List<Message.Flag>> possible) {
        Possible<List<Message.Flag>> newValue = Objects.requireNonNull(possible);
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), newValue, this.channel);
    }

    public MessageCreateMono withFlags(Iterable<Message.Flag> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), (Possible<List<Message.Flag>>)newValue, this.channel);
    }

    @SafeVarargs
    public final MessageCreateMono withFlags(Message.Flag ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), (Possible<List<Message.Flag>>)newValue, this.channel);
    }

    public final MessageCreateMono withChannel(MessageChannel value) {
        if (this.channel == value) {
            return this;
        }
        MessageChannel newValue = Objects.requireNonNull(value, "channel");
        return new MessageCreateMono(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageCreateMono && this.equalTo(0, (MessageCreateMono)another);
    }

    private boolean equalTo(int synthetic, MessageCreateMono another) {
        return this.content().equals(another.content()) && this.nonce().equals(another.nonce()) && this.enforceNonce().equals(another.enforceNonce()) && this.tts().equals(another.tts()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && this.messageReferenceId().equals(another.messageReferenceId()) && this.messageReference().equals(another.messageReference()) && Objects.equals(this.components_value, another.components_value) && Objects.equals(this.stickersIds_value, another.stickersIds_value) && this.poll().equals(another.poll()) && Objects.equals(this.flags_value, another.flags_value) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.enforceNonce().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + this.messageReferenceId().hashCode();
        h += (h << 5) + this.messageReference().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + Objects.hashCode(this.stickersIds_value);
        h += (h << 5) + this.poll().hashCode();
        h += (h << 5) + Objects.hashCode(this.flags_value);
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "MessageCreateMono{content=" + this.content().toString() + ", nonce=" + this.nonce().toString() + ", enforceNonce=" + this.enforceNonce().toString() + ", tts=" + this.tts().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", messageReferenceId=" + this.messageReferenceId().toString() + ", messageReference=" + this.messageReference().toString() + ", components=" + Objects.toString(this.components_value) + ", stickersIds=" + Objects.toString(this.stickersIds_value) + ", poll=" + this.poll().toString() + ", flags=" + Objects.toString(this.flags_value) + ", channel=" + this.channel + "}";
    }

    public static MessageCreateMono of(MessageChannel channel) {
        return new MessageCreateMono(channel);
    }

    static MessageCreateMono copyOf(MessageCreateMonoGenerator instance) {
        if (instance instanceof MessageCreateMono) {
            return (MessageCreateMono)instance;
        }
        return MessageCreateMono.of(instance.channel()).withContent((Possible<String>)instance.content()).withNonce((Possible<String>)instance.nonce()).withEnforceNonce((Possible<Boolean>)instance.enforceNonce()).withTts((Possible<Boolean>)instance.tts()).withEmbeds((Possible<List<EmbedCreateSpec>>)instance.embeds()).withFiles(instance.files()).withFileSpoilers(instance.fileSpoilers()).withAllowedMentions((Possible<AllowedMentions>)instance.allowedMentions()).withMessageReferenceId((Possible<Snowflake>)instance.messageReferenceId()).withMessageReference((Possible<MessageReferenceData>)instance.messageReference()).withComponents((Possible<List<TopLevelMessageComponent>>)instance.components()).withStickersIds((Possible<List<Snowflake>>)instance.stickersIds()).withPoll((Possible<PollCreateData>)instance.poll()).withFlags((Possible<List<Message.Flag>>)instance.flags());
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public String nonceOrElse(String defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public boolean isEnforceNoncePresent() {
        return !this.enforceNonce_absent;
    }

    public Boolean enforceNonceOrElse(Boolean defaultValue) {
        return !this.enforceNonce_absent ? this.enforceNonce_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isMessageReferenceIdPresent() {
        return !this.messageReferenceId_absent;
    }

    public Snowflake messageReferenceIdOrElse(Snowflake defaultValue) {
        return !this.messageReferenceId_absent ? this.messageReferenceId_value : defaultValue;
    }

    public boolean isMessageReferencePresent() {
        return !this.messageReference_absent;
    }

    public MessageReferenceData messageReferenceOrElse(MessageReferenceData defaultValue) {
        return !this.messageReference_absent ? this.messageReference_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isStickersIdsPresent() {
        return !this.stickersIds_absent;
    }

    public List<Snowflake> stickersIdsOrElse(List<Snowflake> defaultValue) {
        return !this.stickersIds_absent ? this.stickersIds_value : defaultValue;
    }

    public boolean isPollPresent() {
        return !this.poll_absent;
    }

    public PollCreateData pollOrElse(PollCreateData defaultValue) {
        return !this.poll_absent ? this.poll_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public List<Message.Flag> flagsOrElse(List<Message.Flag> defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(MessageCreateMono.super.files(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(MessageCreateMono.super.fileSpoilers(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build MessageCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

