/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.DiscordClient;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.spec.EntitlementListRequestFluxGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class EntitlementListRequestFlux
extends EntitlementListRequestFluxGenerator {
    private final Snowflake userId_value;
    private final boolean userId_absent;
    private final List<Snowflake> skuIds_value;
    private final boolean skuIds_absent;
    private final Snowflake before_value;
    private final boolean before_absent;
    private final Snowflake after_value;
    private final boolean after_absent;
    private final Integer limit_value;
    private final boolean limit_absent;
    private final Snowflake guildId_value;
    private final boolean guildId_absent;
    private final Boolean excludeEnded_value;
    private final boolean excludeEnded_absent;
    private final GatewayDiscordClient client;
    private final DiscordClient restClient;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private EntitlementListRequestFlux(GatewayDiscordClient client, DiscordClient restClient) {
        this.client = Objects.requireNonNull(client, "client");
        this.restClient = Objects.requireNonNull(restClient, "restClient");
        Possible userId$impl = Possible.absent();
        Possible skuIds$impl = Possible.absent();
        Possible before$impl = Possible.absent();
        Possible after$impl = Possible.absent();
        Possible limit$impl = Possible.absent();
        Possible guildId$impl = Possible.absent();
        Possible excludeEnded$impl = Possible.absent();
        this.userId_value = userId$impl.toOptional().orElse(null);
        this.userId_absent = userId$impl.isAbsent();
        this.skuIds_value = skuIds$impl.toOptional().orElse(null);
        this.skuIds_absent = skuIds$impl.isAbsent();
        this.before_value = before$impl.toOptional().orElse(null);
        this.before_absent = before$impl.isAbsent();
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.excludeEnded_value = excludeEnded$impl.toOptional().orElse(null);
        this.excludeEnded_absent = excludeEnded$impl.isAbsent();
        this.initShim = null;
    }

    private EntitlementListRequestFlux(Possible<Snowflake> userId, Possible<List<Snowflake>> skuIds, Possible<Snowflake> before, Possible<Snowflake> after, Possible<Integer> limit, Possible<Snowflake> guildId, Possible<Boolean> excludeEnded, GatewayDiscordClient client, DiscordClient restClient) {
        Possible<Snowflake> userId$impl = userId;
        Possible<List<Snowflake>> skuIds$impl = skuIds;
        Possible<Snowflake> before$impl = before;
        Possible<Snowflake> after$impl = after;
        Possible<Integer> limit$impl = limit;
        Possible<Snowflake> guildId$impl = guildId;
        Possible<Boolean> excludeEnded$impl = excludeEnded;
        this.client = client;
        this.restClient = restClient;
        this.userId_value = userId$impl.toOptional().orElse(null);
        this.userId_absent = userId$impl.isAbsent();
        this.skuIds_value = skuIds$impl.toOptional().orElse(null);
        this.skuIds_absent = skuIds$impl.isAbsent();
        this.before_value = before$impl.toOptional().orElse(null);
        this.before_absent = before$impl.isAbsent();
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.excludeEnded_value = excludeEnded$impl.toOptional().orElse(null);
        this.excludeEnded_absent = excludeEnded$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Snowflake> userId() {
        return this.userId_absent ? Possible.absent() : Possible.of((Object)this.userId_value);
    }

    @Override
    public Possible<List<Snowflake>> skuIds() {
        return this.skuIds_absent ? Possible.absent() : Possible.of(this.skuIds_value);
    }

    @Override
    public Possible<Snowflake> before() {
        return this.before_absent ? Possible.absent() : Possible.of((Object)this.before_value);
    }

    @Override
    public Possible<Snowflake> after() {
        return this.after_absent ? Possible.absent() : Possible.of((Object)this.after_value);
    }

    @Override
    public Possible<Integer> limit() {
        return this.limit_absent ? Possible.absent() : Possible.of((Object)this.limit_value);
    }

    @Override
    public Possible<Snowflake> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)this.guildId_value);
    }

    @Override
    public Possible<Boolean> excludeEnded() {
        return this.excludeEnded_absent ? Possible.absent() : Possible.of((Object)this.excludeEnded_value);
    }

    @Override
    public GatewayDiscordClient client() {
        return this.client;
    }

    @Override
    public DiscordClient restClient() {
        return this.restClient;
    }

    public EntitlementListRequestFlux withUserId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestFlux(newValue, this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withUserId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestFlux((Possible<Snowflake>)newValue, this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withSkuIds(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new EntitlementListRequestFlux(this.userId(), newValue, this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withSkuIds(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new EntitlementListRequestFlux(this.userId(), (Possible<List<Snowflake>>)newValue, this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    @SafeVarargs
    public final EntitlementListRequestFlux withSkuIds(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new EntitlementListRequestFlux(this.userId(), (Possible<List<Snowflake>>)newValue, this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withBefore(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), newValue, this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withBefore(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), (Possible<Snowflake>)newValue, this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withAfter(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), newValue, this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withAfter(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), (Possible<Snowflake>)newValue, this.limit(), this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), newValue, this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withLimit(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), (Possible<Integer>)newValue, this.guildId(), this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withGuildId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), newValue, this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withGuildId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), (Possible<Snowflake>)newValue, this.excludeEnded(), this.client, this.restClient);
    }

    public EntitlementListRequestFlux withExcludeEnded(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), newValue, this.client, this.restClient);
    }

    public EntitlementListRequestFlux withExcludeEnded(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), (Possible<Boolean>)newValue, this.client, this.restClient);
    }

    public final EntitlementListRequestFlux withClient(GatewayDiscordClient value) {
        if (this.client == value) {
            return this;
        }
        GatewayDiscordClient newValue = Objects.requireNonNull(value, "client");
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), newValue, this.restClient);
    }

    public final EntitlementListRequestFlux withRestClient(DiscordClient value) {
        if (this.restClient == value) {
            return this;
        }
        DiscordClient newValue = Objects.requireNonNull(value, "restClient");
        return new EntitlementListRequestFlux(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded(), this.client, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EntitlementListRequestFlux && this.equalTo(0, (EntitlementListRequestFlux)another);
    }

    private boolean equalTo(int synthetic, EntitlementListRequestFlux another) {
        return this.userId().equals(another.userId()) && Objects.equals(this.skuIds_value, another.skuIds_value) && this.before().equals(another.before()) && this.after().equals(another.after()) && this.limit().equals(another.limit()) && this.guildId().equals(another.guildId()) && this.excludeEnded().equals(another.excludeEnded()) && this.client.equals(another.client) && ((Object)((Object)this.restClient)).equals((Object)another.restClient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId().hashCode();
        h += (h << 5) + Objects.hashCode(this.skuIds_value);
        h += (h << 5) + this.before().hashCode();
        h += (h << 5) + this.after().hashCode();
        h += (h << 5) + this.limit().hashCode();
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.excludeEnded().hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + ((Object)((Object)this.restClient)).hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "EntitlementListRequestFlux{userId=" + this.userId().toString() + ", skuIds=" + Objects.toString(this.skuIds_value) + ", before=" + this.before().toString() + ", after=" + this.after().toString() + ", limit=" + this.limit().toString() + ", guildId=" + this.guildId().toString() + ", excludeEnded=" + this.excludeEnded().toString() + ", client=" + this.client + ", restClient=" + (Object)((Object)this.restClient) + "}";
    }

    public static EntitlementListRequestFlux of(GatewayDiscordClient client, DiscordClient restClient) {
        return new EntitlementListRequestFlux(client, restClient);
    }

    static EntitlementListRequestFlux copyOf(EntitlementListRequestFluxGenerator instance) {
        if (instance instanceof EntitlementListRequestFlux) {
            return (EntitlementListRequestFlux)instance;
        }
        return EntitlementListRequestFlux.of(instance.client(), instance.restClient()).withUserId((Possible<Snowflake>)instance.userId()).withSkuIds((Possible<List<Snowflake>>)instance.skuIds()).withBefore((Possible<Snowflake>)instance.before()).withAfter((Possible<Snowflake>)instance.after()).withLimit((Possible<Integer>)instance.limit()).withGuildId((Possible<Snowflake>)instance.guildId()).withExcludeEnded((Possible<Boolean>)instance.excludeEnded());
    }

    public boolean isUserIdPresent() {
        return !this.userId_absent;
    }

    public Snowflake userIdOrElse(Snowflake defaultValue) {
        return !this.userId_absent ? this.userId_value : defaultValue;
    }

    public boolean isSkuIdsPresent() {
        return !this.skuIds_absent;
    }

    public List<Snowflake> skuIdsOrElse(List<Snowflake> defaultValue) {
        return !this.skuIds_absent ? this.skuIds_value : defaultValue;
    }

    public boolean isBeforePresent() {
        return !this.before_absent;
    }

    public Snowflake beforeOrElse(Snowflake defaultValue) {
        return !this.before_absent ? this.before_value : defaultValue;
    }

    public boolean isAfterPresent() {
        return !this.after_absent;
    }

    public Snowflake afterOrElse(Snowflake defaultValue) {
        return !this.after_absent ? this.after_value : defaultValue;
    }

    public boolean isLimitPresent() {
        return !this.limit_absent;
    }

    public Integer limitOrElse(Integer defaultValue) {
        return !this.limit_absent ? this.limit_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public Snowflake guildIdOrElse(Snowflake defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isExcludeEndedPresent() {
        return !this.excludeEnded_absent;
    }

    public Boolean excludeEndedOrElse(Boolean defaultValue) {
        return !this.excludeEnded_absent ? this.excludeEnded_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build EntitlementListRequestFlux, attribute initializers form cycle " + attributes;
        }
    }
}

