/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.ApplicationEditSpecGenerator;
import discord4j.discordjson.json.InstallParamsData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ApplicationEditSpec
implements ApplicationEditSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String customInstallUrl_value;
    private final boolean customInstallUrl_absent;
    private final String description_value;
    private final boolean description_absent;
    private final String roleConnectionsVerificationUrl_value;
    private final boolean roleConnectionsVerificationUrl_absent;
    private final InstallParamsData installParams_value;
    private final boolean installParams_absent;
    private final Integer flags_value;
    private final boolean flags_absent;
    private final Image icon_value;
    private final boolean icon_absent;
    private final Image coverImage_value;
    private final boolean coverImage_absent;
    private final String interactionsEndpointUrl_value;
    private final boolean interactionsEndpointUrl_absent;
    private final List<String> tags_value;
    private final boolean tags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ApplicationEditSpec INSTANCE = ApplicationEditSpec.validate(new ApplicationEditSpec());

    private ApplicationEditSpec() {
        this.reason = null;
        Possible customInstallUrl$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        Possible roleConnectionsVerificationUrl$impl = Possible.absent();
        Possible installParams$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        Possible icon$impl = Possible.absent();
        Possible coverImage$impl = Possible.absent();
        Possible interactionsEndpointUrl$impl = Possible.absent();
        Possible tags$impl = Possible.absent();
        this.customInstallUrl_value = customInstallUrl$impl.toOptional().orElse(null);
        this.customInstallUrl_absent = customInstallUrl$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.roleConnectionsVerificationUrl_value = roleConnectionsVerificationUrl$impl.toOptional().orElse(null);
        this.roleConnectionsVerificationUrl_absent = roleConnectionsVerificationUrl$impl.isAbsent();
        this.installParams_value = installParams$impl.toOptional().orElse(null);
        this.installParams_absent = installParams$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.icon_value = Possible.flatOpt((Possible)icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.coverImage_value = Possible.flatOpt((Possible)coverImage$impl).orElse(null);
        this.coverImage_absent = coverImage$impl.isAbsent();
        this.interactionsEndpointUrl_value = interactionsEndpointUrl$impl.toOptional().orElse(null);
        this.interactionsEndpointUrl_absent = interactionsEndpointUrl$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    private ApplicationEditSpec(@reactor.util.annotation.Nullable String reason, Possible<String> customInstallUrl, Possible<String> description, Possible<String> roleConnectionsVerificationUrl, Possible<InstallParamsData> installParams, Possible<Integer> flags, Possible<Optional<Image>> icon, Possible<Optional<Image>> coverImage, Possible<String> interactionsEndpointUrl, Possible<List<String>> tags) {
        this.reason = reason;
        Possible<String> customInstallUrl$impl = customInstallUrl;
        Possible<String> description$impl = description;
        Possible<String> roleConnectionsVerificationUrl$impl = roleConnectionsVerificationUrl;
        Possible<InstallParamsData> installParams$impl = installParams;
        Possible<Integer> flags$impl = flags;
        Possible<Optional<Image>> icon$impl = icon;
        Possible<Optional<Image>> coverImage$impl = coverImage;
        Possible<String> interactionsEndpointUrl$impl = interactionsEndpointUrl;
        Possible<List<String>> tags$impl = tags;
        this.customInstallUrl_value = customInstallUrl$impl.toOptional().orElse(null);
        this.customInstallUrl_absent = customInstallUrl$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.roleConnectionsVerificationUrl_value = roleConnectionsVerificationUrl$impl.toOptional().orElse(null);
        this.roleConnectionsVerificationUrl_absent = roleConnectionsVerificationUrl$impl.isAbsent();
        this.installParams_value = installParams$impl.toOptional().orElse(null);
        this.installParams_absent = installParams$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.coverImage_value = Possible.flatOpt(coverImage$impl).orElse(null);
        this.coverImage_absent = coverImage$impl.isAbsent();
        this.interactionsEndpointUrl_value = interactionsEndpointUrl$impl.toOptional().orElse(null);
        this.interactionsEndpointUrl_absent = interactionsEndpointUrl$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> customInstallUrl() {
        return this.customInstallUrl_absent ? Possible.absent() : Possible.of((Object)this.customInstallUrl_value);
    }

    @Override
    public Possible<String> description() {
        return this.description_absent ? Possible.absent() : Possible.of((Object)this.description_value);
    }

    @Override
    public Possible<String> roleConnectionsVerificationUrl() {
        return this.roleConnectionsVerificationUrl_absent ? Possible.absent() : Possible.of((Object)this.roleConnectionsVerificationUrl_value);
    }

    @Override
    public Possible<InstallParamsData> installParams() {
        return this.installParams_absent ? Possible.absent() : Possible.of((Object)this.installParams_value);
    }

    @Override
    public Possible<Integer> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of((Object)this.flags_value);
    }

    @Override
    public Possible<Optional<Image>> icon() {
        return this.icon_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.icon_value));
    }

    @Override
    public Possible<Optional<Image>> coverImage() {
        return this.coverImage_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.coverImage_value));
    }

    @Override
    public Possible<String> interactionsEndpointUrl() {
        return this.interactionsEndpointUrl_absent ? Possible.absent() : Possible.of((Object)this.interactionsEndpointUrl_value);
    }

    @Override
    public Possible<List<String>> tags() {
        return this.tags_absent ? Possible.absent() : Possible.of(this.tags_value);
    }

    public final ApplicationEditSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return ApplicationEditSpec.validate(new ApplicationEditSpec(value, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withCustomInstallUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, newValue, this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withCustomInstallUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, (Possible<String>)newValue, this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withDescription(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), newValue, this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withDescription(String value) {
        Possible newValue = Possible.of((Object)value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), (Possible<String>)newValue, this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withRoleConnectionsVerificationUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), newValue, this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withRoleConnectionsVerificationUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), (Possible<String>)newValue, this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withInstallParams(Possible<InstallParamsData> value) {
        Possible<InstallParamsData> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), newValue, this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withInstallParams(InstallParamsData value) {
        Possible newValue = Possible.of((Object)value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), (Possible<InstallParamsData>)newValue, this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withFlags(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), newValue, this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withFlags(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), (Possible<Integer>)newValue, this.icon(), this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withIcon(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), newValue, this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    @Deprecated
    public ApplicationEditSpec withIcon(@Nullable Image value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), (Possible<Optional<Image>>)newValue, this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withIconOrNull(@Nullable Image value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), (Possible<Optional<Image>>)newValue, this.coverImage(), this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withCoverImage(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), newValue, this.interactionsEndpointUrl(), this.tags()));
    }

    @Deprecated
    public ApplicationEditSpec withCoverImage(@Nullable Image value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), (Possible<Optional<Image>>)newValue, this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withCoverImageOrNull(@Nullable Image value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), (Possible<Optional<Image>>)newValue, this.interactionsEndpointUrl(), this.tags()));
    }

    public ApplicationEditSpec withInteractionsEndpointUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), newValue, this.tags()));
    }

    public ApplicationEditSpec withInteractionsEndpointUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), (Possible<String>)newValue, this.tags()));
    }

    public ApplicationEditSpec withTags(Possible<List<String>> possible) {
        Possible<List<String>> newValue = Objects.requireNonNull(possible);
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), newValue));
    }

    public ApplicationEditSpec withTags(Iterable<String> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), (Possible<List<String>>)newValue));
    }

    @SafeVarargs
    public final ApplicationEditSpec withTags(String ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl(), this.description(), this.roleConnectionsVerificationUrl(), this.installParams(), this.flags(), this.icon(), this.coverImage(), this.interactionsEndpointUrl(), (Possible<List<String>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationEditSpec && this.equalTo(0, (ApplicationEditSpec)another);
    }

    private boolean equalTo(int synthetic, ApplicationEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.customInstallUrl().equals(another.customInstallUrl()) && this.description().equals(another.description()) && this.roleConnectionsVerificationUrl().equals(another.roleConnectionsVerificationUrl()) && this.installParams().equals(another.installParams()) && this.flags().equals(another.flags()) && this.icon().equals(another.icon()) && this.coverImage().equals(another.coverImage()) && this.interactionsEndpointUrl().equals(another.interactionsEndpointUrl()) && Objects.equals(this.tags_value, another.tags_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.customInstallUrl().hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.roleConnectionsVerificationUrl().hashCode();
        h += (h << 5) + this.installParams().hashCode();
        h += (h << 5) + this.flags().hashCode();
        h += (h << 5) + this.icon().hashCode();
        h += (h << 5) + this.coverImage().hashCode();
        h += (h << 5) + this.interactionsEndpointUrl().hashCode();
        h += (h << 5) + Objects.hashCode(this.tags_value);
        return h;
    }

    public String toString() {
        return "ApplicationEditSpec{reason=" + this.reason + ", customInstallUrl=" + this.customInstallUrl().toString() + ", description=" + this.description().toString() + ", roleConnectionsVerificationUrl=" + this.roleConnectionsVerificationUrl().toString() + ", installParams=" + this.installParams().toString() + ", flags=" + this.flags().toString() + ", icon=" + this.icon().toString() + ", coverImage=" + this.coverImage().toString() + ", interactionsEndpointUrl=" + this.interactionsEndpointUrl().toString() + ", tags=" + Objects.toString(this.tags_value) + "}";
    }

    public static ApplicationEditSpec create() {
        return INSTANCE;
    }

    private static ApplicationEditSpec validate(ApplicationEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static ApplicationEditSpec copyOf(ApplicationEditSpecGenerator instance) {
        if (instance instanceof ApplicationEditSpec) {
            return (ApplicationEditSpec)instance;
        }
        return ApplicationEditSpec.builder().from(instance).build();
    }

    public boolean isCustomInstallUrlPresent() {
        return !this.customInstallUrl_absent;
    }

    public String customInstallUrlOrElse(String defaultValue) {
        return !this.customInstallUrl_absent ? this.customInstallUrl_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isRoleConnectionsVerificationUrlPresent() {
        return !this.roleConnectionsVerificationUrl_absent;
    }

    public String roleConnectionsVerificationUrlOrElse(String defaultValue) {
        return !this.roleConnectionsVerificationUrl_absent ? this.roleConnectionsVerificationUrl_value : defaultValue;
    }

    public boolean isInstallParamsPresent() {
        return !this.installParams_absent;
    }

    public InstallParamsData installParamsOrElse(InstallParamsData defaultValue) {
        return !this.installParams_absent ? this.installParams_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public Integer flagsOrElse(Integer defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public boolean isIconPresent() {
        return !this.icon_absent;
    }

    public Image iconOrElse(Image defaultValue) {
        return !this.icon_absent ? this.icon_value : defaultValue;
    }

    public boolean isCoverImagePresent() {
        return !this.coverImage_absent;
    }

    public Image coverImageOrElse(Image defaultValue) {
        return !this.coverImage_absent ? this.coverImage_value : defaultValue;
    }

    public boolean isInteractionsEndpointUrlPresent() {
        return !this.interactionsEndpointUrl_absent;
    }

    public String interactionsEndpointUrlOrElse(String defaultValue) {
        return !this.interactionsEndpointUrl_absent ? this.interactionsEndpointUrl_value : defaultValue;
    }

    public boolean isTagsPresent() {
        return !this.tags_absent;
    }

    public List<String> tagsOrElse(List<String> defaultValue) {
        return !this.tags_absent ? this.tags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> customInstallUrl_possible = Possible.absent();
        private Possible<String> description_possible = Possible.absent();
        private Possible<String> roleConnectionsVerificationUrl_possible = Possible.absent();
        private Possible<InstallParamsData> installParams_possible = Possible.absent();
        private Possible<Integer> flags_possible = Possible.absent();
        private Possible<Optional<Image>> icon_possible = Possible.absent();
        private Possible<Optional<Image>> coverImage_possible = Possible.absent();
        private Possible<String> interactionsEndpointUrl_possible = Possible.absent();
        private List<String> tags_list = null;
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(ApplicationEditSpec instance) {
            return this.from((ApplicationEditSpecGenerator)instance);
        }

        final Builder from(ApplicationEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.customInstallUrl(instance.customInstallUrl());
            this.description(instance.description());
            this.roleConnectionsVerificationUrl(instance.roleConnectionsVerificationUrl());
            this.installParams(instance.installParams());
            this.flags(instance.flags());
            this.icon(instance.icon());
            this.coverImage(instance.coverImage());
            this.interactionsEndpointUrl(instance.interactionsEndpointUrl());
            this.tags(instance.tags());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder customInstallUrl(Possible<String> value) {
            this.customInstallUrl_possible = value;
            return this;
        }

        public Builder customInstallUrl(String value) {
            this.customInstallUrl_possible = Possible.of((Object)value);
            return this;
        }

        public Builder description(Possible<String> value) {
            this.description_possible = value;
            return this;
        }

        public Builder description(String value) {
            this.description_possible = Possible.of((Object)value);
            return this;
        }

        public Builder roleConnectionsVerificationUrl(Possible<String> value) {
            this.roleConnectionsVerificationUrl_possible = value;
            return this;
        }

        public Builder roleConnectionsVerificationUrl(String value) {
            this.roleConnectionsVerificationUrl_possible = Possible.of((Object)value);
            return this;
        }

        public Builder installParams(Possible<InstallParamsData> value) {
            this.installParams_possible = value;
            return this;
        }

        public Builder installParams(InstallParamsData value) {
            this.installParams_possible = Possible.of((Object)value);
            return this;
        }

        public Builder flags(Possible<Integer> value) {
            this.flags_possible = value;
            return this;
        }

        public Builder flags(Integer value) {
            this.flags_possible = Possible.of((Object)value);
            return this;
        }

        public Builder icon(Possible<Optional<Image>> value) {
            this.icon_possible = value;
            return this;
        }

        @Deprecated
        public Builder icon(@Nullable Image value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder iconOrNull(@Nullable Image value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder coverImage(Possible<Optional<Image>> value) {
            this.coverImage_possible = value;
            return this;
        }

        @Deprecated
        public Builder coverImage(@Nullable Image value) {
            this.coverImage_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder coverImageOrNull(@Nullable Image value) {
            this.coverImage_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder interactionsEndpointUrl(Possible<String> value) {
            this.interactionsEndpointUrl_possible = value;
            return this;
        }

        public Builder interactionsEndpointUrl(String value) {
            this.interactionsEndpointUrl_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addTag(String element) {
            this.tags_getOrCreate().add(element);
            return this;
        }

        public Builder addAllTags(List<String> elements) {
            this.tags_getOrCreate().addAll(elements);
            return this;
        }

        public Builder tags(Possible<List<String>> elements) {
            this.tags_list = null;
            elements.toOptional().ifPresent(e -> this.tags_getOrCreate().addAll((Collection<String>)e));
            return this;
        }

        public Builder tags(List<String> elements) {
            this.tags_list = new ArrayList<String>(elements);
            return this;
        }

        public Builder tags(Iterable<String> elements) {
            this.tags_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public ApplicationEditSpec build() {
            return ApplicationEditSpec.validate(new ApplicationEditSpec(this.reason, this.customInstallUrl_build(), this.description_build(), this.roleConnectionsVerificationUrl_build(), this.installParams_build(), this.flags_build(), this.icon_build(), this.coverImage_build(), this.interactionsEndpointUrl_build(), this.tags_build()));
        }

        private Possible<String> customInstallUrl_build() {
            return this.customInstallUrl_possible;
        }

        private Possible<String> description_build() {
            return this.description_possible;
        }

        private Possible<String> roleConnectionsVerificationUrl_build() {
            return this.roleConnectionsVerificationUrl_possible;
        }

        private Possible<InstallParamsData> installParams_build() {
            return this.installParams_possible;
        }

        private Possible<Integer> flags_build() {
            return this.flags_possible;
        }

        private Possible<Optional<Image>> icon_build() {
            return this.icon_possible;
        }

        private Possible<Optional<Image>> coverImage_build() {
            return this.coverImage_possible;
        }

        private Possible<String> interactionsEndpointUrl_build() {
            return this.interactionsEndpointUrl_possible;
        }

        private Possible<List<String>> tags_build() {
            return this.tags_list == null ? Possible.absent() : Possible.of(this.tags_list);
        }

        private List<String> tags_getOrCreate() {
            if (this.tags_list == null) {
                this.tags_list = new ArrayList<String>();
            }
            return this.tags_list;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

