/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.discordjson.json.UnfurledMediaItemData;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;

public class UnfurledMediaItem {
    private final UnfurledMediaItemData data;

    public static UnfurledMediaItem of(String url) {
        return new UnfurledMediaItem((UnfurledMediaItemData)UnfurledMediaItemData.builder().url(url).build());
    }

    public UnfurledMediaItem(UnfurledMediaItemData data) {
        this.data = data;
    }

    public UnfurledMediaItemData getData() {
        return this.data;
    }

    public String getURL() {
        return this.getData().url();
    }

    public Optional<String> getProxyUrl() {
        return this.getData().proxyUrl().toOptional();
    }

    public int getWidth() {
        return Possible.flatOpt((Possible)this.getData().width()).orElse(0);
    }

    public int getHeight() {
        return Possible.flatOpt((Possible)this.getData().height()).orElse(0);
    }

    public String getContentType() {
        return Possible.flatOpt((Possible)this.getData().contentType()).orElse("");
    }

    public Optional<LoadingState> getLoadingState() {
        return Possible.flatOpt((Possible)this.getData().loadingState()).map(LoadingState::of);
    }

    static enum LoadingState {
        UNKNOWN(0),
        LOADING(1),
        LOADED_SUCCESS(2),
        LOADED_NOT_FOUND(3);

        private final int value;

        private LoadingState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LoadingState of(int value) {
            switch (value) {
                case 1: {
                    return LOADING;
                }
                case 2: {
                    return LOADED_SUCCESS;
                }
                case 3: {
                    return LOADED_NOT_FOUND;
                }
            }
            return UNKNOWN;
        }
    }
}

