/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandContexts;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.ApplicationIntegrationType;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.monetization.Entitlement;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationCommandInteractionData;
import discord4j.discordjson.json.EntitlementData;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.UserData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@Experimental
public class Interaction
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final InteractionData data;

    public Interaction(GatewayDiscordClient gateway, InteractionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public InteractionData getData() {
        return this.data;
    }

    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public Snowflake getApplicationId() {
        return Snowflake.of((Id)this.data.applicationId());
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public Optional<ApplicationCommandInteraction> getCommandInteraction() {
        return this.data.data().toOptional().map(data -> new ApplicationCommandInteraction(this.getClient(), (ApplicationCommandInteractionData)data, this.getGuildId().map(Snowflake::asLong).orElse(null)));
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.gateway::getGuildById);
    }

    public Snowflake getChannelId() {
        return Snowflake.of((Id)((Id)this.data.channelId().get()));
    }

    public Mono<MessageChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Optional<Member> getMember() {
        return this.data.member().toOptional().map(data -> new Member(this.gateway, (MemberData)data, this.getGuildId().get().asLong()));
    }

    public User getUser() {
        UserData userData = this.data.member().isAbsent() ? (UserData)this.data.user().get() : ((MemberData)this.data.member().get()).user();
        return new User(this.getClient(), userData);
    }

    public String getToken() {
        return this.data.token();
    }

    public Optional<Message> getMessage() {
        return this.data.message().toOptional().map(data -> new Message(this.gateway, (MessageData)data));
    }

    public Optional<Snowflake> getMessageId() {
        return this.data.message().toOptional().map(data -> Snowflake.of((Id)data.id()));
    }

    public String getUserLocale() {
        return this.data.locale().toOptional().orElse("en-US");
    }

    public Optional<String> getGuildLocale() {
        return this.data.guildLocale().toOptional();
    }

    public Optional<Snowflake> getAuthorizingIntegrationOwner(ApplicationIntegrationType type) {
        return Optional.ofNullable((String)this.data.authorizingIntegrationOwners().get(type.getValue())).map(Snowflake::of);
    }

    public Map<ApplicationIntegrationType, Snowflake> getAuthorizingIntegrationOwners() {
        return this.data.authorizingIntegrationOwners().entrySet().stream().collect(Collectors.toMap(entry -> ApplicationIntegrationType.of((Integer)entry.getKey()), entry -> Snowflake.of((String)((String)entry.getValue()))));
    }

    public Optional<ApplicationCommandContexts> getContext() {
        return this.data.context().toOptional().map(ApplicationCommandContexts::of);
    }

    @Experimental
    public List<Entitlement> getEntitlements() {
        return this.data.entitlements().stream().map(entitlementData -> new Entitlement(this.gateway, (EntitlementData)entitlementData)).collect(Collectors.toList());
    }

    @Experimental
    public boolean hasUserEntitlement() {
        User user = this.getUser();
        return this.data.entitlements().stream().anyMatch(entitlementData -> !entitlementData.userId().isAbsent() && ((Id)entitlementData.userId().get()).asLong() == user.getId().asLong());
    }

    @Experimental
    public boolean hasGuildEntitlement() {
        if (this.data.guildId().isAbsent()) {
            return false;
        }
        return this.data.entitlements().stream().anyMatch(entitlementData -> !entitlementData.guildId().isAbsent() && ((Id)entitlementData.guildId().get()).asLong() == ((Id)this.data.guildId().get()).asLong());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Type {
        UNKNOWN(-1),
        PING(1),
        APPLICATION_COMMAND(2),
        MESSAGE_COMPONENT(3),
        APPLICATION_COMMAND_AUTOCOMPLETE(4),
        MODAL_SUBMIT(5);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return PING;
                }
                case 2: {
                    return APPLICATION_COMMAND;
                }
                case 3: {
                    return MESSAGE_COMPONENT;
                }
                case 4: {
                    return APPLICATION_COMMAND_AUTOCOMPLETE;
                }
                case 5: {
                    return MODAL_SUBMIT;
                }
            }
            return UNKNOWN;
        }
    }
}

