/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.store.api.object.PresenceAndUserData;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.ApplicationCommandDispatchHandlers;
import discord4j.core.event.dispatch.ChannelDispatchHandlers;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.dispatch.DispatchEventMapper;
import discord4j.core.event.dispatch.DispatchHandler;
import discord4j.core.event.dispatch.GuildDispatchHandlers;
import discord4j.core.event.dispatch.LifecycleDispatchHandlers;
import discord4j.core.event.dispatch.MessageDispatchHandlers;
import discord4j.core.event.dispatch.MonetizationDispatchHandlers;
import discord4j.core.event.dispatch.PollDispatchHandlers;
import discord4j.core.event.domain.AuditLogEntryCreateEvent;
import discord4j.core.event.domain.Event;
import discord4j.core.event.domain.InviteCreateEvent;
import discord4j.core.event.domain.InviteDeleteEvent;
import discord4j.core.event.domain.PresenceUpdateEvent;
import discord4j.core.event.domain.UserUpdateEvent;
import discord4j.core.event.domain.VoiceServerUpdateEvent;
import discord4j.core.event.domain.VoiceStateUpdateEvent;
import discord4j.core.event.domain.WebhooksUpdateEvent;
import discord4j.core.event.domain.automod.AutoModActionExecutedEvent;
import discord4j.core.event.domain.automod.AutoModRuleCreateEvent;
import discord4j.core.event.domain.automod.AutoModRuleDeleteEvent;
import discord4j.core.event.domain.automod.AutoModRuleUpdateEvent;
import discord4j.core.event.domain.channel.TypingStartEvent;
import discord4j.core.event.domain.integration.IntegrationCreateEvent;
import discord4j.core.event.domain.integration.IntegrationDeleteEvent;
import discord4j.core.event.domain.integration.IntegrationUpdateEvent;
import discord4j.core.event.domain.interaction.ApplicationCommandInteractionEvent;
import discord4j.core.event.domain.interaction.ButtonInteractionEvent;
import discord4j.core.event.domain.interaction.ChatInputAutoCompleteEvent;
import discord4j.core.event.domain.interaction.ChatInputInteractionEvent;
import discord4j.core.event.domain.interaction.ComponentInteractionEvent;
import discord4j.core.event.domain.interaction.InteractionCreateEvent;
import discord4j.core.event.domain.interaction.MessageInteractionEvent;
import discord4j.core.event.domain.interaction.ModalSubmitInteractionEvent;
import discord4j.core.event.domain.interaction.SelectMenuInteractionEvent;
import discord4j.core.event.domain.interaction.UserInteractionEvent;
import discord4j.core.object.VoiceState;
import discord4j.core.object.audit.AuditLogEntry;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.command.ApplicationCommand;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Integration;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.presence.Presence;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AuditLogEntryData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ApplicationCommandCreate;
import discord4j.discordjson.json.gateway.ApplicationCommandDelete;
import discord4j.discordjson.json.gateway.ApplicationCommandPermissionUpdate;
import discord4j.discordjson.json.gateway.ApplicationCommandUpdate;
import discord4j.discordjson.json.gateway.AuditLogEntryCreate;
import discord4j.discordjson.json.gateway.AutoModActionExecution;
import discord4j.discordjson.json.gateway.AutoModRuleCreate;
import discord4j.discordjson.json.gateway.AutoModRuleDelete;
import discord4j.discordjson.json.gateway.AutoModRuleUpdate;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelPinsUpdate;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.EntitlementCreate;
import discord4j.discordjson.json.gateway.EntitlementDelete;
import discord4j.discordjson.json.gateway.EntitlementUpdate;
import discord4j.discordjson.json.gateway.GuildBanAdd;
import discord4j.discordjson.json.gateway.GuildBanRemove;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildIntegrationsUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventCreate;
import discord4j.discordjson.json.gateway.GuildScheduledEventDelete;
import discord4j.discordjson.json.gateway.GuildScheduledEventUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserAdd;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserRemove;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.IntegrationCreate;
import discord4j.discordjson.json.gateway.IntegrationDelete;
import discord4j.discordjson.json.gateway.IntegrationUpdate;
import discord4j.discordjson.json.gateway.InteractionCreate;
import discord4j.discordjson.json.gateway.InviteCreate;
import discord4j.discordjson.json.gateway.InviteDelete;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.PollVoteAdd;
import discord4j.discordjson.json.gateway.PollVoteRemove;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.Resumed;
import discord4j.discordjson.json.gateway.TypingStart;
import discord4j.discordjson.json.gateway.UnavailableGuildCreate;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceServerUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.discordjson.json.gateway.WebhooksUpdate;
import discord4j.gateway.retry.GatewayStateChange;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class DispatchHandlers
implements DispatchEventMapper {
    private static final Map<Class<?>, DispatchHandler<?, ?, ?>> handlerMap = new HashMap();
    private static final Logger log;

    private static <D, S, E extends Event> void addHandler(Class<D> dispatchType, DispatchHandler<D, S, E> dispatchHandler) {
        handlerMap.put(dispatchType, dispatchHandler);
    }

    @Override
    public <D, S, E extends Event> Mono<E> handle(DispatchContext<D, S> context) {
        DispatchHandler handler = handlerMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(context.getDispatch().getClass())).map(Map.Entry::getValue).findFirst().orElse(null);
        if (handler == null) {
            log.warn("Handler not found from: {}", new Object[]{context.getDispatch().getClass()});
            return Mono.empty();
        }
        return Mono.defer(() -> handler.handle(context)).checkpoint("Dispatch handled for " + context.getDispatch().getClass());
    }

    private static Mono<PresenceUpdateEvent> presenceUpdate(DispatchContext<PresenceUpdate, PresenceAndUserData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        PartialUserData userData = context.getDispatch().user();
        PresenceData presenceData = DispatchHandlers.createPresence(context.getDispatch());
        Presence current = new Presence(presenceData);
        Presence oldPresence = context.getOldState().flatMap(PresenceAndUserData::getPresenceData).map(Presence::new).orElse(null);
        User oldUser = context.getOldState().flatMap(PresenceAndUserData::getUserData).map(old -> new User(gateway, (UserData)old)).orElse(null);
        return Mono.just((Object)new PresenceUpdateEvent(gateway, context.getShardInfo(), guildId, oldUser, userData, current, oldPresence));
    }

    private static PresenceData createPresence(PresenceUpdate update) {
        return PresenceData.builder().user(update.user()).status(update.status()).activities((Iterable)update.activities()).clientStatus(update.clientStatus()).build();
    }

    private static Mono<TypingStartEvent> typingStart(DispatchContext<TypingStart, Void> context) {
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        long userId = Snowflake.asLong((Id)context.getDispatch().userId());
        Instant startTime = Instant.ofEpochSecond(context.getDispatch().timestamp());
        Member member = context.getDispatch().member().toOptional().filter(__ -> guildId != null).map(memberData -> new Member(context.getGateway(), (MemberData)memberData, guildId)).orElse(null);
        return Mono.just((Object)new TypingStartEvent(context.getGateway(), context.getShardInfo(), channelId, guildId, userId, startTime, member));
    }

    private static Mono<UserUpdateEvent> userUpdate(DispatchContext<UserUpdate, UserData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        UserData userData = context.getDispatch().user();
        User current = new User(gateway, userData);
        return Mono.just((Object)new UserUpdateEvent(gateway, context.getShardInfo(), current, context.getOldState().map(old -> new User(gateway, (UserData)old)).orElse(null)));
    }

    private static Mono<Event> voiceServerUpdate(DispatchContext<VoiceServerUpdate, Void> context) {
        String token = context.getDispatch().token();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        String endpoint = context.getDispatch().endpoint();
        return Mono.just((Object)new VoiceServerUpdateEvent(context.getGateway(), context.getShardInfo(), token, guildId, endpoint));
    }

    private static Mono<VoiceStateUpdateEvent> voiceStateUpdateDispatch(DispatchContext<VoiceStateUpdateDispatch, VoiceStateData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        VoiceStateData voiceStateData = context.getDispatch().voiceState();
        VoiceState current = new VoiceState(gateway, voiceStateData);
        return Mono.just((Object)new VoiceStateUpdateEvent(gateway, context.getShardInfo(), current, context.getOldState().map(old -> new VoiceState(gateway, (VoiceStateData)old)).orElse(null)));
    }

    private static Mono<Event> webhooksUpdate(DispatchContext<WebhooksUpdate, Void> context) {
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        return Mono.just((Object)new WebhooksUpdateEvent(context.getGateway(), context.getShardInfo(), guildId, channelId));
    }

    private static Mono<AuditLogEntryCreateEvent> auditLogEntryCreate(DispatchContext<AuditLogEntryCreate, Void> context) {
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        AuditLogEntry auditLogEntry = new AuditLogEntry(context.getGateway(), (AuditLogEntryData)context.getDispatch());
        return Mono.just((Object)new AuditLogEntryCreateEvent(context.getGateway(), context.getShardInfo(), guildId, auditLogEntry));
    }

    private static Mono<InviteCreateEvent> inviteCreate(DispatchContext<InviteCreate, Void> context) {
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        String code = context.getDispatch().code();
        Instant createdAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)context.getDispatch().createdAt(), Instant::from);
        int uses = context.getDispatch().uses();
        int maxUses = context.getDispatch().maxUses();
        int maxAge = context.getDispatch().maxAge();
        boolean temporary = context.getDispatch().temporary();
        User current = context.getDispatch().inviter().toOptional().map(userData -> new User(context.getGateway(), (UserData)userData)).orElse(null);
        return Mono.just((Object)new InviteCreateEvent(context.getGateway(), context.getShardInfo(), guildId, channelId, code, current, createdAt, uses, maxUses, maxAge, temporary));
    }

    private static Mono<InviteDeleteEvent> inviteDelete(DispatchContext<InviteDelete, Void> context) {
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        String code = context.getDispatch().code();
        return Mono.just((Object)new InviteDeleteEvent(context.getGateway(), context.getShardInfo(), guildId, channelId, code));
    }

    private static Mono<InteractionCreateEvent> interactionCreate(DispatchContext<InteractionCreate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        Interaction interaction = new Interaction(gateway, context.getDispatch().interaction());
        switch (interaction.getType()) {
            case APPLICATION_COMMAND: {
                ApplicationCommand.Type commandType = (ApplicationCommand.Type)((Object)interaction.getCommandInteraction().flatMap(ApplicationCommandInteraction::getApplicationCommandType).orElseThrow(IllegalStateException::new));
                switch (commandType) {
                    case CHAT_INPUT: {
                        return Mono.just((Object)new ChatInputInteractionEvent(gateway, context.getShardInfo(), interaction));
                    }
                    case MESSAGE: {
                        return Mono.just((Object)new MessageInteractionEvent(gateway, context.getShardInfo(), interaction));
                    }
                    case USER: {
                        return Mono.just((Object)new UserInteractionEvent(gateway, context.getShardInfo(), interaction));
                    }
                }
                return Mono.just((Object)new ApplicationCommandInteractionEvent(gateway, context.getShardInfo(), interaction));
            }
            case MESSAGE_COMPONENT: {
                MessageComponent.Type componentType = (MessageComponent.Type)((Object)interaction.getCommandInteraction().flatMap(ApplicationCommandInteraction::getComponentType).orElseThrow(IllegalStateException::new));
                switch (componentType) {
                    case BUTTON: {
                        return Mono.just((Object)new ButtonInteractionEvent(gateway, context.getShardInfo(), interaction));
                    }
                    case SELECT_MENU: 
                    case SELECT_MENU_ROLE: 
                    case SELECT_MENU_USER: 
                    case SELECT_MENU_MENTIONABLE: 
                    case SELECT_MENU_CHANNEL: {
                        return Mono.just((Object)new SelectMenuInteractionEvent(gateway, context.getShardInfo(), interaction));
                    }
                }
                return Mono.just((Object)new ComponentInteractionEvent(gateway, context.getShardInfo(), interaction));
            }
            case APPLICATION_COMMAND_AUTOCOMPLETE: {
                return Mono.just((Object)new ChatInputAutoCompleteEvent(gateway, context.getShardInfo(), interaction));
            }
            case MODAL_SUBMIT: {
                return Mono.just((Object)new ModalSubmitInteractionEvent(gateway, context.getShardInfo(), interaction));
            }
        }
        return Mono.just((Object)new InteractionCreateEvent(gateway, context.getShardInfo(), interaction));
    }

    private static Mono<IntegrationDeleteEvent> integrationDelete(DispatchContext<IntegrationDelete, Void> context) {
        long guildId = Snowflake.asLong((String)context.getDispatch().guildId());
        long id = Snowflake.asLong((String)context.getDispatch().id());
        Long applicationId = context.getDispatch().applicationId().toOptional().map(Snowflake::asLong).orElse(null);
        return Mono.just((Object)new IntegrationDeleteEvent(context.getGateway(), context.getShardInfo(), id, guildId, applicationId));
    }

    private static Mono<IntegrationUpdateEvent> integrationUpdate(DispatchContext<IntegrationUpdate, Void> context) {
        long guildId = Snowflake.asLong((String)context.getDispatch().guildId());
        Integration integration = new Integration(context.getGateway(), context.getDispatch().integration(), guildId);
        return Mono.just((Object)new IntegrationUpdateEvent(context.getGateway(), context.getShardInfo(), guildId, integration));
    }

    private static Mono<IntegrationCreateEvent> integrationCreate(DispatchContext<IntegrationCreate, Void> context) {
        long guildId = Snowflake.asLong((String)context.getDispatch().guildId());
        Integration integration = new Integration(context.getGateway(), context.getDispatch().integration(), guildId);
        return Mono.just((Object)new IntegrationCreateEvent(context.getGateway(), context.getShardInfo(), guildId, integration));
    }

    private static Mono<AutoModRuleCreateEvent> autoModRuleCreate(DispatchContext<AutoModRuleCreate, Void> context) {
        AutoModRule autoModRule = new AutoModRule(context.getGateway(), context.getDispatch().automodrule());
        return Mono.just((Object)new AutoModRuleCreateEvent(context.getGateway(), context.getShardInfo(), autoModRule));
    }

    private static Mono<AutoModRuleUpdateEvent> autoModRuleUpdate(DispatchContext<AutoModRuleUpdate, Void> context) {
        AutoModRule autoModRule = new AutoModRule(context.getGateway(), context.getDispatch().automodrule());
        return Mono.just((Object)new AutoModRuleUpdateEvent(context.getGateway(), context.getShardInfo(), autoModRule));
    }

    private static Mono<AutoModRuleDeleteEvent> autoModRuleDelete(DispatchContext<AutoModRuleDelete, Void> context) {
        AutoModRule autoModRule = new AutoModRule(context.getGateway(), context.getDispatch().automodrule());
        return Mono.just((Object)new AutoModRuleDeleteEvent(context.getGateway(), context.getShardInfo(), autoModRule));
    }

    private static Mono<AutoModActionExecutedEvent> autoModActionExecute(DispatchContext<AutoModActionExecution, Void> context) {
        return Mono.just((Object)new AutoModActionExecutedEvent(context.getGateway(), context.getShardInfo(), context.getDispatch()));
    }

    static {
        DispatchHandlers.addHandler(ChannelCreate.class, ChannelDispatchHandlers::channelCreate);
        DispatchHandlers.addHandler(ChannelDelete.class, ChannelDispatchHandlers::channelDelete);
        DispatchHandlers.addHandler(ChannelPinsUpdate.class, ChannelDispatchHandlers::channelPinsUpdate);
        DispatchHandlers.addHandler(ChannelUpdate.class, ChannelDispatchHandlers::channelUpdate);
        DispatchHandlers.addHandler(AuditLogEntryCreate.class, DispatchHandlers::auditLogEntryCreate);
        DispatchHandlers.addHandler(GuildBanAdd.class, GuildDispatchHandlers::guildBanAdd);
        DispatchHandlers.addHandler(GuildBanRemove.class, GuildDispatchHandlers::guildBanRemove);
        DispatchHandlers.addHandler(GuildCreate.class, GuildDispatchHandlers::guildCreate);
        DispatchHandlers.addHandler(GuildDelete.class, GuildDispatchHandlers::guildDelete);
        DispatchHandlers.addHandler(GuildEmojisUpdate.class, GuildDispatchHandlers::guildEmojisUpdate);
        DispatchHandlers.addHandler(GuildIntegrationsUpdate.class, GuildDispatchHandlers::guildIntegrationsUpdate);
        DispatchHandlers.addHandler(GuildMemberAdd.class, GuildDispatchHandlers::guildMemberAdd);
        DispatchHandlers.addHandler(GuildMemberRemove.class, GuildDispatchHandlers::guildMemberRemove);
        DispatchHandlers.addHandler(GuildMembersChunk.class, GuildDispatchHandlers::guildMembersChunk);
        DispatchHandlers.addHandler(GuildMemberUpdate.class, GuildDispatchHandlers::guildMemberUpdate);
        DispatchHandlers.addHandler(GuildRoleCreate.class, GuildDispatchHandlers::guildRoleCreate);
        DispatchHandlers.addHandler(GuildRoleDelete.class, GuildDispatchHandlers::guildRoleDelete);
        DispatchHandlers.addHandler(GuildRoleUpdate.class, GuildDispatchHandlers::guildRoleUpdate);
        DispatchHandlers.addHandler(GuildScheduledEventCreate.class, GuildDispatchHandlers::scheduledEventCreate);
        DispatchHandlers.addHandler(GuildScheduledEventUpdate.class, GuildDispatchHandlers::scheduledEventUpdate);
        DispatchHandlers.addHandler(GuildScheduledEventDelete.class, GuildDispatchHandlers::scheduledEventDelete);
        DispatchHandlers.addHandler(GuildScheduledEventUserAdd.class, GuildDispatchHandlers::scheduledEventUserAdd);
        DispatchHandlers.addHandler(GuildScheduledEventUserRemove.class, GuildDispatchHandlers::scheduledEventUserRemove);
        DispatchHandlers.addHandler(GuildUpdate.class, GuildDispatchHandlers::guildUpdate);
        DispatchHandlers.addHandler(MessageCreate.class, MessageDispatchHandlers::messageCreate);
        DispatchHandlers.addHandler(MessageDelete.class, MessageDispatchHandlers::messageDelete);
        DispatchHandlers.addHandler(MessageDeleteBulk.class, MessageDispatchHandlers::messageDeleteBulk);
        DispatchHandlers.addHandler(MessageReactionAdd.class, MessageDispatchHandlers::messageReactionAdd);
        DispatchHandlers.addHandler(MessageReactionRemove.class, MessageDispatchHandlers::messageReactionRemove);
        DispatchHandlers.addHandler(MessageReactionRemoveEmoji.class, MessageDispatchHandlers::messageReactionRemoveEmoji);
        DispatchHandlers.addHandler(MessageReactionRemoveAll.class, MessageDispatchHandlers::messageReactionRemoveAll);
        DispatchHandlers.addHandler(MessageUpdate.class, MessageDispatchHandlers::messageUpdate);
        DispatchHandlers.addHandler(PresenceUpdate.class, DispatchHandlers::presenceUpdate);
        DispatchHandlers.addHandler(Ready.class, LifecycleDispatchHandlers::ready);
        DispatchHandlers.addHandler(Resumed.class, LifecycleDispatchHandlers::resumed);
        DispatchHandlers.addHandler(TypingStart.class, DispatchHandlers::typingStart);
        DispatchHandlers.addHandler(UserUpdate.class, DispatchHandlers::userUpdate);
        DispatchHandlers.addHandler(VoiceServerUpdate.class, DispatchHandlers::voiceServerUpdate);
        DispatchHandlers.addHandler(VoiceStateUpdateDispatch.class, DispatchHandlers::voiceStateUpdateDispatch);
        DispatchHandlers.addHandler(WebhooksUpdate.class, DispatchHandlers::webhooksUpdate);
        DispatchHandlers.addHandler(InviteCreate.class, DispatchHandlers::inviteCreate);
        DispatchHandlers.addHandler(InviteDelete.class, DispatchHandlers::inviteDelete);
        DispatchHandlers.addHandler(InteractionCreate.class, DispatchHandlers::interactionCreate);
        DispatchHandlers.addHandler(ApplicationCommandCreate.class, ApplicationCommandDispatchHandlers::applicationCommandCreate);
        DispatchHandlers.addHandler(ApplicationCommandUpdate.class, ApplicationCommandDispatchHandlers::applicationCommandUpdate);
        DispatchHandlers.addHandler(ApplicationCommandDelete.class, ApplicationCommandDispatchHandlers::applicationCommandDelete);
        DispatchHandlers.addHandler(ApplicationCommandPermissionUpdate.class, ApplicationCommandDispatchHandlers::applicationCommandPermissionUpdate);
        DispatchHandlers.addHandler(IntegrationCreate.class, DispatchHandlers::integrationCreate);
        DispatchHandlers.addHandler(IntegrationUpdate.class, DispatchHandlers::integrationUpdate);
        DispatchHandlers.addHandler(IntegrationDelete.class, DispatchHandlers::integrationDelete);
        DispatchHandlers.addHandler(AutoModRuleCreate.class, DispatchHandlers::autoModRuleCreate);
        DispatchHandlers.addHandler(AutoModRuleUpdate.class, DispatchHandlers::autoModRuleUpdate);
        DispatchHandlers.addHandler(AutoModRuleDelete.class, DispatchHandlers::autoModRuleDelete);
        DispatchHandlers.addHandler(AutoModActionExecution.class, DispatchHandlers::autoModActionExecute);
        DispatchHandlers.addHandler(PollVoteAdd.class, PollDispatchHandlers::pollVoteAddHandler);
        DispatchHandlers.addHandler(PollVoteRemove.class, PollDispatchHandlers::pollVoteRemoveHandler);
        DispatchHandlers.addHandler(EntitlementCreate.class, MonetizationDispatchHandlers::entitlementCreate);
        DispatchHandlers.addHandler(EntitlementUpdate.class, MonetizationDispatchHandlers::entitlementUpdate);
        DispatchHandlers.addHandler(EntitlementDelete.class, MonetizationDispatchHandlers::entitlementDelete);
        DispatchHandlers.addHandler(GatewayStateChange.class, LifecycleDispatchHandlers::gatewayStateChanged);
        DispatchHandlers.addHandler(UnavailableGuildCreate.class, context -> Mono.empty());
        log = Loggers.getLogger(DispatchHandlers.class);
    }
}

