/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SoundboardSoundData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableSoundboardSoundData
implements SoundboardSoundData {
    private final String name;
    private final long soundId_value;
    private final double volume;
    private final long emojiId_value;
    private final boolean emojiId_present;
    @Nullable
    private final String emojiName;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final boolean available;
    private final UserData user_value;
    private final boolean user_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSoundboardSoundData(String name, Id soundId, double volume, Optional<Id> emojiId, Optional<String> emojiName, Possible<Id> guildId, boolean available, Possible<UserData> user) {
        this.name = Objects.requireNonNull(name, "name");
        Id soundId$impl = soundId;
        this.volume = volume;
        Optional<Id> emojiId$impl = emojiId;
        this.emojiName = emojiName.orElse(null);
        Possible<Id> guildId$impl = guildId;
        this.available = available;
        Possible<UserData> user$impl = user;
        this.soundId_value = soundId$impl.asLong();
        this.emojiId_value = emojiId$impl.map(Id::asLong).orElse(0L);
        this.emojiId_present = emojiId$impl.isPresent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.user_value = user$impl.toOptional().orElse(null);
        this.user_absent = user$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableSoundboardSoundData(ImmutableSoundboardSoundData original, String name, Id soundId, double volume, Optional<Id> emojiId, @Nullable String emojiName, Possible<Id> guildId, boolean available, Possible<UserData> user) {
        this.name = name;
        Id soundId$impl = soundId;
        this.volume = volume;
        Optional<Id> emojiId$impl = emojiId;
        this.emojiName = emojiName;
        Possible<Id> guildId$impl = guildId;
        this.available = available;
        Possible<UserData> user$impl = user;
        this.soundId_value = soundId$impl.asLong();
        this.emojiId_value = emojiId$impl.map(Id::asLong).orElse(0L);
        this.emojiId_present = emojiId$impl.isPresent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.user_value = user$impl.toOptional().orElse(null);
        this.user_absent = user$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="sound_id")
    public Id soundId() {
        return Id.of((long)this.soundId_value);
    }

    @Override
    @JsonProperty(value="volume")
    public double volume() {
        return this.volume;
    }

    @Override
    @JsonProperty(value="emoji_id")
    public Optional<Id> emojiId() {
        return this.emojiId_present ? Optional.of(Id.of((long)this.emojiId_value)) : Optional.empty();
    }

    @Override
    @JsonProperty(value="emoji_name")
    public Optional<String> emojiName() {
        return Optional.ofNullable(this.emojiName);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    @Override
    @JsonProperty(value="available")
    public boolean available() {
        return this.available;
    }

    @Override
    @JsonProperty(value="user")
    public Possible<UserData> user() {
        return this.user_absent ? Possible.absent() : Possible.of((Object)this.user_value);
    }

    public final ImmutableSoundboardSoundData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSoundboardSoundData(this, newValue, this.soundId(), this.volume, this.emojiId(), this.emojiName, this.guildId(), this.available, this.user());
    }

    public ImmutableSoundboardSoundData withSoundId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSoundboardSoundData(this, this.name, newValue, this.volume, this.emojiId(), this.emojiName, this.guildId(), this.available, this.user());
    }

    public ImmutableSoundboardSoundData withSoundId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSoundboardSoundData(this, this.name, newValue, this.volume, this.emojiId(), this.emojiName, this.guildId(), this.available, this.user());
    }

    public final ImmutableSoundboardSoundData withVolume(double value) {
        if (Double.doubleToLongBits(this.volume) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), value, this.emojiId(), this.emojiName, this.guildId(), this.available, this.user());
    }

    public ImmutableSoundboardSoundData withEmojiId(Optional<Id> value) {
        Optional<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, newValue, this.emojiName, this.guildId(), this.available, this.user());
    }

    public ImmutableSoundboardSoundData withEmojiId(long value) {
        Optional<Id> newValue = Optional.of(Id.of((long)value));
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, newValue, this.emojiName, this.guildId(), this.available, this.user());
    }

    public final ImmutableSoundboardSoundData withEmojiName(String value) {
        String newValue = Objects.requireNonNull(value, "emojiName");
        if (Objects.equals(this.emojiName, newValue)) {
            return this;
        }
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), newValue, this.guildId(), this.available, this.user());
    }

    public final ImmutableSoundboardSoundData withEmojiName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emojiName, value)) {
            return this;
        }
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), value, this.guildId(), this.available, this.user());
    }

    public ImmutableSoundboardSoundData withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), this.emojiName, newValue, this.available, this.user());
    }

    public ImmutableSoundboardSoundData withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), this.emojiName, (Possible<Id>)newValue, this.available, this.user());
    }

    public final ImmutableSoundboardSoundData withAvailable(boolean value) {
        if (this.available == value) {
            return this;
        }
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), this.emojiName, this.guildId(), value, this.user());
    }

    public ImmutableSoundboardSoundData withUser(Possible<UserData> value) {
        Possible<UserData> newValue = Objects.requireNonNull(value);
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), this.emojiName, this.guildId(), this.available, newValue);
    }

    public ImmutableSoundboardSoundData withUser(UserData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableSoundboardSoundData(this, this.name, this.soundId(), this.volume, this.emojiId(), this.emojiName, this.guildId(), this.available, (Possible<UserData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSoundboardSoundData && this.equalTo(0, (ImmutableSoundboardSoundData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSoundboardSoundData another) {
        return this.name.equals(another.name) && Objects.equals(this.soundId_value, another.soundId_value) && Double.doubleToLongBits(this.volume) == Double.doubleToLongBits(another.volume) && this.emojiId().equals(another.emojiId()) && Objects.equals(this.emojiName, another.emojiName) && this.guildId().equals(another.guildId()) && this.available == another.available && this.user().equals(another.user());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.soundId_value);
        h += (h << 5) + Double.hashCode(this.volume);
        h += (h << 5) + this.emojiId().hashCode();
        h += (h << 5) + Objects.hashCode(this.emojiName);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + Boolean.hashCode(this.available);
        h += (h << 5) + this.user().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SoundboardSoundData{");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("soundId=").append(Objects.toString(this.soundId_value));
        builder.append(", ");
        builder.append("volume=").append(this.volume);
        builder.append(", ");
        builder.append("emojiId=").append(this.emojiId().toString());
        if (this.emojiName != null) {
            builder.append(", ");
            builder.append("emojiName=").append(this.emojiName);
        }
        builder.append(", ");
        builder.append("guildId=").append(this.guildId().toString());
        builder.append(", ");
        builder.append("available=").append(this.available);
        builder.append(", ");
        builder.append("user=").append(this.user().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSoundboardSoundData fromJson(Json json) {
        Builder builder = ImmutableSoundboardSoundData.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.soundId != null) {
            builder.soundId(json.soundId);
        }
        if (json.volumeIsSet) {
            builder.volume(json.volume);
        }
        if (json.emojiId != null) {
            builder.emojiId(json.emojiId);
        }
        if (json.emojiName != null) {
            builder.emojiName(json.emojiName);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.availableIsSet) {
            builder.available(json.available);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        return builder.build();
    }

    public static ImmutableSoundboardSoundData of(String name, Id soundId, double volume, Optional<Id> emojiId, Optional<String> emojiName, Possible<Id> guildId, boolean available, Possible<UserData> user) {
        return new ImmutableSoundboardSoundData(name, soundId, volume, emojiId, emojiName, guildId, available, user);
    }

    public static ImmutableSoundboardSoundData copyOf(SoundboardSoundData instance) {
        if (instance instanceof ImmutableSoundboardSoundData) {
            return (ImmutableSoundboardSoundData)instance;
        }
        return ImmutableSoundboardSoundData.builder().from(instance).build();
    }

    public boolean isEmojiIdPresent() {
        return this.emojiId_present;
    }

    public long emojiIdOrElse(long defaultValue) {
        return this.emojiId_present ? this.emojiId_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isUserPresent() {
        return !this.user_absent;
    }

    public UserData userOrElse(UserData defaultValue) {
        return !this.user_absent ? this.user_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VOLUME = 2L;
        private static final long INIT_BIT_AVAILABLE = 4L;
        private long initBits = 7L;
        private Id soundId_id = null;
        private Optional<Id> emojiId_optional = Optional.empty();
        private Possible<Id> guildId_possible = Possible.absent();
        private Possible<UserData> user_possible = Possible.absent();
        @Nullable
        private String name;
        private double volume;
        @Nullable
        private String emojiName;
        private boolean available;

        private Builder() {
        }

        public final Builder from(SoundboardSoundData instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.soundId(instance.soundId());
            this.volume(instance.volume());
            this.emojiId(instance.emojiId());
            Optional<String> emojiNameOptional = instance.emojiName();
            if (emojiNameOptional.isPresent()) {
                this.emojiName(emojiNameOptional);
            }
            this.guildId(instance.guildId());
            this.available(instance.available());
            this.user(instance.user());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder soundId(String value) {
            this.soundId_id = Id.of((String)value);
            return this;
        }

        public Builder soundId(long value) {
            this.soundId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="sound_id")
        public Builder soundId(Id value) {
            this.soundId_id = value;
            return this;
        }

        @JsonProperty(value="volume")
        public final Builder volume(double volume) {
            this.volume = volume;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder emojiId(String value) {
            this.emojiId_optional = Optional.of(Id.of((String)value));
            return this;
        }

        public Builder emojiId(long value) {
            this.emojiId_optional = Optional.of(Id.of((long)value));
            return this;
        }

        @JsonProperty(value="emoji_id")
        public Builder emojiId(Optional<Id> value) {
            this.emojiId_optional = value;
            return this;
        }

        public final Builder emojiName(String emojiName) {
            this.emojiName = Objects.requireNonNull(emojiName, "emojiName");
            return this;
        }

        @JsonProperty(value="emoji_name")
        public final Builder emojiName(Optional<String> emojiName) {
            this.emojiName = emojiName.orElse(null);
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="available")
        public final Builder available(boolean available) {
            this.available = available;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="user")
        public Builder user(Possible<UserData> value) {
            this.user_possible = value;
            return this;
        }

        public Builder user(UserData value) {
            this.user_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableSoundboardSoundData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSoundboardSoundData(null, this.name, this.soundId_build(), this.volume, this.emojiId_build(), this.emojiName, this.guildId_build(), this.available, this.user_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("volume");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("available");
            }
            return "Cannot build SoundboardSoundData, some of required attributes are not set " + attributes;
        }

        private Id soundId_build() {
            return this.soundId_id;
        }

        private Optional<Id> emojiId_build() {
            return this.emojiId_optional;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<UserData> user_build() {
            return this.user_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SoundboardSoundData {
        @Nullable
        String name;
        @Nullable
        Id soundId;
        double volume;
        boolean volumeIsSet;
        Optional<Id> emojiId = Optional.empty();
        @Nullable
        Optional<String> emojiName = Optional.empty();
        Possible<Id> guildId = Possible.absent();
        boolean available;
        boolean availableIsSet;
        Possible<UserData> user = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="sound_id")
        public void setSoundId(Id soundId) {
            this.soundId = soundId;
        }

        @JsonProperty(value="volume")
        public void setVolume(double volume) {
            this.volume = volume;
            this.volumeIsSet = true;
        }

        @JsonProperty(value="emoji_id")
        public void setEmojiId(Optional<Id> emojiId) {
            this.emojiId = emojiId;
        }

        @JsonProperty(value="emoji_name")
        public void setEmojiName(Optional<String> emojiName) {
            this.emojiName = emojiName;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="available")
        public void setAvailable(boolean available) {
            this.available = available;
            this.availableIsSet = true;
        }

        @JsonProperty(value="user")
        public void setUser(Possible<UserData> user) {
            this.user = user;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id soundId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double volume() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> emojiId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> emojiName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean available() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<UserData> user() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSoundData, attribute initializers form cycle " + attributes;
        }
    }
}

