/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingData;
import discord4j.discordjson.json.OnboardingData;
import discord4j.discordjson.json.OnboardingPromptData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableOnboardingData
implements OnboardingData {
    private final long[] defaultChannelIds_value;
    private final boolean enabled;
    private final int mode;
    private final long guildId_value;
    private final List<OnboardingPromptData> prompts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingData(List<Id> defaultChannelIds, boolean enabled, int mode, Id guildId, Iterable<? extends OnboardingPromptData> prompts) {
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.mode = mode;
        Id guildId$impl = guildId;
        this.prompts = ImmutableOnboardingData.createUnmodifiableList(false, ImmutableOnboardingData.createSafeList(prompts, true, false));
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableOnboardingData(ImmutableOnboardingData original, List<Id> defaultChannelIds, boolean enabled, int mode, Id guildId, List<OnboardingPromptData> prompts) {
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.mode = mode;
        Id guildId$impl = guildId;
        this.prompts = prompts;
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="default_channel_ids")
    public List<Id> defaultChannelIds() {
        return LongStream.of(this.defaultChannelIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="mode")
    public int mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="prompts")
    public List<OnboardingPromptData> prompts() {
        return this.prompts;
    }

    public ImmutableOnboardingData withDefaultChannelIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingData(this, newValue, this.enabled, this.mode, this.guildId(), this.prompts);
    }

    public final ImmutableOnboardingData withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableOnboardingData(this, this.defaultChannelIds(), value, this.mode, this.guildId(), this.prompts);
    }

    public final ImmutableOnboardingData withMode(int value) {
        if (this.mode == value) {
            return this;
        }
        return new ImmutableOnboardingData(this, this.defaultChannelIds(), this.enabled, value, this.guildId(), this.prompts);
    }

    public ImmutableOnboardingData withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableOnboardingData(this, this.defaultChannelIds(), this.enabled, this.mode, newValue, this.prompts);
    }

    public ImmutableOnboardingData withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableOnboardingData(this, this.defaultChannelIds(), this.enabled, this.mode, newValue, this.prompts);
    }

    public final ImmutableOnboardingData withPrompts(OnboardingPromptData ... elements) {
        List<OnboardingPromptData> newValue = ImmutableOnboardingData.createUnmodifiableList(false, ImmutableOnboardingData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOnboardingData(this, this.defaultChannelIds(), this.enabled, this.mode, this.guildId(), newValue);
    }

    public final ImmutableOnboardingData withPrompts(Iterable<? extends OnboardingPromptData> elements) {
        if (this.prompts == elements) {
            return this;
        }
        List<OnboardingPromptData> newValue = ImmutableOnboardingData.createUnmodifiableList(false, ImmutableOnboardingData.createSafeList(elements, true, false));
        return new ImmutableOnboardingData(this, this.defaultChannelIds(), this.enabled, this.mode, this.guildId(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingData && this.equalTo(0, (ImmutableOnboardingData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingData another) {
        return Objects.equals(this.defaultChannelIds_value, another.defaultChannelIds_value) && this.enabled == another.enabled && this.mode == another.mode && Objects.equals(this.guildId_value, another.guildId_value) && this.prompts.equals(another.prompts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultChannelIds_value);
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + this.mode;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.prompts.hashCode();
        return h;
    }

    public String toString() {
        return "OnboardingData{defaultChannelIds=" + Objects.toString(this.defaultChannelIds_value) + ", enabled=" + this.enabled + ", mode=" + this.mode + ", guildId=" + Objects.toString(this.guildId_value) + ", prompts=" + this.prompts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingData fromJson(Json json) {
        Builder builder = ImmutableOnboardingData.builder();
        if (json.defaultChannelIds != null) {
            builder.defaultChannelIds(json.defaultChannelIds);
        }
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.modeIsSet) {
            builder.mode(json.mode);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.prompts != null) {
            builder.addAllPrompts(json.prompts);
        }
        return builder.build();
    }

    public static ImmutableOnboardingData of(List<Id> defaultChannelIds, boolean enabled, int mode, Id guildId, List<OnboardingPromptData> prompts) {
        return ImmutableOnboardingData.of(defaultChannelIds, enabled, mode, guildId, prompts);
    }

    public static ImmutableOnboardingData of(List<Id> defaultChannelIds, boolean enabled, int mode, Id guildId, Iterable<? extends OnboardingPromptData> prompts) {
        return new ImmutableOnboardingData(defaultChannelIds, enabled, mode, guildId, prompts);
    }

    public static ImmutableOnboardingData copyOf(OnboardingData instance) {
        if (instance instanceof ImmutableOnboardingData) {
            return (ImmutableOnboardingData)instance;
        }
        return ImmutableOnboardingData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long INIT_BIT_MODE = 2L;
        private long initBits = 3L;
        private List<Long> defaultChannelIds_list = null;
        private Id guildId_id = null;
        private boolean enabled;
        private int mode;
        private List<OnboardingPromptData> prompts = new ArrayList<OnboardingPromptData>();

        private Builder() {
        }

        public final Builder from(BaseOnboardingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(OnboardingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseOnboardingData instance;
            long bits = 0L;
            if (object instanceof BaseOnboardingData) {
                instance = (BaseOnboardingData)object;
                if ((bits & 2L) == 0L) {
                    this.mode(instance.mode());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.enabled(instance.enabled());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.defaultChannelIds(instance.defaultChannelIds());
                    bits |= 4L;
                }
            }
            if (object instanceof OnboardingData) {
                instance = (OnboardingData)object;
                if ((bits & 2L) == 0L) {
                    this.mode(instance.mode());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.defaultChannelIds(instance.defaultChannelIds());
                    bits |= 4L;
                }
                this.guildId(instance.guildId());
                if ((bits & 1L) == 0L) {
                    this.enabled(instance.enabled());
                    bits |= 1L;
                }
                this.addAllPrompts(instance.prompts());
            }
        }

        public Builder addDefaultChannelId(long element) {
            this.defaultChannelIds_getOrCreate().add(element);
            return this;
        }

        public Builder addDefaultChannelId(String element) {
            this.defaultChannelIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addDefaultChannelId(Id element) {
            this.defaultChannelIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllDefaultChannelIds(List<Long> elements) {
            this.defaultChannelIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="default_channel_ids")
        public Builder defaultChannelIds(List<Id> elements) {
            this.defaultChannelIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder defaultChannelIds(Iterable<Id> elements) {
            this.defaultChannelIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mode")
        public final Builder mode(int mode) {
            this.mode = mode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public final Builder addPrompt(OnboardingPromptData element) {
            this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            return this;
        }

        public final Builder addPrompts(OnboardingPromptData ... elements) {
            for (OnboardingPromptData element : elements) {
                this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            }
            return this;
        }

        @JsonProperty(value="prompts")
        public final Builder prompts(Iterable<? extends OnboardingPromptData> elements) {
            this.prompts.clear();
            return this.addAllPrompts(elements);
        }

        public final Builder addAllPrompts(Iterable<? extends OnboardingPromptData> elements) {
            for (OnboardingPromptData onboardingPromptData : elements) {
                this.prompts.add(Objects.requireNonNull(onboardingPromptData, "prompts element"));
            }
            return this;
        }

        public ImmutableOnboardingData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingData(null, this.defaultChannelIds_build(), this.enabled, this.mode, this.guildId_build(), ImmutableOnboardingData.createUnmodifiableList(true, this.prompts));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mode");
            }
            return "Cannot build OnboardingData, some of required attributes are not set " + attributes;
        }

        private List<Id> defaultChannelIds_build() {
            return this.defaultChannelIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> defaultChannelIds_getOrCreate() {
            if (this.defaultChannelIds_list == null) {
                this.defaultChannelIds_list = new ArrayList<Long>();
            }
            return this.defaultChannelIds_list;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OnboardingData {
        @Nullable
        List<Id> defaultChannelIds;
        boolean enabled;
        boolean enabledIsSet;
        int mode;
        boolean modeIsSet;
        @Nullable
        Id guildId;
        @Nullable
        List<OnboardingPromptData> prompts = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="default_channel_ids")
        public void setDefaultChannelIds(List<Id> defaultChannelIds) {
            this.defaultChannelIds = defaultChannelIds;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="mode")
        public void setMode(int mode) {
            this.mode = mode;
            this.modeIsSet = true;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="prompts")
        public void setPrompts(List<OnboardingPromptData> prompts) {
            this.prompts = prompts;
        }

        @Override
        public List<Id> defaultChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int mode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OnboardingPromptData> prompts() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingData, attribute initializers form cycle " + attributes;
        }
    }
}

