/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.GuildMemberAddRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableGuildMemberAddRequest
implements GuildMemberAddRequest {
    private final String accessToken;
    private final String nick;
    private final List<String> roles;
    private final boolean mute;
    private final boolean deaf;

    private ImmutableGuildMemberAddRequest(String accessToken, String nick, Iterable<String> roles, boolean mute, boolean deaf) {
        this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
        this.nick = Objects.requireNonNull(nick, "nick");
        this.roles = ImmutableGuildMemberAddRequest.createUnmodifiableList(false, ImmutableGuildMemberAddRequest.createSafeList(roles, true, false));
        this.mute = mute;
        this.deaf = deaf;
    }

    private ImmutableGuildMemberAddRequest(ImmutableGuildMemberAddRequest original, String accessToken, String nick, List<String> roles, boolean mute, boolean deaf) {
        this.accessToken = accessToken;
        this.nick = nick;
        this.roles = roles;
        this.mute = mute;
        this.deaf = deaf;
    }

    @Override
    @JsonProperty(value="access_token")
    public String accessToken() {
        return this.accessToken;
    }

    @Override
    @JsonProperty(value="nick")
    public String nick() {
        return this.nick;
    }

    @Override
    @JsonProperty(value="roles")
    public List<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="mute")
    public boolean mute() {
        return this.mute;
    }

    @Override
    @JsonProperty(value="deaf")
    public boolean deaf() {
        return this.deaf;
    }

    public final ImmutableGuildMemberAddRequest withAccessToken(String value) {
        String newValue = Objects.requireNonNull(value, "accessToken");
        if (this.accessToken.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildMemberAddRequest(this, newValue, this.nick, this.roles, this.mute, this.deaf);
    }

    public final ImmutableGuildMemberAddRequest withNick(String value) {
        String newValue = Objects.requireNonNull(value, "nick");
        if (this.nick.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildMemberAddRequest(this, this.accessToken, newValue, this.roles, this.mute, this.deaf);
    }

    public final ImmutableGuildMemberAddRequest withRoles(String ... elements) {
        List<String> newValue = ImmutableGuildMemberAddRequest.createUnmodifiableList(false, ImmutableGuildMemberAddRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildMemberAddRequest(this, this.accessToken, this.nick, newValue, this.mute, this.deaf);
    }

    public final ImmutableGuildMemberAddRequest withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<String> newValue = ImmutableGuildMemberAddRequest.createUnmodifiableList(false, ImmutableGuildMemberAddRequest.createSafeList(elements, true, false));
        return new ImmutableGuildMemberAddRequest(this, this.accessToken, this.nick, newValue, this.mute, this.deaf);
    }

    public final ImmutableGuildMemberAddRequest withMute(boolean value) {
        if (this.mute == value) {
            return this;
        }
        return new ImmutableGuildMemberAddRequest(this, this.accessToken, this.nick, this.roles, value, this.deaf);
    }

    public final ImmutableGuildMemberAddRequest withDeaf(boolean value) {
        if (this.deaf == value) {
            return this;
        }
        return new ImmutableGuildMemberAddRequest(this, this.accessToken, this.nick, this.roles, this.mute, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildMemberAddRequest && this.equalTo(0, (ImmutableGuildMemberAddRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildMemberAddRequest another) {
        return this.accessToken.equals(another.accessToken) && this.nick.equals(another.nick) && this.roles.equals(another.roles) && this.mute == another.mute && this.deaf == another.deaf;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessToken.hashCode();
        h += (h << 5) + this.nick.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + Boolean.hashCode(this.mute);
        h += (h << 5) + Boolean.hashCode(this.deaf);
        return h;
    }

    public String toString() {
        return "GuildMemberAddRequest{accessToken=" + this.accessToken + ", nick=" + this.nick + ", roles=" + this.roles + ", mute=" + this.mute + ", deaf=" + this.deaf + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildMemberAddRequest fromJson(Json json) {
        Builder builder = ImmutableGuildMemberAddRequest.builder();
        if (json.accessToken != null) {
            builder.accessToken(json.accessToken);
        }
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.muteIsSet) {
            builder.mute(json.mute);
        }
        if (json.deafIsSet) {
            builder.deaf(json.deaf);
        }
        return builder.build();
    }

    public static ImmutableGuildMemberAddRequest of(String accessToken, String nick, List<String> roles, boolean mute, boolean deaf) {
        return ImmutableGuildMemberAddRequest.of(accessToken, nick, roles, mute, deaf);
    }

    public static ImmutableGuildMemberAddRequest of(String accessToken, String nick, Iterable<String> roles, boolean mute, boolean deaf) {
        return new ImmutableGuildMemberAddRequest(accessToken, nick, roles, mute, deaf);
    }

    public static ImmutableGuildMemberAddRequest copyOf(GuildMemberAddRequest instance) {
        if (instance instanceof ImmutableGuildMemberAddRequest) {
            return (ImmutableGuildMemberAddRequest)instance;
        }
        return ImmutableGuildMemberAddRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ACCESS_TOKEN = 1L;
        private static final long INIT_BIT_NICK = 2L;
        private static final long INIT_BIT_MUTE = 4L;
        private static final long INIT_BIT_DEAF = 8L;
        private long initBits = 15L;
        @Nullable
        private String accessToken;
        @Nullable
        private String nick;
        private List<String> roles = new ArrayList<String>();
        private boolean mute;
        private boolean deaf;

        private Builder() {
        }

        public final Builder from(GuildMemberAddRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessToken(instance.accessToken());
            this.nick(instance.nick());
            this.addAllRoles(instance.roles());
            this.mute(instance.mute());
            this.deaf(instance.deaf());
            return this;
        }

        @JsonProperty(value="access_token")
        public final Builder accessToken(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="nick")
        public final Builder nick(String nick) {
            this.nick = Objects.requireNonNull(nick, "nick");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRole(String element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(String ... elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="roles")
        public final Builder roles(Iterable<String> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="mute")
        public final Builder mute(boolean mute) {
            this.mute = mute;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="deaf")
        public final Builder deaf(boolean deaf) {
            this.deaf = deaf;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGuildMemberAddRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildMemberAddRequest(null, this.accessToken, this.nick, ImmutableGuildMemberAddRequest.createUnmodifiableList(true, this.roles), this.mute, this.deaf);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessToken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nick");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mute");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("deaf");
            }
            return "Cannot build GuildMemberAddRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildMemberAddRequest {
        @Nullable
        String accessToken;
        @Nullable
        String nick;
        @Nullable
        List<String> roles = Collections.emptyList();
        boolean mute;
        boolean muteIsSet;
        boolean deaf;
        boolean deafIsSet;

        Json() {
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty(value="nick")
        public void setNick(String nick) {
            this.nick = nick;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="mute")
        public void setMute(boolean mute) {
            this.mute = mute;
            this.muteIsSet = true;
        }

        @JsonProperty(value="deaf")
        public void setDeaf(boolean deaf) {
            this.deaf = deaf;
            this.deafIsSet = true;
        }

        @Override
        public String accessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deaf() {
            throw new UnsupportedOperationException();
        }
    }
}

