/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BulkBanResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableBulkBanResponseData
implements BulkBanResponseData {
    private final long[] bannedUsers_value;
    private final long[] failedUsers_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBulkBanResponseData(List<Id> bannedUsers, List<Id> failedUsers) {
        List<Id> bannedUsers$impl = bannedUsers;
        List<Id> failedUsers$impl = failedUsers;
        this.bannedUsers_value = bannedUsers$impl.stream().mapToLong(Id::asLong).toArray();
        this.failedUsers_value = failedUsers$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableBulkBanResponseData(ImmutableBulkBanResponseData original, List<Id> bannedUsers, List<Id> failedUsers) {
        List<Id> bannedUsers$impl = bannedUsers;
        List<Id> failedUsers$impl = failedUsers;
        this.bannedUsers_value = bannedUsers$impl.stream().mapToLong(Id::asLong).toArray();
        this.failedUsers_value = failedUsers$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="banned_users")
    public List<Id> bannedUsers() {
        return LongStream.of(this.bannedUsers_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="failed_users")
    public List<Id> failedUsers() {
        return LongStream.of(this.failedUsers_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    public ImmutableBulkBanResponseData withBannedUsers(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableBulkBanResponseData(this, newValue, this.failedUsers());
    }

    public ImmutableBulkBanResponseData withFailedUsers(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableBulkBanResponseData(this, this.bannedUsers(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBulkBanResponseData && this.equalTo(0, (ImmutableBulkBanResponseData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBulkBanResponseData another) {
        return Objects.equals(this.bannedUsers_value, another.bannedUsers_value) && Objects.equals(this.failedUsers_value, another.failedUsers_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.bannedUsers_value);
        h += (h << 5) + Objects.hashCode(this.failedUsers_value);
        return h;
    }

    public String toString() {
        return "BulkBanResponseData{bannedUsers=" + Objects.toString(this.bannedUsers_value) + ", failedUsers=" + Objects.toString(this.failedUsers_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBulkBanResponseData fromJson(Json json) {
        Builder builder = ImmutableBulkBanResponseData.builder();
        if (json.bannedUsers != null) {
            builder.bannedUsers(json.bannedUsers);
        }
        if (json.failedUsers != null) {
            builder.failedUsers(json.failedUsers);
        }
        return builder.build();
    }

    public static ImmutableBulkBanResponseData of(List<Id> bannedUsers, List<Id> failedUsers) {
        return new ImmutableBulkBanResponseData(bannedUsers, failedUsers);
    }

    public static ImmutableBulkBanResponseData copyOf(BulkBanResponseData instance) {
        if (instance instanceof ImmutableBulkBanResponseData) {
            return (ImmutableBulkBanResponseData)instance;
        }
        return ImmutableBulkBanResponseData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Long> bannedUsers_list = null;
        private List<Long> failedUsers_list = null;

        private Builder() {
        }

        public final Builder from(BulkBanResponseData instance) {
            Objects.requireNonNull(instance, "instance");
            this.bannedUsers(instance.bannedUsers());
            this.failedUsers(instance.failedUsers());
            return this;
        }

        public Builder addBannedUser(long element) {
            this.bannedUsers_getOrCreate().add(element);
            return this;
        }

        public Builder addBannedUser(String element) {
            this.bannedUsers_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addBannedUser(Id element) {
            this.bannedUsers_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllBannedUsers(List<Long> elements) {
            this.bannedUsers_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="banned_users")
        public Builder bannedUsers(List<Id> elements) {
            this.bannedUsers_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder bannedUsers(Iterable<Id> elements) {
            this.bannedUsers_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addFailedUser(long element) {
            this.failedUsers_getOrCreate().add(element);
            return this;
        }

        public Builder addFailedUser(String element) {
            this.failedUsers_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addFailedUser(Id element) {
            this.failedUsers_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllFailedUsers(List<Long> elements) {
            this.failedUsers_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="failed_users")
        public Builder failedUsers(List<Id> elements) {
            this.failedUsers_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder failedUsers(Iterable<Id> elements) {
            this.failedUsers_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public ImmutableBulkBanResponseData build() {
            return new ImmutableBulkBanResponseData(null, this.bannedUsers_build(), this.failedUsers_build());
        }

        private List<Id> bannedUsers_build() {
            return this.bannedUsers_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> bannedUsers_getOrCreate() {
            if (this.bannedUsers_list == null) {
                this.bannedUsers_list = new ArrayList<Long>();
            }
            return this.bannedUsers_list;
        }

        private List<Id> failedUsers_build() {
            return this.failedUsers_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> failedUsers_getOrCreate() {
            if (this.failedUsers_list == null) {
                this.failedUsers_list = new ArrayList<Long>();
            }
            return this.failedUsers_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BulkBanResponseData {
        @Nullable
        List<Id> bannedUsers;
        @Nullable
        List<Id> failedUsers;

        Json() {
        }

        @JsonProperty(value="banned_users")
        public void setBannedUsers(List<Id> bannedUsers) {
            this.bannedUsers = bannedUsers;
        }

        @JsonProperty(value="failed_users")
        public void setFailedUsers(List<Id> failedUsers) {
            this.failedUsers = failedUsers;
        }

        @Override
        public List<Id> bannedUsers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> failedUsers() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build BulkBanResponseData, attribute initializers form cycle " + attributes;
        }
    }
}

