/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationCommandPermissionsData;
import discord4j.discordjson.json.ApplicationCommandPermissionsRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableApplicationCommandPermissionsRequest
implements ApplicationCommandPermissionsRequest {
    private final List<ApplicationCommandPermissionsData> permissions;

    private ImmutableApplicationCommandPermissionsRequest(Iterable<? extends ApplicationCommandPermissionsData> permissions) {
        this.permissions = ImmutableApplicationCommandPermissionsRequest.createUnmodifiableList(false, ImmutableApplicationCommandPermissionsRequest.createSafeList(permissions, true, false));
    }

    private ImmutableApplicationCommandPermissionsRequest(ImmutableApplicationCommandPermissionsRequest original, List<ApplicationCommandPermissionsData> permissions) {
        this.permissions = permissions;
    }

    @Override
    @JsonProperty(value="permissions")
    public List<ApplicationCommandPermissionsData> permissions() {
        return this.permissions;
    }

    public final ImmutableApplicationCommandPermissionsRequest withPermissions(ApplicationCommandPermissionsData ... elements) {
        List<ApplicationCommandPermissionsData> newValue = ImmutableApplicationCommandPermissionsRequest.createUnmodifiableList(false, ImmutableApplicationCommandPermissionsRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApplicationCommandPermissionsRequest(this, newValue);
    }

    public final ImmutableApplicationCommandPermissionsRequest withPermissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
        if (this.permissions == elements) {
            return this;
        }
        List<ApplicationCommandPermissionsData> newValue = ImmutableApplicationCommandPermissionsRequest.createUnmodifiableList(false, ImmutableApplicationCommandPermissionsRequest.createSafeList(elements, true, false));
        return new ImmutableApplicationCommandPermissionsRequest(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationCommandPermissionsRequest && this.equalTo(0, (ImmutableApplicationCommandPermissionsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplicationCommandPermissionsRequest another) {
        return this.permissions.equals(another.permissions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.permissions.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationCommandPermissionsRequest{permissions=" + this.permissions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationCommandPermissionsRequest fromJson(Json json) {
        Builder builder = ImmutableApplicationCommandPermissionsRequest.builder();
        if (json.permissions != null) {
            builder.addAllPermissions(json.permissions);
        }
        return builder.build();
    }

    public static ImmutableApplicationCommandPermissionsRequest of(List<ApplicationCommandPermissionsData> permissions) {
        return ImmutableApplicationCommandPermissionsRequest.of(permissions);
    }

    public static ImmutableApplicationCommandPermissionsRequest of(Iterable<? extends ApplicationCommandPermissionsData> permissions) {
        return new ImmutableApplicationCommandPermissionsRequest(permissions);
    }

    public static ImmutableApplicationCommandPermissionsRequest copyOf(ApplicationCommandPermissionsRequest instance) {
        if (instance instanceof ImmutableApplicationCommandPermissionsRequest) {
            return (ImmutableApplicationCommandPermissionsRequest)instance;
        }
        return ImmutableApplicationCommandPermissionsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<ApplicationCommandPermissionsData> permissions = new ArrayList<ApplicationCommandPermissionsData>();

        private Builder() {
        }

        public final Builder from(ApplicationCommandPermissionsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPermissions(instance.permissions());
            return this;
        }

        public final Builder addPermission(ApplicationCommandPermissionsData element) {
            this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            return this;
        }

        public final Builder addPermissions(ApplicationCommandPermissionsData ... elements) {
            for (ApplicationCommandPermissionsData element : elements) {
                this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            }
            return this;
        }

        @JsonProperty(value="permissions")
        public final Builder permissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
            this.permissions.clear();
            return this.addAllPermissions(elements);
        }

        public final Builder addAllPermissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
            for (ApplicationCommandPermissionsData applicationCommandPermissionsData : elements) {
                this.permissions.add(Objects.requireNonNull(applicationCommandPermissionsData, "permissions element"));
            }
            return this;
        }

        public ImmutableApplicationCommandPermissionsRequest build() {
            return new ImmutableApplicationCommandPermissionsRequest(null, ImmutableApplicationCommandPermissionsRequest.createUnmodifiableList(true, this.permissions));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ApplicationCommandPermissionsRequest {
        @Nullable
        List<ApplicationCommandPermissionsData> permissions = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="permissions")
        public void setPermissions(List<ApplicationCommandPermissionsData> permissions) {
            this.permissions = permissions;
        }

        @Override
        public List<ApplicationCommandPermissionsData> permissions() {
            throw new UnsupportedOperationException();
        }
    }
}

