/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationCommandOptionChoiceData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableApplicationCommandOptionChoiceData
implements ApplicationCommandOptionChoiceData {
    private final String name;
    private final Map<String, String> nameLocalizations_value;
    private final boolean nameLocalizations_absent;
    private final Object value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableApplicationCommandOptionChoiceData(String name, Possible<Optional<Map<String, String>>> nameLocalizations, Object value) {
        this.name = Objects.requireNonNull(name, "name");
        Possible<Optional<Map<String, String>>> nameLocalizations$impl = nameLocalizations;
        this.value = Objects.requireNonNull(value, "value");
        this.nameLocalizations_value = Possible.flatOpt(nameLocalizations$impl).orElse(null);
        this.nameLocalizations_absent = nameLocalizations$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableApplicationCommandOptionChoiceData(ImmutableApplicationCommandOptionChoiceData original, String name, Possible<Optional<Map<String, String>>> nameLocalizations, Object value) {
        this.name = name;
        Possible<Optional<Map<String, String>>> nameLocalizations$impl = nameLocalizations;
        this.value = value;
        this.nameLocalizations_value = Possible.flatOpt(nameLocalizations$impl).orElse(null);
        this.nameLocalizations_absent = nameLocalizations$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name_localizations")
    public Possible<Optional<Map<String, String>>> nameLocalizations() {
        return this.nameLocalizations_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nameLocalizations_value));
    }

    @Override
    @JsonProperty(value="value")
    public Object value() {
        return this.value;
    }

    public final ImmutableApplicationCommandOptionChoiceData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationCommandOptionChoiceData(this, newValue, this.nameLocalizations(), this.value);
    }

    public ImmutableApplicationCommandOptionChoiceData withNameLocalizations(Possible<Optional<Map<String, String>>> value) {
        Possible<Optional<Map<String, String>>> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationCommandOptionChoiceData(this, this.name, newValue, this.value);
    }

    @Deprecated
    public ImmutableApplicationCommandOptionChoiceData withNameLocalizations(@Nullable Map<String, String> value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableApplicationCommandOptionChoiceData(this, this.name, (Possible<Optional<Map<String, String>>>)newValue, this.value);
    }

    public ImmutableApplicationCommandOptionChoiceData withNameLocalizationsOrNull(@Nullable Map<String, String> value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableApplicationCommandOptionChoiceData(this, this.name, (Possible<Optional<Map<String, String>>>)newValue, this.value);
    }

    public final ImmutableApplicationCommandOptionChoiceData withValue(Object value) {
        if (this.value == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "value");
        return new ImmutableApplicationCommandOptionChoiceData(this, this.name, this.nameLocalizations(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationCommandOptionChoiceData && this.equalTo(0, (ImmutableApplicationCommandOptionChoiceData)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplicationCommandOptionChoiceData another) {
        return this.name.equals(another.name) && this.nameLocalizations().equals(another.nameLocalizations()) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.nameLocalizations().hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationCommandOptionChoiceData{name=" + this.name + ", nameLocalizations=" + this.nameLocalizations().toString() + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationCommandOptionChoiceData fromJson(Json json) {
        Builder builder = ImmutableApplicationCommandOptionChoiceData.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.nameLocalizations != null) {
            builder.nameLocalizations(json.nameLocalizations);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableApplicationCommandOptionChoiceData of(String name, Possible<Optional<Map<String, String>>> nameLocalizations, Object value) {
        return new ImmutableApplicationCommandOptionChoiceData(name, nameLocalizations, value);
    }

    public static ImmutableApplicationCommandOptionChoiceData copyOf(ApplicationCommandOptionChoiceData instance) {
        if (instance instanceof ImmutableApplicationCommandOptionChoiceData) {
            return (ImmutableApplicationCommandOptionChoiceData)instance;
        }
        return ImmutableApplicationCommandOptionChoiceData.builder().from(instance).build();
    }

    public boolean isNameLocalizationsPresent() {
        return !this.nameLocalizations_absent;
    }

    public Map<String, String> nameLocalizationsOrElse(Map<String, String> defaultValue) {
        return !this.nameLocalizations_absent ? this.nameLocalizations_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private Possible<Optional<Map<String, String>>> nameLocalizations_possible = Possible.absent();
        @Nullable
        private String name;
        @Nullable
        private Object value;

        private Builder() {
        }

        public final Builder from(ApplicationCommandOptionChoiceData instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.nameLocalizations(instance.nameLocalizations());
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name_localizations")
        public Builder nameLocalizations(Possible<Optional<Map<String, String>>> value) {
            this.nameLocalizations_possible = value;
            return this;
        }

        @Deprecated
        public Builder nameLocalizations(@Nullable Map<String, String> value) {
            this.nameLocalizations_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder nameLocalizationsOrNull(@Nullable Map<String, String> value) {
            this.nameLocalizations_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(Object value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableApplicationCommandOptionChoiceData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationCommandOptionChoiceData(null, this.name, this.nameLocalizations_build(), this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ApplicationCommandOptionChoiceData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<Map<String, String>>> nameLocalizations_build() {
            return this.nameLocalizations_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ApplicationCommandOptionChoiceData {
        @Nullable
        String name;
        Possible<Optional<Map<String, String>>> nameLocalizations = Possible.absent();
        @Nullable
        Object value;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name_localizations")
        public void setNameLocalizations(Possible<Optional<Map<String, String>>> nameLocalizations) {
            this.nameLocalizations = nameLocalizations;
        }

        @JsonProperty(value="value")
        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Map<String, String>>> nameLocalizations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationCommandOptionChoiceData, attribute initializers form cycle " + attributes;
        }
    }
}

