/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.response;

import discord4j.common.annotations.Experimental;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.request.RouteMatcher;
import discord4j.rest.response.ResponseFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Experimental
public class RetryingTransformer
implements ResponseFunction {
    private final RouteMatcher routeMatcher;
    private final reactor.retry.Retry<?> retryFactory;

    public RetryingTransformer(RouteMatcher routeMatcher, reactor.retry.Retry<?> retryFactory) {
        this.routeMatcher = routeMatcher;
        this.retryFactory = retryFactory;
    }

    @Override
    public Function<Mono<ClientResponse>, Mono<ClientResponse>> transform(DiscordWebRequest request) {
        if (this.routeMatcher.matches(request)) {
            return mono -> mono.retryWhen(Retry.withThrowable(this.retryFactory));
        }
        return mono -> mono;
    }
}

