/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http.client;

import discord4j.rest.http.client.ClientRequest;
import discord4j.rest.json.response.ErrorResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientResponse;
import reactor.retry.RetryContext;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public class ClientException
extends RuntimeException {
    private final ClientRequest request;
    private final HttpClientResponse response;
    private final ErrorResponse errorResponse;

    public ClientException(ClientRequest request, HttpClientResponse response, @Nullable ErrorResponse errorResponse) {
        super(request.getMethod().toString() + " " + request.getUrl() + " returned " + response.status().toString() + (errorResponse != null ? " with response " + errorResponse.getFields() : ""));
        this.request = request;
        this.response = response;
        this.errorResponse = errorResponse;
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public HttpClientResponse getResponse() {
        return this.response;
    }

    public HttpResponseStatus getStatus() {
        return this.getResponse().status();
    }

    public HttpHeaders getHeaders() {
        return this.getResponse().responseHeaders();
    }

    public Optional<ErrorResponse> getErrorResponse() {
        return Optional.ofNullable(this.errorResponse);
    }

    public static Predicate<Throwable> isStatusCode(int code) {
        return t -> {
            if (t instanceof ClientException) {
                ClientException e = (ClientException)t;
                return e.getStatus().code() == code;
            }
            return false;
        };
    }

    public static Predicate<Throwable> isStatusCode(Integer ... codes) {
        return t -> {
            if (t instanceof ClientException) {
                ClientException e = (ClientException)t;
                return Arrays.asList(codes).contains(e.getStatus().code());
            }
            return false;
        };
    }

    public static Predicate<RetryContext<?>> isRetryContextStatusCode(int code) {
        return ctx -> ClientException.isStatusCode(code).test(ctx.exception());
    }

    public static Predicate<RetryContext<?>> isRetryContextStatusCode(Integer ... codes) {
        return ctx -> ClientException.isStatusCode(codes).test(ctx.exception());
    }

    public static <T> Function<Mono<T>, Publisher<T>> emptyOnStatus(int code) {
        return mono -> mono.onErrorResume(ClientException.isStatusCode(code), t -> Mono.empty());
    }

    public static <T> Function<Mono<T>, Publisher<T>> retryOnceOnStatus(int code) {
        return mono -> mono.retryWhen((Retry)Retry.backoff((long)1L, (Duration)Duration.ofSeconds(1L)).filter(ClientException.isStatusCode(code)));
    }
}

