/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildUpdateFields;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.json.RoleData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestGuild;
import discord4j.rest.entity.RestRole;
import discord4j.rest.entity.RestUser;
import discord4j.rest.util.OrderUtil;
import java.util.Collection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.math.MathFlux;

public class RestMember {
    private final RestClient restClient;
    private final long guildId;
    private final long id;

    private RestMember(RestClient restClient, long guildId, long id) {
        this.restClient = restClient;
        this.guildId = guildId;
        this.id = id;
    }

    public static RestMember create(RestClient restClient, Snowflake guildId, Snowflake id) {
        return new RestMember(restClient, guildId.asLong(), id.asLong());
    }

    static RestMember create(RestClient restClient, long guildId, long id) {
        return new RestMember(restClient, guildId, id);
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Snowflake getId() {
        return Snowflake.of((long)this.id);
    }

    public RestGuild guild() {
        return RestGuild.create(this.restClient, this.guildId);
    }

    public RestUser user() {
        return RestUser.create(this.restClient, this.id);
    }

    public Mono<MemberData> getData() {
        return this.restClient.getGuildService().getGuildMember(this.guildId, this.id);
    }

    public Mono<RoleData> getHighestRole() {
        return this.getData().map(PartialMemberData::roles).flatMap(roles -> MathFlux.max((Publisher)Flux.fromIterable((Iterable)roles).map(id -> this.restClient.getRoleById(Snowflake.of((long)this.guildId), Snowflake.of((Id)id))).flatMap(RestRole::getData), OrderUtil.ROLE_ORDER));
    }

    public Mono<Boolean> isHigher(RestMember otherMember) {
        if (this.guildId != otherMember.guildId) {
            return Mono.error((Throwable)new IllegalArgumentException("The provided member is in a different guild."));
        }
        if (this.equals(otherMember)) {
            return Mono.just((Object)false);
        }
        return this.guild().getData().map(GuildUpdateFields::ownerId).flatMap(ownerId -> {
            if (ownerId.asLong() == this.id) {
                return Mono.just((Object)true);
            }
            if (ownerId.asLong() == otherMember.id) {
                return Mono.just((Object)false);
            }
            return otherMember.getData().flatMapMany(data -> Flux.fromIterable((Iterable)data.roles())).map(Snowflake::of).collectList().flatMap(this::hasHigherRoles);
        });
    }

    public Mono<Boolean> isHigher(Snowflake id) {
        return Mono.just((Object)this.restClient.getMemberById(Snowflake.of((long)this.guildId), id)).flatMap(this::isHigher);
    }

    public Mono<Boolean> hasHigherRoles(Collection<Snowflake> otherRoles) {
        return this.guild().getRoles().transform(OrderUtil::orderRoles).collectList().flatMap(guildRoles -> {
            Mono thisRoleIds = this.getData().map(PartialMemberData::roles).flatMapMany(Flux::fromIterable).map(Snowflake::of).collectList().cache();
            Mono thisHighestRolePos = thisRoleIds.map(thisRoles -> guildRoles.stream().filter(role -> thisRoles.contains(Snowflake.of((Id)role.id()))).max(OrderUtil.ROLE_ORDER).map(guildRoles::indexOf).orElse(0));
            int otherHighestPos = guildRoles.stream().filter(role -> otherRoles.contains(Snowflake.of((Id)role.id()))).max(OrderUtil.ROLE_ORDER).map(guildRoles::indexOf).orElse(0);
            return thisHighestRolePos.map(thisPos -> thisPos > otherHighestPos);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestMember that = (RestMember)o;
        return this.guildId == that.guildId && this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.guildId, this.id);
    }
}

