/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.gateway.VoiceChannelEffectSend;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableVoiceChannelEffectSend
implements VoiceChannelEffectSend {
    private final long channelId_value;
    private final long guildId_value;
    private final long userId_value;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private final Integer animationType_value;
    private final boolean animationType_absent;
    private final Integer animationId_value;
    private final boolean animationId_absent;
    private final Integer soundId_value;
    private final boolean soundId_absent;
    private final Double soundVolume_value;
    private final boolean soundVolume_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVoiceChannelEffectSend(Id channelId, Id guildId, Id userId, Possible<Optional<EmojiData>> emoji, Possible<Optional<Integer>> animationType, Possible<Integer> animationId, Possible<Integer> soundId, Possible<Double> soundVolume) {
        Id channelId$impl = channelId;
        Id guildId$impl = guildId;
        Id userId$impl = userId;
        Possible<Optional<EmojiData>> emoji$impl = emoji;
        Possible<Optional<Integer>> animationType$impl = animationType;
        Possible<Integer> animationId$impl = animationId;
        Possible<Integer> soundId$impl = soundId;
        Possible<Double> soundVolume$impl = soundVolume;
        this.channelId_value = channelId$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.userId_value = userId$impl.asLong();
        this.emoji_value = Possible.flatOpt(emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.animationType_value = Possible.flatOpt(animationType$impl).orElse(null);
        this.animationType_absent = animationType$impl.isAbsent();
        this.animationId_value = animationId$impl.toOptional().orElse(null);
        this.animationId_absent = animationId$impl.isAbsent();
        this.soundId_value = soundId$impl.toOptional().orElse(null);
        this.soundId_absent = soundId$impl.isAbsent();
        this.soundVolume_value = soundVolume$impl.toOptional().orElse(null);
        this.soundVolume_absent = soundVolume$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableVoiceChannelEffectSend(ImmutableVoiceChannelEffectSend original, Id channelId, Id guildId, Id userId, Possible<Optional<EmojiData>> emoji, Possible<Optional<Integer>> animationType, Possible<Integer> animationId, Possible<Integer> soundId, Possible<Double> soundVolume) {
        Id channelId$impl = channelId;
        Id guildId$impl = guildId;
        Id userId$impl = userId;
        Possible<Optional<EmojiData>> emoji$impl = emoji;
        Possible<Optional<Integer>> animationType$impl = animationType;
        Possible<Integer> animationId$impl = animationId;
        Possible<Integer> soundId$impl = soundId;
        Possible<Double> soundVolume$impl = soundVolume;
        this.channelId_value = channelId$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.userId_value = userId$impl.asLong();
        this.emoji_value = Possible.flatOpt(emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.animationType_value = Possible.flatOpt(animationType$impl).orElse(null);
        this.animationType_absent = animationType$impl.isAbsent();
        this.animationId_value = animationId$impl.toOptional().orElse(null);
        this.animationId_absent = animationId$impl.isAbsent();
        this.soundId_value = soundId$impl.toOptional().orElse(null);
        this.soundId_absent = soundId$impl.isAbsent();
        this.soundVolume_value = soundVolume$impl.toOptional().orElse(null);
        this.soundVolume_absent = soundVolume$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="user_id")
    public Id userId() {
        return Id.of((long)this.userId_value);
    }

    @Override
    @JsonProperty(value="emoji")
    public Possible<Optional<EmojiData>> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emoji_value));
    }

    @Override
    @JsonProperty(value="animation_type")
    public Possible<Optional<Integer>> animationType() {
        return this.animationType_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.animationType_value));
    }

    @Override
    @JsonProperty(value="animation_id")
    public Possible<Integer> animationId() {
        return this.animationId_absent ? Possible.absent() : Possible.of((Object)this.animationId_value);
    }

    @Override
    @JsonProperty(value="sound_id")
    public Possible<Integer> soundId() {
        return this.soundId_absent ? Possible.absent() : Possible.of((Object)this.soundId_value);
    }

    @Override
    @JsonProperty(value="sound_volume")
    public Possible<Double> soundVolume() {
        return this.soundVolume_absent ? Possible.absent() : Possible.of((Object)this.soundVolume_value);
    }

    public ImmutableVoiceChannelEffectSend withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableVoiceChannelEffectSend(this, newValue, this.guildId(), this.userId(), this.emoji(), this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableVoiceChannelEffectSend(this, newValue, this.guildId(), this.userId(), this.emoji(), this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), newValue, this.userId(), this.emoji(), this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), newValue, this.userId(), this.emoji(), this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), newValue, this.emoji(), this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), newValue, this.emoji(), this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withEmoji(Possible<Optional<EmojiData>> value) {
        Possible<Optional<EmojiData>> newValue = Objects.requireNonNull(value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), newValue, this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    @Deprecated
    public ImmutableVoiceChannelEffectSend withEmoji(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), (Possible<Optional<EmojiData>>)newValue, this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withEmojiOrNull(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), (Possible<Optional<EmojiData>>)newValue, this.animationType(), this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withAnimationType(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), newValue, this.animationId(), this.soundId(), this.soundVolume());
    }

    @Deprecated
    public ImmutableVoiceChannelEffectSend withAnimationType(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), (Possible<Optional<Integer>>)newValue, this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withAnimationTypeOrNull(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), (Possible<Optional<Integer>>)newValue, this.animationId(), this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withAnimationId(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), this.animationType(), newValue, this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withAnimationId(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), this.animationType(), (Possible<Integer>)newValue, this.soundId(), this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withSoundId(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), this.animationType(), this.animationId(), newValue, this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withSoundId(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), this.animationType(), this.animationId(), (Possible<Integer>)newValue, this.soundVolume());
    }

    public ImmutableVoiceChannelEffectSend withSoundVolume(Possible<Double> value) {
        Possible<Double> newValue = Objects.requireNonNull(value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), this.animationType(), this.animationId(), this.soundId(), newValue);
    }

    public ImmutableVoiceChannelEffectSend withSoundVolume(Double value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableVoiceChannelEffectSend(this, this.channelId(), this.guildId(), this.userId(), this.emoji(), this.animationType(), this.animationId(), this.soundId(), (Possible<Double>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVoiceChannelEffectSend && this.equalTo(0, (ImmutableVoiceChannelEffectSend)another);
    }

    private boolean equalTo(int synthetic, ImmutableVoiceChannelEffectSend another) {
        return Objects.equals(this.channelId_value, another.channelId_value) && Objects.equals(this.guildId_value, another.guildId_value) && Objects.equals(this.userId_value, another.userId_value) && this.emoji().equals(another.emoji()) && this.animationType().equals(another.animationType()) && this.animationId().equals(another.animationId()) && this.soundId().equals(another.soundId()) && this.soundVolume().equals(another.soundVolume());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + Objects.hashCode(this.userId_value);
        h += (h << 5) + this.emoji().hashCode();
        h += (h << 5) + this.animationType().hashCode();
        h += (h << 5) + this.animationId().hashCode();
        h += (h << 5) + this.soundId().hashCode();
        h += (h << 5) + this.soundVolume().hashCode();
        return h;
    }

    public String toString() {
        return "VoiceChannelEffectSend{channelId=" + Objects.toString(this.channelId_value) + ", guildId=" + Objects.toString(this.guildId_value) + ", userId=" + Objects.toString(this.userId_value) + ", emoji=" + this.emoji().toString() + ", animationType=" + this.animationType().toString() + ", animationId=" + this.animationId().toString() + ", soundId=" + this.soundId().toString() + ", soundVolume=" + this.soundVolume().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableVoiceChannelEffectSend fromJson(Json json) {
        Builder builder = ImmutableVoiceChannelEffectSend.builder();
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        if (json.animationType != null) {
            builder.animationType(json.animationType);
        }
        if (json.animationId != null) {
            builder.animationId(json.animationId);
        }
        if (json.soundId != null) {
            builder.soundId(json.soundId);
        }
        if (json.soundVolume != null) {
            builder.soundVolume(json.soundVolume);
        }
        return builder.build();
    }

    public static ImmutableVoiceChannelEffectSend of(Id channelId, Id guildId, Id userId, Possible<Optional<EmojiData>> emoji, Possible<Optional<Integer>> animationType, Possible<Integer> animationId, Possible<Integer> soundId, Possible<Double> soundVolume) {
        return new ImmutableVoiceChannelEffectSend(channelId, guildId, userId, emoji, animationType, animationId, soundId, soundVolume);
    }

    public static ImmutableVoiceChannelEffectSend copyOf(VoiceChannelEffectSend instance) {
        if (instance instanceof ImmutableVoiceChannelEffectSend) {
            return (ImmutableVoiceChannelEffectSend)instance;
        }
        return ImmutableVoiceChannelEffectSend.builder().from(instance).build();
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    public boolean isAnimationTypePresent() {
        return !this.animationType_absent;
    }

    public Integer animationTypeOrElse(Integer defaultValue) {
        return !this.animationType_absent ? this.animationType_value : defaultValue;
    }

    public boolean isAnimationIdPresent() {
        return !this.animationId_absent;
    }

    public Integer animationIdOrElse(Integer defaultValue) {
        return !this.animationId_absent ? this.animationId_value : defaultValue;
    }

    public boolean isSoundIdPresent() {
        return !this.soundId_absent;
    }

    public Integer soundIdOrElse(Integer defaultValue) {
        return !this.soundId_absent ? this.soundId_value : defaultValue;
    }

    public boolean isSoundVolumePresent() {
        return !this.soundVolume_absent;
    }

    public Double soundVolumeOrElse(Double defaultValue) {
        return !this.soundVolume_absent ? this.soundVolume_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Id channelId_id = null;
        private Id guildId_id = null;
        private Id userId_id = null;
        private Possible<Optional<EmojiData>> emoji_possible = Possible.absent();
        private Possible<Optional<Integer>> animationType_possible = Possible.absent();
        private Possible<Integer> animationId_possible = Possible.absent();
        private Possible<Integer> soundId_possible = Possible.absent();
        private Possible<Double> soundVolume_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(VoiceChannelEffectSend instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelId(instance.channelId());
            this.guildId(instance.guildId());
            this.userId(instance.userId());
            this.emoji(instance.emoji());
            this.animationType(instance.animationType());
            this.animationId(instance.animationId());
            this.soundId(instance.soundId());
            this.soundVolume(instance.soundVolume());
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public Builder userId(String value) {
            this.userId_id = Id.of((String)value);
            return this;
        }

        public Builder userId(long value) {
            this.userId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userId(Id value) {
            this.userId_id = value;
            return this;
        }

        @JsonProperty(value="emoji")
        public Builder emoji(Possible<Optional<EmojiData>> value) {
            this.emoji_possible = value;
            return this;
        }

        @Deprecated
        public Builder emoji(@Nullable EmojiData value) {
            this.emoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emojiOrNull(@Nullable EmojiData value) {
            this.emoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="animation_type")
        public Builder animationType(Possible<Optional<Integer>> value) {
            this.animationType_possible = value;
            return this;
        }

        @Deprecated
        public Builder animationType(@Nullable Integer value) {
            this.animationType_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder animationTypeOrNull(@Nullable Integer value) {
            this.animationType_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="animation_id")
        public Builder animationId(Possible<Integer> value) {
            this.animationId_possible = value;
            return this;
        }

        public Builder animationId(Integer value) {
            this.animationId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="sound_id")
        public Builder soundId(Possible<Integer> value) {
            this.soundId_possible = value;
            return this;
        }

        public Builder soundId(Integer value) {
            this.soundId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="sound_volume")
        public Builder soundVolume(Possible<Double> value) {
            this.soundVolume_possible = value;
            return this;
        }

        public Builder soundVolume(Double value) {
            this.soundVolume_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableVoiceChannelEffectSend build() {
            return new ImmutableVoiceChannelEffectSend(null, this.channelId_build(), this.guildId_build(), this.userId_build(), this.emoji_build(), this.animationType_build(), this.animationId_build(), this.soundId_build(), this.soundVolume_build());
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Id userId_build() {
            return this.userId_id;
        }

        private Possible<Optional<EmojiData>> emoji_build() {
            return this.emoji_possible;
        }

        private Possible<Optional<Integer>> animationType_build() {
            return this.animationType_possible;
        }

        private Possible<Integer> animationId_build() {
            return this.animationId_possible;
        }

        private Possible<Integer> soundId_build() {
            return this.soundId_possible;
        }

        private Possible<Double> soundVolume_build() {
            return this.soundVolume_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements VoiceChannelEffectSend {
        @Nullable
        Id channelId;
        @Nullable
        Id guildId;
        @Nullable
        Id userId;
        Possible<Optional<EmojiData>> emoji = Possible.absent();
        Possible<Optional<Integer>> animationType = Possible.absent();
        Possible<Integer> animationId = Possible.absent();
        Possible<Integer> soundId = Possible.absent();
        Possible<Double> soundVolume = Possible.absent();

        Json() {
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="user_id")
        public void setUserId(Id userId) {
            this.userId = userId;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(Possible<Optional<EmojiData>> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty(value="animation_type")
        public void setAnimationType(Possible<Optional<Integer>> animationType) {
            this.animationType = animationType;
        }

        @JsonProperty(value="animation_id")
        public void setAnimationId(Possible<Integer> animationId) {
            this.animationId = animationId;
        }

        @JsonProperty(value="sound_id")
        public void setSoundId(Possible<Integer> soundId) {
            this.soundId = soundId;
        }

        @JsonProperty(value="sound_volume")
        public void setSoundVolume(Possible<Double> soundVolume) {
            this.soundVolume = soundVolume;
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<EmojiData>> emoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Integer>> animationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> animationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> soundId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Double> soundVolume() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build VoiceChannelEffectSend, attribute initializers form cycle " + attributes;
        }
    }
}

