/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.SubscriptionListRequestSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SubscriptionListRequestSpec
implements SubscriptionListRequestSpecGenerator {
    private final Snowflake userId_value;
    private final boolean userId_absent;
    private final Snowflake before_value;
    private final boolean before_absent;
    private final Snowflake after_value;
    private final boolean after_absent;
    private final Integer limit_value;
    private final boolean limit_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SubscriptionListRequestSpec(Possible<Snowflake> userId, Possible<Snowflake> before, Possible<Snowflake> after, Possible<Integer> limit) {
        Possible<Snowflake> userId$impl = userId;
        Possible<Snowflake> before$impl = before;
        Possible<Snowflake> after$impl = after;
        Possible<Integer> limit$impl = limit;
        this.userId_value = userId$impl.toOptional().orElse(null);
        this.userId_absent = userId$impl.isAbsent();
        this.before_value = before$impl.toOptional().orElse(null);
        this.before_absent = before$impl.isAbsent();
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Snowflake> userId() {
        return this.userId_absent ? Possible.absent() : Possible.of((Object)this.userId_value);
    }

    @Override
    public Possible<Snowflake> before() {
        return this.before_absent ? Possible.absent() : Possible.of((Object)this.before_value);
    }

    @Override
    public Possible<Snowflake> after() {
        return this.after_absent ? Possible.absent() : Possible.of((Object)this.after_value);
    }

    @Override
    public Possible<Integer> limit() {
        return this.limit_absent ? Possible.absent() : Possible.of((Object)this.limit_value);
    }

    public SubscriptionListRequestSpec withUserId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestSpec(newValue, this.before(), this.after(), this.limit());
    }

    public SubscriptionListRequestSpec withUserId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestSpec((Possible<Snowflake>)newValue, this.before(), this.after(), this.limit());
    }

    public SubscriptionListRequestSpec withBefore(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestSpec(this.userId(), newValue, this.after(), this.limit());
    }

    public SubscriptionListRequestSpec withBefore(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestSpec(this.userId(), (Possible<Snowflake>)newValue, this.after(), this.limit());
    }

    public SubscriptionListRequestSpec withAfter(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestSpec(this.userId(), this.before(), newValue, this.limit());
    }

    public SubscriptionListRequestSpec withAfter(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestSpec(this.userId(), this.before(), (Possible<Snowflake>)newValue, this.limit());
    }

    public SubscriptionListRequestSpec withLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new SubscriptionListRequestSpec(this.userId(), this.before(), this.after(), newValue);
    }

    public SubscriptionListRequestSpec withLimit(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new SubscriptionListRequestSpec(this.userId(), this.before(), this.after(), (Possible<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SubscriptionListRequestSpec && this.equalTo(0, (SubscriptionListRequestSpec)another);
    }

    private boolean equalTo(int synthetic, SubscriptionListRequestSpec another) {
        return this.userId().equals(another.userId()) && this.before().equals(another.before()) && this.after().equals(another.after()) && this.limit().equals(another.limit());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId().hashCode();
        h += (h << 5) + this.before().hashCode();
        h += (h << 5) + this.after().hashCode();
        h += (h << 5) + this.limit().hashCode();
        return h;
    }

    public String toString() {
        return "SubscriptionListRequestSpec{userId=" + this.userId().toString() + ", before=" + this.before().toString() + ", after=" + this.after().toString() + ", limit=" + this.limit().toString() + "}";
    }

    public static SubscriptionListRequestSpec copyOf(SubscriptionListRequestSpecGenerator instance) {
        if (instance instanceof SubscriptionListRequestSpec) {
            return (SubscriptionListRequestSpec)instance;
        }
        return SubscriptionListRequestSpec.builder().from(instance).build();
    }

    public boolean isUserIdPresent() {
        return !this.userId_absent;
    }

    public Snowflake userIdOrElse(Snowflake defaultValue) {
        return !this.userId_absent ? this.userId_value : defaultValue;
    }

    public boolean isBeforePresent() {
        return !this.before_absent;
    }

    public Snowflake beforeOrElse(Snowflake defaultValue) {
        return !this.before_absent ? this.before_value : defaultValue;
    }

    public boolean isAfterPresent() {
        return !this.after_absent;
    }

    public Snowflake afterOrElse(Snowflake defaultValue) {
        return !this.after_absent ? this.after_value : defaultValue;
    }

    public boolean isLimitPresent() {
        return !this.limit_absent;
    }

    public Integer limitOrElse(Integer defaultValue) {
        return !this.limit_absent ? this.limit_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<Snowflake> userId_possible = Possible.absent();
        private Possible<Snowflake> before_possible = Possible.absent();
        private Possible<Snowflake> after_possible = Possible.absent();
        private Possible<Integer> limit_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(SubscriptionListRequestSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.userId());
            this.before(instance.before());
            this.after(instance.after());
            this.limit(instance.limit());
            return this;
        }

        public Builder userId(Possible<Snowflake> value) {
            this.userId_possible = value;
            return this;
        }

        public Builder userId(Snowflake value) {
            this.userId_possible = Possible.of((Object)value);
            return this;
        }

        public Builder before(Possible<Snowflake> value) {
            this.before_possible = value;
            return this;
        }

        public Builder before(Snowflake value) {
            this.before_possible = Possible.of((Object)value);
            return this;
        }

        public Builder after(Possible<Snowflake> value) {
            this.after_possible = value;
            return this;
        }

        public Builder after(Snowflake value) {
            this.after_possible = Possible.of((Object)value);
            return this;
        }

        public Builder limit(Possible<Integer> value) {
            this.limit_possible = value;
            return this;
        }

        public Builder limit(Integer value) {
            this.limit_possible = Possible.of((Object)value);
            return this;
        }

        public SubscriptionListRequestSpec build() {
            return new SubscriptionListRequestSpec(this.userId_build(), this.before_build(), this.after_build(), this.limit_build());
        }

        private Possible<Snowflake> userId_build() {
            return this.userId_possible;
        }

        private Possible<Snowflake> before_build() {
            return this.before_possible;
        }

        private Possible<Snowflake> after_build() {
            return this.after_possible;
        }

        private Possible<Integer> limit_build() {
            return this.limit_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SubscriptionListRequestSpec, attribute initializers form cycle " + attributes;
        }
    }
}

