/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.PollVotersRequestSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class PollVotersRequestSpec
implements PollVotersRequestSpecGenerator {
    private final Snowflake after_value;
    private final boolean after_absent;
    private final Integer limit_value;
    private final boolean limit_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PollVotersRequestSpec(Possible<Snowflake> after, Possible<Integer> limit) {
        Possible<Snowflake> after$impl = after;
        Possible<Integer> limit$impl = limit;
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Snowflake> after() {
        return this.after_absent ? Possible.absent() : Possible.of((Object)this.after_value);
    }

    @Override
    public Possible<Integer> limit() {
        return this.limit_absent ? Possible.absent() : Possible.of((Object)this.limit_value);
    }

    public PollVotersRequestSpec withAfter(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new PollVotersRequestSpec(newValue, this.limit());
    }

    public PollVotersRequestSpec withAfter(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new PollVotersRequestSpec((Possible<Snowflake>)newValue, this.limit());
    }

    public PollVotersRequestSpec withLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new PollVotersRequestSpec(this.after(), newValue);
    }

    public PollVotersRequestSpec withLimit(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new PollVotersRequestSpec(this.after(), (Possible<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PollVotersRequestSpec && this.equalTo(0, (PollVotersRequestSpec)another);
    }

    private boolean equalTo(int synthetic, PollVotersRequestSpec another) {
        return this.after().equals(another.after()) && this.limit().equals(another.limit());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.after().hashCode();
        h += (h << 5) + this.limit().hashCode();
        return h;
    }

    public String toString() {
        return "PollVotersRequestSpec{after=" + this.after().toString() + ", limit=" + this.limit().toString() + "}";
    }

    public static PollVotersRequestSpec copyOf(PollVotersRequestSpecGenerator instance) {
        if (instance instanceof PollVotersRequestSpec) {
            return (PollVotersRequestSpec)instance;
        }
        return PollVotersRequestSpec.builder().from(instance).build();
    }

    public boolean isAfterPresent() {
        return !this.after_absent;
    }

    public Snowflake afterOrElse(Snowflake defaultValue) {
        return !this.after_absent ? this.after_value : defaultValue;
    }

    public boolean isLimitPresent() {
        return !this.limit_absent;
    }

    public Integer limitOrElse(Integer defaultValue) {
        return !this.limit_absent ? this.limit_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<Snowflake> after_possible = Possible.absent();
        private Possible<Integer> limit_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(PollVotersRequestSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.after(instance.after());
            this.limit(instance.limit());
            return this;
        }

        public Builder after(Possible<Snowflake> value) {
            this.after_possible = value;
            return this;
        }

        public Builder after(Snowflake value) {
            this.after_possible = Possible.of((Object)value);
            return this;
        }

        public Builder limit(Possible<Integer> value) {
            this.limit_possible = value;
            return this;
        }

        public Builder limit(Integer value) {
            this.limit_possible = Possible.of((Object)value);
            return this;
        }

        public PollVotersRequestSpec build() {
            return new PollVotersRequestSpec(this.after_build(), this.limit_build());
        }

        private Possible<Snowflake> after_build() {
            return this.after_possible;
        }

        private Possible<Integer> limit_build() {
            return this.limit_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollVotersRequestSpec, attribute initializers form cycle " + attributes;
        }
    }
}

