/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpecGenerator;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class InteractionApplicationCommandCallbackSpec
implements InteractionApplicationCommandCallbackSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final Boolean ephemeral_value;
    private final boolean ephemeral_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final InteractionApplicationCommandCallbackSpec INSTANCE = InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec());

    private InteractionApplicationCommandCallbackSpec() {
        Possible content$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible ephemeral$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private InteractionApplicationCommandCallbackSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible tts$impl = builder.tts_build();
        Possible ephemeral$impl = builder.ephemeral_build();
        Possible embeds$impl = builder.embeds_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible components$impl = builder.components_build();
        if (builder.filesIsSet()) {
            this.initShim.files(InteractionApplicationCommandCallbackSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(InteractionApplicationCommandCallbackSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private InteractionApplicationCommandCallbackSpec(Possible<String> content, Possible<Boolean> tts, Possible<Boolean> ephemeral, Possible<List<EmbedCreateSpec>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<List<TopLevelMessageComponent>> components) {
        Possible<String> content$impl = content;
        Possible<Boolean> tts$impl = tts;
        Possible<Boolean> ephemeral$impl = ephemeral;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<TopLevelMessageComponent>> components$impl = components;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return InteractionApplicationCommandCallbackSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return InteractionApplicationCommandCallbackSpecGenerator.super.fileSpoilers();
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<Boolean> ephemeral() {
        return this.ephemeral_absent ? Possible.absent() : Possible.of((Object)this.ephemeral_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<TopLevelMessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public InteractionApplicationCommandCallbackSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(newValue, this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec((Possible<String>)newValue, this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), newValue, this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), (Possible<Boolean>)newValue, this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEphemeral(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEphemeral(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), (Possible<Boolean>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    @SafeVarargs
    public final InteractionApplicationCommandCallbackSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public final InteractionApplicationCommandCallbackSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = InteractionApplicationCommandCallbackSpec.createUnmodifiableList(false, InteractionApplicationCommandCallbackSpec.createSafeList(Arrays.asList(elements), true, false));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public final InteractionApplicationCommandCallbackSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = InteractionApplicationCommandCallbackSpec.createUnmodifiableList(false, InteractionApplicationCommandCallbackSpec.createSafeList(elements, true, false));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components()));
    }

    public final InteractionApplicationCommandCallbackSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = InteractionApplicationCommandCallbackSpec.createUnmodifiableList(false, InteractionApplicationCommandCallbackSpec.createSafeList(Arrays.asList(elements), true, false));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components()));
    }

    public final InteractionApplicationCommandCallbackSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = InteractionApplicationCommandCallbackSpec.createUnmodifiableList(false, InteractionApplicationCommandCallbackSpec.createSafeList(elements, true, false));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, (Possible<AllowedMentions>)newValue, this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withComponents(Possible<List<TopLevelMessageComponent>> possible) {
        Possible<List<TopLevelMessageComponent>> newValue = Objects.requireNonNull(possible);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue));
    }

    public InteractionApplicationCommandCallbackSpec withComponents(Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue));
    }

    @SafeVarargs
    public final InteractionApplicationCommandCallbackSpec withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractionApplicationCommandCallbackSpec && this.equalTo(0, (InteractionApplicationCommandCallbackSpec)another);
    }

    private boolean equalTo(int synthetic, InteractionApplicationCommandCallbackSpec another) {
        return this.content().equals(another.content()) && this.tts().equals(another.tts()) && this.ephemeral().equals(another.ephemeral()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + this.ephemeral().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        return h;
    }

    public String toString() {
        return "InteractionApplicationCommandCallbackSpec{content=" + this.content().toString() + ", tts=" + this.tts().toString() + ", ephemeral=" + this.ephemeral().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + "}";
    }

    public static InteractionApplicationCommandCallbackSpec create() {
        return INSTANCE;
    }

    private static InteractionApplicationCommandCallbackSpec validate(InteractionApplicationCommandCallbackSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static InteractionApplicationCommandCallbackSpec copyOf(InteractionApplicationCommandCallbackSpecGenerator instance) {
        if (instance instanceof InteractionApplicationCommandCallbackSpec) {
            return (InteractionApplicationCommandCallbackSpec)instance;
        }
        return InteractionApplicationCommandCallbackSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEphemeralPresent() {
        return !this.ephemeral_absent;
    }

    public Boolean ephemeralOrElse(Boolean defaultValue) {
        return !this.ephemeral_absent ? this.ephemeral_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_FILES = 1L;
        private static final long OPT_BIT_FILE_SPOILERS = 2L;
        private long optBits;
        private Possible<String> content_possible = Possible.absent();
        private Possible<Boolean> tts_possible = Possible.absent();
        private Possible<Boolean> ephemeral_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private List<TopLevelMessageComponent> components_list = null;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();

        private Builder() {
        }

        public final Builder from(InteractionApplicationCommandCallbackSpec instance) {
            return this.from((InteractionApplicationCommandCallbackSpecGenerator)instance);
        }

        final Builder from(InteractionApplicationCommandCallbackSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.tts(instance.tts());
            this.ephemeral(instance.ephemeral());
            this.embeds(instance.embeds());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            return this;
        }

        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        public Builder tts(Possible<Boolean> value) {
            this.tts_possible = value;
            return this;
        }

        public Builder tts(Boolean value) {
            this.tts_possible = Possible.of((Object)value);
            return this;
        }

        public Builder ephemeral(Possible<Boolean> value) {
            this.ephemeral_possible = value;
            return this;
        }

        public Builder ephemeral(Boolean value) {
            this.ephemeral_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedCreateSpec>)e));
            return this;
        }

        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            return this;
        }

        public Builder embeds(Iterable<EmbedCreateSpec> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addComponent(TopLevelMessageComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        public Builder addAllComponents(List<TopLevelMessageComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        public Builder components(Possible<List<TopLevelMessageComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<TopLevelMessageComponent>)e));
            return this;
        }

        public Builder components(List<TopLevelMessageComponent> elements) {
            this.components_list = new ArrayList<TopLevelMessageComponent>(elements);
            return this;
        }

        public Builder components(Iterable<TopLevelMessageComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public InteractionApplicationCommandCallbackSpec build() {
            return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this));
        }

        private boolean filesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<Boolean> tts_build() {
            return this.tts_possible;
        }

        private Possible<Boolean> ephemeral_build() {
            return this.ephemeral_possible;
        }

        private Possible<List<EmbedCreateSpec>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<List<TopLevelMessageComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<TopLevelMessageComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<TopLevelMessageComponent>();
            }
            return this.components_list;
        }
    }

    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = InteractionApplicationCommandCallbackSpec.createUnmodifiableList(false, InteractionApplicationCommandCallbackSpec.createSafeList(InteractionApplicationCommandCallbackSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = InteractionApplicationCommandCallbackSpec.createUnmodifiableList(false, InteractionApplicationCommandCallbackSpec.createSafeList(InteractionApplicationCommandCallbackSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build InteractionApplicationCommandCallbackSpec, attribute initializers form cycle " + attributes;
        }
    }
}

