/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.entity.Emoji;
import discord4j.core.object.entity.User;
import discord4j.core.spec.ApplicationEmojiEditMono;
import discord4j.core.spec.ApplicationEmojiEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.UserData;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class ApplicationEmoji
extends Emoji {
    private final long applicationId;

    public ApplicationEmoji(GatewayDiscordClient gateway, EmojiData data, long applicationId) {
        super(gateway, data);
        this.applicationId = applicationId;
    }

    public Snowflake getApplicationId() {
        return Snowflake.of((long)this.applicationId);
    }

    public Mono<ApplicationInfo> getApplication() {
        return this.getClient().getApplicationInfo();
    }

    public ApplicationEmojiEditMono edit() {
        return ApplicationEmojiEditMono.of(this);
    }

    public Mono<ApplicationEmoji> edit(ApplicationEmojiEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getEmojiService().modifyApplicationEmoji(this.applicationId, this.getId().asLong(), spec.asRequest())).map(data -> new ApplicationEmoji(this.getClient(), (EmojiData)data, this.getApplicationId().asLong()));
    }

    public Mono<Void> delete() {
        return this.getClient().getRestClient().getEmojiService().deleteApplicationEmoji(this.applicationId, this.getId().asLong());
    }

    @Override
    public Mono<User> getUser() {
        UserData user = (UserData)this.data.user().toOptional().orElseThrow(IllegalStateException::new);
        return this.gateway.getRestClient().getEmojiService().getApplicationEmoji(this.applicationId, this.getId().asLong()).map(data -> new User(this.gateway, user));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    @Override
    public String toString() {
        return "ApplicationEmoji{data=" + this.data + ", applicationId=" + this.applicationId + '}';
    }
}

