/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildFields;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.UserData;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class Invite
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final InviteData data;

    public Invite(GatewayDiscordClient gateway, InviteData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public final GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public final String getCode() {
        return this.data.code();
    }

    public final Optional<Snowflake> getGuildId() {
        return this.data.guild().toOptional().map(GuildFields::id).map(Snowflake::of);
    }

    public final Mono<Guild> getGuild() {
        return this.getGuildId().map(this.gateway::getGuildById).orElse(Mono.empty());
    }

    public final Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getGuildId().map(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById((Snowflake)id)).orElse(Mono.empty());
    }

    public final Snowflake getChannelId() {
        return Snowflake.of((Id)this.data.channel().id());
    }

    public final Mono<CategorizableChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(CategorizableChannel.class);
    }

    public final Mono<CategorizableChannel> getChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getChannelId()).cast(CategorizableChannel.class);
    }

    public final Optional<Snowflake> getInviterId() {
        return this.data.inviter().toOptional().map(UserData::id).map(Snowflake::of);
    }

    public final Optional<User> getInviter() {
        return this.data.inviter().toOptional().map(data -> new User(this.gateway, (UserData)data));
    }

    public final Optional<Snowflake> getTargetUserId() {
        return this.data.targetUser().toOptional().map(UserData::id).map(Snowflake::of);
    }

    public final Optional<User> getTargetUser() {
        return this.data.targetUser().toOptional().map(data -> new User(this.gateway, (UserData)data));
    }

    @Deprecated
    public final Optional<Type> getTargetUserType() {
        return this.getTargetType();
    }

    public final Optional<Type> getTargetType() {
        return this.data.targetType().toOptional().map(Type::of);
    }

    public final OptionalInt getApproximatePresenceCount() {
        return this.data.approximatePresenceCount().toOptional().map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public final OptionalInt getApproximateMemberCount() {
        return this.data.approximateMemberCount().toOptional().map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public final Mono<Void> delete() {
        return this.delete(null);
    }

    public final Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getInviteService().deleteInvite(this.getCode(), reason).then();
    }

    InviteData getData() {
        return this.data;
    }

    public String toString() {
        return "Invite{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        STREAM(1),
        EMBEDDED_APPLICATION(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return STREAM;
                }
                case 2: {
                    return EMBEDDED_APPLICATION;
                }
            }
            return UNKNOWN;
        }
    }
}

