/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice.crypto;

import java.security.Security;

public enum EncryptionMode {
    AEAD_AES256_GCM("aead_aes256_gcm_rtpsize"),
    AEAD_XCHACHA20_POLY1305("aead_xchacha20_poly1305_rtpsize");

    private final String value;

    private EncryptionMode(String value) {
        this.value = value;
    }

    public boolean isAvailable() {
        switch (this) {
            case AEAD_AES256_GCM: {
                return Security.getAlgorithms("Cipher").contains("AES_256/GCM/NOPADDING");
            }
            case AEAD_XCHACHA20_POLY1305: {
                return true;
            }
        }
        return false;
    }

    public static EncryptionMode getBestMode() {
        for (EncryptionMode value : EncryptionMode.values()) {
            if (!value.isAvailable()) continue;
            return value;
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }
}

