/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.RecurrenceRuleSpec;
import discord4j.core.spec.RecurrenceRuleSpecGenerator;
import discord4j.core.spec.ScheduledEventEntityMetadataSpec;
import discord4j.core.spec.ScheduledEventEntityMetadataSpecGenerator;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildScheduledEventCreateRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.time.Instant;
import org.immutables.value.Value;

@Value.Immutable
public interface ScheduledEventCreateSpecGenerator
extends AuditSpec<GuildScheduledEventCreateRequest> {
    public Possible<Snowflake> channelId();

    public Possible<ScheduledEventEntityMetadataSpec> entityMetadata();

    public String name();

    public ScheduledEvent.PrivacyLevel privacyLevel();

    public Instant scheduledStartTime();

    public Possible<Instant> scheduledEndTime();

    public Possible<String> description();

    public ScheduledEvent.EntityType entityType();

    public Possible<Image> image();

    public Possible<RecurrenceRuleSpec> recurrenceRule();

    @Override
    default public GuildScheduledEventCreateRequest asRequest() {
        return GuildScheduledEventCreateRequest.builder().channelId(InternalSpecUtils.mapPossible(this.channelId(), snowflake -> Id.of((long)snowflake.asLong()))).entityMetadata(InternalSpecUtils.mapPossible(this.entityMetadata(), ScheduledEventEntityMetadataSpecGenerator::asRequest)).name(this.name()).privacyLevel(this.privacyLevel().getValue()).scheduledStartTime(this.scheduledStartTime()).scheduledEndTime(this.scheduledEndTime()).description(this.description()).entityType(this.entityType().getValue()).image(InternalSpecUtils.mapPossible(this.image(), Image::getDataUri)).recurrenceRule(InternalSpecUtils.mapPossible(this.recurrenceRule(), RecurrenceRuleSpecGenerator::asRequest)).build();
    }
}

