/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.audit.ActionType;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.AuditLogQueryFluxGenerator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuditLogQueryFlux
extends AuditLogQueryFluxGenerator {
    @reactor.util.annotation.Nullable
    private final Snowflake userId;
    @reactor.util.annotation.Nullable
    private final ActionType actionType;
    @reactor.util.annotation.Nullable
    private final Snowflake before;
    @reactor.util.annotation.Nullable
    private final Integer limit;
    private final Guild guild;

    private AuditLogQueryFlux(Guild guild) {
        this.guild = Objects.requireNonNull(guild, "guild");
        this.userId = null;
        this.actionType = null;
        this.before = null;
        this.limit = null;
    }

    private AuditLogQueryFlux(@reactor.util.annotation.Nullable Snowflake userId, @reactor.util.annotation.Nullable ActionType actionType, @reactor.util.annotation.Nullable Snowflake before, @reactor.util.annotation.Nullable Integer limit, Guild guild) {
        this.userId = userId;
        this.actionType = actionType;
        this.before = before;
        this.limit = limit;
        this.guild = guild;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Snowflake userId() {
        return this.userId;
    }

    @Override
    @reactor.util.annotation.Nullable
    public ActionType actionType() {
        return this.actionType;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Snowflake before() {
        return this.before;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Integer limit() {
        return this.limit;
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final AuditLogQueryFlux withUserId(@reactor.util.annotation.Nullable Snowflake value) {
        if (this.userId == value) {
            return this;
        }
        return new AuditLogQueryFlux(value, this.actionType, this.before, this.limit, this.guild);
    }

    public final AuditLogQueryFlux withActionType(@reactor.util.annotation.Nullable ActionType value) {
        if (this.actionType == value) {
            return this;
        }
        return new AuditLogQueryFlux(this.userId, value, this.before, this.limit, this.guild);
    }

    public final AuditLogQueryFlux withBefore(@reactor.util.annotation.Nullable Snowflake value) {
        if (this.before == value) {
            return this;
        }
        return new AuditLogQueryFlux(this.userId, this.actionType, value, this.limit, this.guild);
    }

    public final AuditLogQueryFlux withLimit(@reactor.util.annotation.Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new AuditLogQueryFlux(this.userId, this.actionType, this.before, value, this.guild);
    }

    public final AuditLogQueryFlux withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new AuditLogQueryFlux(this.userId, this.actionType, this.before, this.limit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuditLogQueryFlux && this.equalTo(0, (AuditLogQueryFlux)another);
    }

    private boolean equalTo(int synthetic, AuditLogQueryFlux another) {
        return Objects.equals(this.userId, another.userId) && Objects.equals((Object)this.actionType, (Object)another.actionType) && Objects.equals(this.before, another.before) && Objects.equals(this.limit, another.limit) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode((Object)this.actionType);
        h += (h << 5) + Objects.hashCode(this.before);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "AuditLogQueryFlux{userId=" + this.userId + ", actionType=" + (Object)((Object)this.actionType) + ", before=" + this.before + ", limit=" + this.limit + ", guild=" + this.guild + "}";
    }

    public static AuditLogQueryFlux of(Guild guild) {
        return new AuditLogQueryFlux(guild);
    }

    static AuditLogQueryFlux copyOf(AuditLogQueryFluxGenerator instance) {
        if (instance instanceof AuditLogQueryFlux) {
            return (AuditLogQueryFlux)instance;
        }
        return AuditLogQueryFlux.of(instance.guild()).withUserId(instance.userId()).withActionType(instance.actionType()).withBefore(instance.before()).withLimit(instance.limit());
    }
}

