/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.reaction;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.reaction.ReactionCountDetails;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.json.ReactionData;
import discord4j.rest.util.Color;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Reaction
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ReactionData data;

    public Reaction(GatewayDiscordClient gateway, ReactionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public ReactionData getData() {
        return this.data;
    }

    public int getCount() {
        return this.data.count();
    }

    public ReactionCountDetails getCountDetails() {
        return new ReactionCountDetails(this.gateway, this.data.countDetails());
    }

    public boolean selfReacted() {
        return this.data.me();
    }

    public boolean selfSuperReacted() {
        return this.data.meBurst();
    }

    public List<Color> getSuperColors() {
        return this.data.burstColors().stream().map(Color::of).collect(Collectors.toList());
    }

    public ReactionEmoji getEmoji() {
        return ReactionEmoji.of(this.data);
    }

    public String toString() {
        return "Reaction{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        NORMAL(1),
        BURST(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return NORMAL;
                }
                case 2: {
                    return BURST;
                }
            }
            return UNKNOWN;
        }
    }
}

