/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.json.EmojiData;
import discord4j.rest.util.Image;
import java.util.Objects;
import reactor.core.publisher.Mono;

public abstract class Emoji
implements Entity {
    static final String EMOJI_IMAGE_PATH = "emojis/%s";
    final GatewayDiscordClient gateway;
    final EmojiData data;

    protected Emoji(GatewayDiscordClient gateway, EmojiData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public abstract Mono<User> getUser();

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return this.data.id().map(Snowflake::of).orElseThrow(IllegalStateException::new);
    }

    public EmojiData getData() {
        return this.data;
    }

    public String getName() {
        return (String)this.data.name().orElseThrow(IllegalStateException::new);
    }

    public boolean requiresColons() {
        return (Boolean)this.data.requireColons().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isManaged() {
        return (Boolean)this.data.managed().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isAnimated() {
        return (Boolean)this.data.animated().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isAvailable() {
        return (Boolean)this.data.available().toOptional().orElseThrow(IllegalStateException::new);
    }

    public String getImageUrl() {
        String path = String.format(EMOJI_IMAGE_PATH, this.getId().asString());
        return this.isAnimated() ? ImageUtil.getUrl(path, Image.Format.GIF) : ImageUtil.getUrl(path, Image.Format.PNG);
    }

    public Mono<Image> getImage() {
        return Image.ofUrl((String)this.getImageUrl());
    }

    public String asFormat() {
        return ReactionEmoji.Custom.custom(this).asFormat();
    }

    public String toString() {
        return "Emoji{data=" + this.data + '}';
    }
}

