/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationCommandPermissionsData;

public class ApplicationCommandPermission
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final long guildId;
    private final ApplicationCommandPermissionsData data;

    public ApplicationCommandPermission(GatewayDiscordClient gateway, Snowflake guildId, ApplicationCommandPermissionsData data) {
        this.gateway = gateway;
        this.guildId = guildId.asLong();
        this.data = data;
    }

    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public boolean appliesToEveryone() {
        return this.guildId == this.data.id().asLong();
    }

    public boolean appliesToAllChannels() {
        return this.guildId - 1L == this.data.id().asLong();
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public boolean isAllowed() {
        return this.data.permission();
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "ApplicationCommandPermission{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        ROLE(1),
        USER(2),
        CHANNEL(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return ROLE;
                }
                case 2: {
                    return USER;
                }
                case 3: {
                    return CHANNEL;
                }
            }
            return UNKNOWN;
        }
    }
}

