/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.json.RoleTagsData;
import java.util.Objects;
import java.util.Optional;

public class RoleTags
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final RoleTagsData data;

    public RoleTags(GatewayDiscordClient gateway, RoleTagsData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public RoleTagsData getData() {
        return this.data;
    }

    public Optional<Snowflake> getBotId() {
        return this.data.botId().toOptional().map(Snowflake::of);
    }

    public Optional<Snowflake> getIntegrationId() {
        return this.data.integrationId().toOptional().map(Snowflake::of);
    }

    public boolean isPremiumSubscriberRole() {
        return !this.data.premiumSubscriber().isAbsent();
    }

    public boolean isGuildLinkedRole() {
        return !this.data.guildConnections().isAbsent();
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "RoleTags{data=" + this.data + '}';
    }
}

