/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ResolvedChannelData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableResolvedChannelData
implements ResolvedChannelData {
    private final String id;
    private final String name_value;
    private final boolean name_absent;
    private final int type;
    private final String permissions_value;
    private final boolean permissions_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableResolvedChannelData(String id, Possible<Optional<String>> name, int type, Possible<Optional<String>> permissions) {
        this.id = Objects.requireNonNull(id, "id");
        Possible<Optional<String>> name$impl = name;
        this.type = type;
        Possible<Optional<String>> permissions$impl = permissions;
        this.name_value = Possible.flatOpt(name$impl).orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = Possible.flatOpt(permissions$impl).orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableResolvedChannelData(ImmutableResolvedChannelData original, String id, Possible<Optional<String>> name, int type, Possible<Optional<String>> permissions) {
        this.id = id;
        Possible<Optional<String>> name$impl = name;
        this.type = type;
        Possible<Optional<String>> permissions$impl = permissions;
        this.name_value = Possible.flatOpt(name$impl).orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = Possible.flatOpt(permissions$impl).orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Possible<Optional<String>> name() {
        return this.name_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.name_value));
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="permissions")
    public Possible<Optional<String>> permissions() {
        return this.permissions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.permissions_value));
    }

    public final ImmutableResolvedChannelData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableResolvedChannelData(this, newValue, this.name(), this.type, this.permissions());
    }

    public ImmutableResolvedChannelData withName(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableResolvedChannelData(this, this.id, newValue, this.type, this.permissions());
    }

    @Deprecated
    public ImmutableResolvedChannelData withName(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableResolvedChannelData(this, this.id, (Possible<Optional<String>>)newValue, this.type, this.permissions());
    }

    public ImmutableResolvedChannelData withNameOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableResolvedChannelData(this, this.id, (Possible<Optional<String>>)newValue, this.type, this.permissions());
    }

    public final ImmutableResolvedChannelData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableResolvedChannelData(this, this.id, this.name(), value, this.permissions());
    }

    public ImmutableResolvedChannelData withPermissions(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableResolvedChannelData(this, this.id, this.name(), this.type, newValue);
    }

    @Deprecated
    public ImmutableResolvedChannelData withPermissions(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableResolvedChannelData(this, this.id, this.name(), this.type, (Possible<Optional<String>>)newValue);
    }

    public ImmutableResolvedChannelData withPermissionsOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableResolvedChannelData(this, this.id, this.name(), this.type, (Possible<Optional<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResolvedChannelData && this.equalTo(0, (ImmutableResolvedChannelData)another);
    }

    private boolean equalTo(int synthetic, ImmutableResolvedChannelData another) {
        return this.id.equals(another.id) && this.name().equals(another.name()) && this.type == another.type && this.permissions().equals(another.permissions());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.type;
        h += (h << 5) + this.permissions().hashCode();
        return h;
    }

    public String toString() {
        return "ResolvedChannelData{id=" + this.id + ", name=" + this.name().toString() + ", type=" + this.type + ", permissions=" + this.permissions().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableResolvedChannelData fromJson(Json json) {
        Builder builder = ImmutableResolvedChannelData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.permissions != null) {
            builder.permissions(json.permissions);
        }
        return builder.build();
    }

    public static ImmutableResolvedChannelData of(String id, Possible<Optional<String>> name, int type, Possible<Optional<String>> permissions) {
        return new ImmutableResolvedChannelData(id, name, type, permissions);
    }

    public static ImmutableResolvedChannelData copyOf(ResolvedChannelData instance) {
        if (instance instanceof ImmutableResolvedChannelData) {
            return (ImmutableResolvedChannelData)instance;
        }
        return ImmutableResolvedChannelData.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPermissionsPresent() {
        return !this.permissions_absent;
    }

    public String permissionsOrElse(String defaultValue) {
        return !this.permissions_absent ? this.permissions_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private Possible<Optional<String>> name_possible = Possible.absent();
        private Possible<Optional<String>> permissions_possible = Possible.absent();
        @Nullable
        private String id;
        private int type;

        private Builder() {
        }

        public final Builder from(ResolvedChannelData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.type(instance.type());
            this.permissions(instance.permissions());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public Builder name(Possible<Optional<String>> value) {
            this.name_possible = value;
            return this;
        }

        @Deprecated
        public Builder name(@Nullable String value) {
            this.name_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder nameOrNull(@Nullable String value) {
            this.name_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="permissions")
        public Builder permissions(Possible<Optional<String>> value) {
            this.permissions_possible = value;
            return this;
        }

        @Deprecated
        public Builder permissions(@Nullable String value) {
            this.permissions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder permissionsOrNull(@Nullable String value) {
            this.permissions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableResolvedChannelData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResolvedChannelData(null, this.id, this.name_build(), this.type, this.permissions_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ResolvedChannelData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> name_build() {
            return this.name_possible;
        }

        private Possible<Optional<String>> permissions_build() {
            return this.permissions_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ResolvedChannelData {
        @Nullable
        String id;
        Possible<Optional<String>> name = Possible.absent();
        int type;
        boolean typeIsSet;
        Possible<Optional<String>> permissions = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(Possible<Optional<String>> name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(Possible<Optional<String>> permissions) {
            this.permissions = permissions;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> permissions() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ResolvedChannelData, attribute initializers form cycle " + attributes;
        }
    }
}

