/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AvatarDecorationData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutablePartialMemberData
implements PartialMemberData {
    private final String nick_value;
    private final boolean nick_absent;
    @Nullable
    private final String avatar;
    private final String banner_value;
    private final boolean banner_absent;
    private final long[] roles_value;
    @Nullable
    private final String joinedAt;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    @Nullable
    private final String hoistedRole;
    private final boolean deaf;
    private final boolean mute;
    private final String communicationDisabledUntil_value;
    private final boolean communicationDisabledUntil_absent;
    private final AvatarDecorationData avatarDecoration_value;
    private final boolean avatarDecoration_absent;
    private final long flags;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePartialMemberData(Possible<Optional<String>> nick, Optional<String> avatar, Possible<Optional<String>> banner, List<Id> roles, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration, long flags) {
        Possible<Optional<String>> nick$impl = nick;
        this.avatar = avatar.orElse(null);
        Possible<Optional<String>> banner$impl = banner;
        List<Id> roles$impl = roles;
        this.joinedAt = joinedAt.orElse(null);
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole.orElse(null);
        this.deaf = deaf;
        this.mute = mute;
        Possible<Optional<String>> communicationDisabledUntil$impl = communicationDisabledUntil;
        Possible<Optional<AvatarDecorationData>> avatarDecoration$impl = avatarDecoration;
        this.initShim.flags(flags);
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt(avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePartialMemberData(Builder builder) {
        Possible nick$impl = builder.nick_build();
        this.avatar = builder.avatar;
        Possible banner$impl = builder.banner_build();
        List roles$impl = builder.roles_build();
        this.joinedAt = builder.joinedAt;
        Possible premiumSince$impl = builder.premiumSince_build();
        this.hoistedRole = builder.hoistedRole;
        this.deaf = builder.deaf;
        this.mute = builder.mute;
        Possible communicationDisabledUntil$impl = builder.communicationDisabledUntil_build();
        Possible avatarDecoration$impl = builder.avatarDecoration_build();
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.nick_value = Possible.flatOpt((Possible)nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.banner_value = Possible.flatOpt((Possible)banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt((Possible)premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt((Possible)communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt((Possible)avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePartialMemberData(ImmutablePartialMemberData original, Possible<Optional<String>> nick, @Nullable String avatar, Possible<Optional<String>> banner, List<Id> roles, @Nullable String joinedAt, Possible<Optional<String>> premiumSince, @Nullable String hoistedRole, boolean deaf, boolean mute, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration, long flags) {
        Possible<Optional<String>> nick$impl = nick;
        this.avatar = avatar;
        Possible<Optional<String>> banner$impl = banner;
        List<Id> roles$impl = roles;
        this.joinedAt = joinedAt;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole;
        this.deaf = deaf;
        this.mute = mute;
        Possible<Optional<String>> communicationDisabledUntil$impl = communicationDisabledUntil;
        Possible<Optional<AvatarDecorationData>> avatarDecoration$impl = avatarDecoration;
        this.initShim.flags(flags);
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt(avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private long flagsInitialize() {
        return PartialMemberData.super.flags();
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    @Override
    @JsonProperty(value="avatar")
    public Optional<String> avatar() {
        return Optional.ofNullable(this.avatar);
    }

    @Override
    @JsonProperty(value="banner")
    public Possible<Optional<String>> banner() {
        return this.banner_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.banner_value));
    }

    @Override
    @JsonProperty(value="roles")
    public List<Id> roles() {
        return LongStream.of(this.roles_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="joined_at")
    public Optional<String> joinedAt() {
        return Optional.ofNullable(this.joinedAt);
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    @Override
    @JsonProperty(value="hoisted_role")
    public Optional<String> hoistedRole() {
        return Optional.ofNullable(this.hoistedRole);
    }

    @Override
    @JsonProperty(value="deaf")
    public boolean deaf() {
        return this.deaf;
    }

    @Override
    @JsonProperty(value="mute")
    public boolean mute() {
        return this.mute;
    }

    @Override
    @JsonProperty(value="communication_disabled_until")
    public Possible<Optional<String>> communicationDisabledUntil() {
        return this.communicationDisabledUntil_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.communicationDisabledUntil_value));
    }

    @Override
    @JsonProperty(value="avatar_decoration_data")
    public Possible<Optional<AvatarDecorationData>> avatarDecoration() {
        return this.avatarDecoration_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.avatarDecoration_value));
    }

    @Override
    @JsonProperty(value="flags")
    public long flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    public ImmutablePartialMemberData withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, newValue, this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    @Deprecated
    public ImmutablePartialMemberData withNick(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, (Possible<Optional<String>>)newValue, this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withNickOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, (Possible<Optional<String>>)newValue, this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withAvatar(String value) {
        String newValue = Objects.requireNonNull(value, "avatar");
        if (Objects.equals(this.avatar, newValue)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), newValue, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withAvatar(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avatar, value)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), value, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withBanner(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    @Deprecated
    public ImmutablePartialMemberData withBanner(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, (Possible<Optional<String>>)newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withBannerOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, (Possible<Optional<String>>)newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withRoles(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), newValue, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withJoinedAt(String value) {
        String newValue = Objects.requireNonNull(value, "joinedAt");
        if (Objects.equals(this.joinedAt, newValue)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), newValue, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withJoinedAt(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.joinedAt, value)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), value, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, newValue, this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    @Deprecated
    public ImmutablePartialMemberData withPremiumSince(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, (Possible<Optional<String>>)newValue, this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withPremiumSinceOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, (Possible<Optional<String>>)newValue, this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withHoistedRole(String value) {
        String newValue = Objects.requireNonNull(value, "hoistedRole");
        if (Objects.equals(this.hoistedRole, newValue)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), newValue, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withHoistedRole(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hoistedRole, value)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), value, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withDeaf(boolean value) {
        if (this.deaf == value) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, value, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public final ImmutablePartialMemberData withMute(boolean value) {
        if (this.mute == value) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, value, this.communicationDisabledUntil(), this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withCommunicationDisabledUntil(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, newValue, this.avatarDecoration(), this.flags);
    }

    @Deprecated
    public ImmutablePartialMemberData withCommunicationDisabledUntil(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, (Possible<Optional<String>>)newValue, this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withCommunicationDisabledUntilOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, (Possible<Optional<String>>)newValue, this.avatarDecoration(), this.flags);
    }

    public ImmutablePartialMemberData withAvatarDecoration(Possible<Optional<AvatarDecorationData>> value) {
        Possible<Optional<AvatarDecorationData>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), newValue, this.flags);
    }

    @Deprecated
    public ImmutablePartialMemberData withAvatarDecoration(@Nullable AvatarDecorationData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), (Possible<Optional<AvatarDecorationData>>)newValue, this.flags);
    }

    public ImmutablePartialMemberData withAvatarDecorationOrNull(@Nullable AvatarDecorationData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), (Possible<Optional<AvatarDecorationData>>)newValue, this.flags);
    }

    public final ImmutablePartialMemberData withFlags(long value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.avatar, this.banner(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.communicationDisabledUntil(), this.avatarDecoration(), value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePartialMemberData && this.equalTo(0, (ImmutablePartialMemberData)another);
    }

    private boolean equalTo(int synthetic, ImmutablePartialMemberData another) {
        return this.nick().equals(another.nick()) && Objects.equals(this.avatar, another.avatar) && this.banner().equals(another.banner()) && Objects.equals(this.roles_value, another.roles_value) && Objects.equals(this.joinedAt, another.joinedAt) && this.premiumSince().equals(another.premiumSince()) && Objects.equals(this.hoistedRole, another.hoistedRole) && this.deaf == another.deaf && this.mute == another.mute && this.communicationDisabledUntil().equals(another.communicationDisabledUntil()) && this.avatarDecoration().equals(another.avatarDecoration()) && this.flags == another.flags;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nick().hashCode();
        h += (h << 5) + Objects.hashCode(this.avatar);
        h += (h << 5) + this.banner().hashCode();
        h += (h << 5) + Objects.hashCode(this.roles_value);
        h += (h << 5) + Objects.hashCode(this.joinedAt);
        h += (h << 5) + this.premiumSince().hashCode();
        h += (h << 5) + Objects.hashCode(this.hoistedRole);
        h += (h << 5) + Boolean.hashCode(this.deaf);
        h += (h << 5) + Boolean.hashCode(this.mute);
        h += (h << 5) + this.communicationDisabledUntil().hashCode();
        h += (h << 5) + this.avatarDecoration().hashCode();
        h += (h << 5) + Long.hashCode(this.flags);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartialMemberData{");
        builder.append("nick=").append(this.nick().toString());
        if (this.avatar != null) {
            builder.append(", ");
            builder.append("avatar=").append(this.avatar);
        }
        builder.append(", ");
        builder.append("banner=").append(this.banner().toString());
        builder.append(", ");
        builder.append("roles=").append(Objects.toString(this.roles_value));
        if (this.joinedAt != null) {
            builder.append(", ");
            builder.append("joinedAt=").append(this.joinedAt);
        }
        builder.append(", ");
        builder.append("premiumSince=").append(this.premiumSince().toString());
        if (this.hoistedRole != null) {
            builder.append(", ");
            builder.append("hoistedRole=").append(this.hoistedRole);
        }
        builder.append(", ");
        builder.append("deaf=").append(this.deaf);
        builder.append(", ");
        builder.append("mute=").append(this.mute);
        builder.append(", ");
        builder.append("communicationDisabledUntil=").append(this.communicationDisabledUntil().toString());
        builder.append(", ");
        builder.append("avatarDecoration=").append(this.avatarDecoration().toString());
        builder.append(", ");
        builder.append("flags=").append(this.flags);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePartialMemberData fromJson(Json json) {
        Builder builder = ImmutablePartialMemberData.builder();
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        if (json.banner != null) {
            builder.banner(json.banner);
        }
        if (json.roles != null) {
            builder.roles(json.roles);
        }
        if (json.joinedAt != null) {
            builder.joinedAt(json.joinedAt);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        if (json.hoistedRole != null) {
            builder.hoistedRole(json.hoistedRole);
        }
        if (json.deafIsSet) {
            builder.deaf(json.deaf);
        }
        if (json.muteIsSet) {
            builder.mute(json.mute);
        }
        if (json.communicationDisabledUntil != null) {
            builder.communicationDisabledUntil(json.communicationDisabledUntil);
        }
        if (json.avatarDecoration != null) {
            builder.avatarDecoration(json.avatarDecoration);
        }
        if (json.flagsIsSet) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutablePartialMemberData of(Possible<Optional<String>> nick, Optional<String> avatar, Possible<Optional<String>> banner, List<Id> roles, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute, Possible<Optional<String>> communicationDisabledUntil, Possible<Optional<AvatarDecorationData>> avatarDecoration, long flags) {
        return new ImmutablePartialMemberData(nick, avatar, banner, roles, joinedAt, premiumSince, hoistedRole, deaf, mute, communicationDisabledUntil, avatarDecoration, flags);
    }

    public static ImmutablePartialMemberData copyOf(PartialMemberData instance) {
        if (instance instanceof ImmutablePartialMemberData) {
            return (ImmutablePartialMemberData)instance;
        }
        return ImmutablePartialMemberData.builder().from(instance).build();
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public boolean isBannerPresent() {
        return !this.banner_absent;
    }

    public String bannerOrElse(String defaultValue) {
        return !this.banner_absent ? this.banner_value : defaultValue;
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public boolean isCommunicationDisabledUntilPresent() {
        return !this.communicationDisabledUntil_absent;
    }

    public String communicationDisabledUntilOrElse(String defaultValue) {
        return !this.communicationDisabledUntil_absent ? this.communicationDisabledUntil_value : defaultValue;
    }

    public boolean isAvatarDecorationPresent() {
        return !this.avatarDecoration_absent;
    }

    public AvatarDecorationData avatarDecorationOrElse(AvatarDecorationData defaultValue) {
        return !this.avatarDecoration_absent ? this.avatarDecoration_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DEAF = 1L;
        private static final long INIT_BIT_MUTE = 2L;
        private static final long OPT_BIT_FLAGS = 1L;
        private long initBits = 3L;
        private long optBits;
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private Possible<Optional<String>> banner_possible = Possible.absent();
        private List<Long> roles_list = null;
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private Possible<Optional<String>> communicationDisabledUntil_possible = Possible.absent();
        private Possible<Optional<AvatarDecorationData>> avatarDecoration_possible = Possible.absent();
        @Nullable
        private String avatar;
        @Nullable
        private String joinedAt;
        @Nullable
        private String hoistedRole;
        private boolean deaf;
        private boolean mute;
        private long flags;

        private Builder() {
        }

        public final Builder from(PartialMemberData instance) {
            Objects.requireNonNull(instance, "instance");
            this.nick(instance.nick());
            Optional<String> avatarOptional = instance.avatar();
            if (avatarOptional.isPresent()) {
                this.avatar(avatarOptional);
            }
            this.banner(instance.banner());
            this.roles(instance.roles());
            Optional<String> joinedAtOptional = instance.joinedAt();
            if (joinedAtOptional.isPresent()) {
                this.joinedAt(joinedAtOptional);
            }
            this.premiumSince(instance.premiumSince());
            Optional<String> hoistedRoleOptional = instance.hoistedRole();
            if (hoistedRoleOptional.isPresent()) {
                this.hoistedRole(hoistedRoleOptional);
            }
            this.deaf(instance.deaf());
            this.mute(instance.mute());
            this.communicationDisabledUntil(instance.communicationDisabledUntil());
            this.avatarDecoration(instance.avatarDecoration());
            this.flags(instance.flags());
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        @Deprecated
        public Builder nick(@Nullable String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder nickOrNull(@Nullable String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder avatar(String avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @JsonProperty(value="avatar")
        public final Builder avatar(Optional<String> avatar) {
            this.avatar = avatar.orElse(null);
            return this;
        }

        @JsonProperty(value="banner")
        public Builder banner(Possible<Optional<String>> value) {
            this.banner_possible = value;
            return this;
        }

        @Deprecated
        public Builder banner(@Nullable String value) {
            this.banner_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder bannerOrNull(@Nullable String value) {
            this.banner_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addRole(long element) {
            this.roles_getOrCreate().add(element);
            return this;
        }

        public Builder addRole(String element) {
            this.roles_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addRole(Id element) {
            this.roles_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRoles(List<Long> elements) {
            this.roles_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="roles")
        public Builder roles(List<Id> elements) {
            this.roles_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder roles(Iterable<Id> elements) {
            this.roles_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public final Builder joinedAt(String joinedAt) {
            this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
            return this;
        }

        @JsonProperty(value="joined_at")
        public final Builder joinedAt(Optional<String> joinedAt) {
            this.joinedAt = joinedAt.orElse(null);
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        @Deprecated
        public Builder premiumSince(@Nullable String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder premiumSinceOrNull(@Nullable String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder hoistedRole(String hoistedRole) {
            this.hoistedRole = Objects.requireNonNull(hoistedRole, "hoistedRole");
            return this;
        }

        @JsonProperty(value="hoisted_role")
        public final Builder hoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole.orElse(null);
            return this;
        }

        @JsonProperty(value="deaf")
        public final Builder deaf(boolean deaf) {
            this.deaf = deaf;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mute")
        public final Builder mute(boolean mute) {
            this.mute = mute;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="communication_disabled_until")
        public Builder communicationDisabledUntil(Possible<Optional<String>> value) {
            this.communicationDisabledUntil_possible = value;
            return this;
        }

        @Deprecated
        public Builder communicationDisabledUntil(@Nullable String value) {
            this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder communicationDisabledUntilOrNull(@Nullable String value) {
            this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="avatar_decoration_data")
        public Builder avatarDecoration(Possible<Optional<AvatarDecorationData>> value) {
            this.avatarDecoration_possible = value;
            return this;
        }

        @Deprecated
        public Builder avatarDecoration(@Nullable AvatarDecorationData value) {
            this.avatarDecoration_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder avatarDecorationOrNull(@Nullable AvatarDecorationData value) {
            this.avatarDecoration_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="flags")
        public final Builder flags(long flags) {
            this.flags = flags;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePartialMemberData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePartialMemberData(this);
        }

        private boolean flagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deaf");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mute");
            }
            return "Cannot build PartialMemberData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }

        private Possible<Optional<String>> banner_build() {
            return this.banner_possible;
        }

        private List<Id> roles_build() {
            return this.roles_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> roles_getOrCreate() {
            if (this.roles_list == null) {
                this.roles_list = new ArrayList<Long>();
            }
            return this.roles_list;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }

        private Possible<Optional<String>> communicationDisabledUntil_build() {
            return this.communicationDisabledUntil_possible;
        }

        private Possible<Optional<AvatarDecorationData>> avatarDecoration_build() {
            return this.avatarDecoration_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PartialMemberData {
        Possible<Optional<String>> nick = Possible.absent();
        @Nullable
        Optional<String> avatar = Optional.empty();
        Possible<Optional<String>> banner = Possible.absent();
        @Nullable
        List<Id> roles;
        @Nullable
        Optional<String> joinedAt = Optional.empty();
        Possible<Optional<String>> premiumSince = Possible.absent();
        @Nullable
        Optional<String> hoistedRole = Optional.empty();
        boolean deaf;
        boolean deafIsSet;
        boolean mute;
        boolean muteIsSet;
        Possible<Optional<String>> communicationDisabledUntil = Possible.absent();
        Possible<Optional<AvatarDecorationData>> avatarDecoration = Possible.absent();
        long flags;
        boolean flagsIsSet;

        Json() {
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Optional<String> avatar) {
            this.avatar = avatar;
        }

        @JsonProperty(value="banner")
        public void setBanner(Possible<Optional<String>> banner) {
            this.banner = banner;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<Id> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="joined_at")
        public void setJoinedAt(Optional<String> joinedAt) {
            this.joinedAt = joinedAt;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @JsonProperty(value="hoisted_role")
        public void setHoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole;
        }

        @JsonProperty(value="deaf")
        public void setDeaf(boolean deaf) {
            this.deaf = deaf;
            this.deafIsSet = true;
        }

        @JsonProperty(value="mute")
        public void setMute(boolean mute) {
            this.mute = mute;
            this.muteIsSet = true;
        }

        @JsonProperty(value="communication_disabled_until")
        public void setCommunicationDisabledUntil(Possible<Optional<String>> communicationDisabledUntil) {
            this.communicationDisabledUntil = communicationDisabledUntil;
        }

        @JsonProperty(value="avatar_decoration_data")
        public void setAvatarDecoration(Possible<Optional<AvatarDecorationData>> avatarDecoration) {
            this.avatarDecoration = avatarDecoration;
        }

        @JsonProperty(value="flags")
        public void setFlags(long flags) {
            this.flags = flags;
            this.flagsIsSet = true;
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> avatar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> banner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> joinedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> hoistedRole() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deaf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> communicationDisabledUntil() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<AvatarDecorationData>> avatarDecoration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long flags() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private byte flagsBuildStage = 0;
        private long flags;

        private InitShim() {
        }

        long flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePartialMemberData.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(long flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PartialMemberData, attribute initializers form cycle " + attributes;
        }
    }
}

