/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingPromptOptionData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.OnboardingPromptOptionData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableOnboardingPromptOptionData
implements OnboardingPromptOptionData {
    private final long[] channelsIds_value;
    private final long[] rolesIds_value;
    private final String title;
    @Nullable
    private final String description;
    private final long id_value;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingPromptOptionData(List<Id> channelsIds, List<Id> rolesIds, String title, Optional<String> description, Id id, Possible<EmojiData> emoji) {
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.title = Objects.requireNonNull(title, "title");
        this.description = description.orElse(null);
        Id id$impl = id;
        Possible<EmojiData> emoji$impl = emoji;
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.id_value = id$impl.asLong();
        this.emoji_value = emoji$impl.toOptional().orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableOnboardingPromptOptionData(ImmutableOnboardingPromptOptionData original, List<Id> channelsIds, List<Id> rolesIds, String title, @Nullable String description, Id id, Possible<EmojiData> emoji) {
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.title = title;
        this.description = description;
        Id id$impl = id;
        Possible<EmojiData> emoji$impl = emoji;
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.id_value = id$impl.asLong();
        this.emoji_value = emoji$impl.toOptional().orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_ids")
    public List<Id> channelsIds() {
        return LongStream.of(this.channelsIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="role_ids")
    public List<Id> rolesIds() {
        return LongStream.of(this.rolesIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="emoji")
    public Possible<EmojiData> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of((Object)this.emoji_value);
    }

    public ImmutableOnboardingPromptOptionData withChannelsIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingPromptOptionData(this, newValue, this.rolesIds(), this.title, this.description, this.id(), this.emoji());
    }

    public ImmutableOnboardingPromptOptionData withRolesIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), newValue, this.title, this.description, this.id(), this.emoji());
    }

    public final ImmutableOnboardingPromptOptionData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), newValue, this.description, this.id(), this.emoji());
    }

    public final ImmutableOnboardingPromptOptionData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, newValue, this.id(), this.emoji());
    }

    public final ImmutableOnboardingPromptOptionData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, value, this.id(), this.emoji());
    }

    public ImmutableOnboardingPromptOptionData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, newValue, this.emoji());
    }

    public ImmutableOnboardingPromptOptionData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, newValue, this.emoji());
    }

    public ImmutableOnboardingPromptOptionData withEmoji(Possible<EmojiData> value) {
        Possible<EmojiData> newValue = Objects.requireNonNull(value);
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, this.id(), newValue);
    }

    public ImmutableOnboardingPromptOptionData withEmoji(EmojiData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, this.id(), (Possible<EmojiData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingPromptOptionData && this.equalTo(0, (ImmutableOnboardingPromptOptionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingPromptOptionData another) {
        return Objects.equals(this.channelsIds_value, another.channelsIds_value) && Objects.equals(this.rolesIds_value, another.rolesIds_value) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.id_value, another.id_value) && this.emoji().equals(another.emoji());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.channelsIds_value);
        h += (h << 5) + Objects.hashCode(this.rolesIds_value);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.emoji().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OnboardingPromptOptionData{");
        builder.append("channelsIds=").append(Objects.toString(this.channelsIds_value));
        builder.append(", ");
        builder.append("rolesIds=").append(Objects.toString(this.rolesIds_value));
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("emoji=").append(this.emoji().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingPromptOptionData fromJson(Json json) {
        Builder builder = ImmutableOnboardingPromptOptionData.builder();
        if (json.channelsIds != null) {
            builder.channelsIds(json.channelsIds);
        }
        if (json.rolesIds != null) {
            builder.rolesIds(json.rolesIds);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        return builder.build();
    }

    public static ImmutableOnboardingPromptOptionData of(List<Id> channelsIds, List<Id> rolesIds, String title, Optional<String> description, Id id, Possible<EmojiData> emoji) {
        return new ImmutableOnboardingPromptOptionData(channelsIds, rolesIds, title, description, id, emoji);
    }

    public static ImmutableOnboardingPromptOptionData copyOf(OnboardingPromptOptionData instance) {
        if (instance instanceof ImmutableOnboardingPromptOptionData) {
            return (ImmutableOnboardingPromptOptionData)instance;
        }
        return ImmutableOnboardingPromptOptionData.builder().from(instance).build();
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        private List<Long> channelsIds_list = null;
        private List<Long> rolesIds_list = null;
        private Id id_id = null;
        private Possible<EmojiData> emoji_possible = Possible.absent();
        @Nullable
        private String title;
        @Nullable
        private String description;

        private Builder() {
        }

        public final Builder from(OnboardingPromptOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseOnboardingPromptOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> descriptionOptional;
            BaseOnboardingPromptOptionData instance;
            long bits = 0L;
            if (object instanceof OnboardingPromptOptionData) {
                instance = (OnboardingPromptOptionData)object;
                if ((bits & 1L) == 0L) {
                    descriptionOptional = instance.description();
                    if (descriptionOptional.isPresent()) {
                        this.description(descriptionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.rolesIds(instance.rolesIds());
                    bits |= 8L;
                }
                this.id(instance.id());
                this.emoji(instance.emoji());
                if ((bits & 2L) == 0L) {
                    this.channelsIds(instance.channelsIds());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.title(instance.title());
                    bits |= 4L;
                }
            }
            if (object instanceof BaseOnboardingPromptOptionData) {
                instance = (BaseOnboardingPromptOptionData)object;
                if ((bits & 1L) == 0L) {
                    descriptionOptional = instance.description();
                    if (descriptionOptional.isPresent()) {
                        this.description(descriptionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.rolesIds(instance.rolesIds());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.channelsIds(instance.channelsIds());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.title(instance.title());
                    bits |= 4L;
                }
            }
        }

        public Builder addChannelsId(long element) {
            this.channelsIds_getOrCreate().add(element);
            return this;
        }

        public Builder addChannelsId(String element) {
            this.channelsIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addChannelsId(Id element) {
            this.channelsIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllChannelsIds(List<Long> elements) {
            this.channelsIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="channel_ids")
        public Builder channelsIds(List<Id> elements) {
            this.channelsIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder channelsIds(Iterable<Id> elements) {
            this.channelsIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addRolesId(long element) {
            this.rolesIds_getOrCreate().add(element);
            return this;
        }

        public Builder addRolesId(String element) {
            this.rolesIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addRolesId(Id element) {
            this.rolesIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRolesIds(List<Long> elements) {
            this.rolesIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="role_ids")
        public Builder rolesIds(List<Id> elements) {
            this.rolesIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder rolesIds(Iterable<Id> elements) {
            this.rolesIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="emoji")
        public Builder emoji(Possible<EmojiData> value) {
            this.emoji_possible = value;
            return this;
        }

        public Builder emoji(EmojiData value) {
            this.emoji_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableOnboardingPromptOptionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingPromptOptionData(null, this.channelsIds_build(), this.rolesIds_build(), this.title, this.description, this.id_build(), this.emoji_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build OnboardingPromptOptionData, some of required attributes are not set " + attributes;
        }

        private List<Id> channelsIds_build() {
            return this.channelsIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> channelsIds_getOrCreate() {
            if (this.channelsIds_list == null) {
                this.channelsIds_list = new ArrayList<Long>();
            }
            return this.channelsIds_list;
        }

        private List<Id> rolesIds_build() {
            return this.rolesIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> rolesIds_getOrCreate() {
            if (this.rolesIds_list == null) {
                this.rolesIds_list = new ArrayList<Long>();
            }
            return this.rolesIds_list;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<EmojiData> emoji_build() {
            return this.emoji_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OnboardingPromptOptionData {
        @Nullable
        List<Id> channelsIds;
        @Nullable
        List<Id> rolesIds;
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Id id;
        Possible<EmojiData> emoji = Possible.absent();

        Json() {
        }

        @JsonProperty(value="channel_ids")
        public void setChannelsIds(List<Id> channelsIds) {
            this.channelsIds = channelsIds;
        }

        @JsonProperty(value="role_ids")
        public void setRolesIds(List<Id> rolesIds) {
            this.rolesIds = rolesIds;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(Possible<EmojiData> emoji) {
            this.emoji = emoji;
        }

        @Override
        public List<Id> channelsIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> rolesIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<EmojiData> emoji() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingPromptOptionData, attribute initializers form cycle " + attributes;
        }
    }
}

