/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingData;
import discord4j.discordjson.json.OnboardingEditData;
import discord4j.discordjson.json.OnboardingEditPromptData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableOnboardingEditData
implements OnboardingEditData {
    private final long[] defaultChannelIds_value;
    private final boolean enabled;
    private final int mode;
    private final List<OnboardingEditPromptData> prompts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingEditData(List<Id> defaultChannelIds, boolean enabled, int mode, Iterable<? extends OnboardingEditPromptData> prompts) {
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.mode = mode;
        this.prompts = ImmutableOnboardingEditData.createUnmodifiableList(false, ImmutableOnboardingEditData.createSafeList(prompts, true, false));
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableOnboardingEditData(ImmutableOnboardingEditData original, List<Id> defaultChannelIds, boolean enabled, int mode, List<OnboardingEditPromptData> prompts) {
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.mode = mode;
        this.prompts = prompts;
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="default_channel_ids")
    public List<Id> defaultChannelIds() {
        return LongStream.of(this.defaultChannelIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="mode")
    public int mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="prompts")
    public List<OnboardingEditPromptData> prompts() {
        return this.prompts;
    }

    public ImmutableOnboardingEditData withDefaultChannelIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingEditData(this, newValue, this.enabled, this.mode, this.prompts);
    }

    public final ImmutableOnboardingEditData withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableOnboardingEditData(this, this.defaultChannelIds(), value, this.mode, this.prompts);
    }

    public final ImmutableOnboardingEditData withMode(int value) {
        if (this.mode == value) {
            return this;
        }
        return new ImmutableOnboardingEditData(this, this.defaultChannelIds(), this.enabled, value, this.prompts);
    }

    public final ImmutableOnboardingEditData withPrompts(OnboardingEditPromptData ... elements) {
        List<OnboardingEditPromptData> newValue = ImmutableOnboardingEditData.createUnmodifiableList(false, ImmutableOnboardingEditData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOnboardingEditData(this, this.defaultChannelIds(), this.enabled, this.mode, newValue);
    }

    public final ImmutableOnboardingEditData withPrompts(Iterable<? extends OnboardingEditPromptData> elements) {
        if (this.prompts == elements) {
            return this;
        }
        List<OnboardingEditPromptData> newValue = ImmutableOnboardingEditData.createUnmodifiableList(false, ImmutableOnboardingEditData.createSafeList(elements, true, false));
        return new ImmutableOnboardingEditData(this, this.defaultChannelIds(), this.enabled, this.mode, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingEditData && this.equalTo(0, (ImmutableOnboardingEditData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingEditData another) {
        return Objects.equals(this.defaultChannelIds_value, another.defaultChannelIds_value) && this.enabled == another.enabled && this.mode == another.mode && this.prompts.equals(another.prompts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultChannelIds_value);
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + this.mode;
        h += (h << 5) + this.prompts.hashCode();
        return h;
    }

    public String toString() {
        return "OnboardingEditData{defaultChannelIds=" + Objects.toString(this.defaultChannelIds_value) + ", enabled=" + this.enabled + ", mode=" + this.mode + ", prompts=" + this.prompts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingEditData fromJson(Json json) {
        Builder builder = ImmutableOnboardingEditData.builder();
        if (json.defaultChannelIds != null) {
            builder.defaultChannelIds(json.defaultChannelIds);
        }
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.modeIsSet) {
            builder.mode(json.mode);
        }
        if (json.prompts != null) {
            builder.addAllPrompts(json.prompts);
        }
        return builder.build();
    }

    public static ImmutableOnboardingEditData of(List<Id> defaultChannelIds, boolean enabled, int mode, List<OnboardingEditPromptData> prompts) {
        return ImmutableOnboardingEditData.of(defaultChannelIds, enabled, mode, prompts);
    }

    public static ImmutableOnboardingEditData of(List<Id> defaultChannelIds, boolean enabled, int mode, Iterable<? extends OnboardingEditPromptData> prompts) {
        return new ImmutableOnboardingEditData(defaultChannelIds, enabled, mode, prompts);
    }

    public static ImmutableOnboardingEditData copyOf(OnboardingEditData instance) {
        if (instance instanceof ImmutableOnboardingEditData) {
            return (ImmutableOnboardingEditData)instance;
        }
        return ImmutableOnboardingEditData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long INIT_BIT_MODE = 2L;
        private long initBits = 3L;
        private List<Long> defaultChannelIds_list = null;
        private boolean enabled;
        private int mode;
        private List<OnboardingEditPromptData> prompts = new ArrayList<OnboardingEditPromptData>();

        private Builder() {
        }

        public final Builder from(OnboardingEditData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseOnboardingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseOnboardingData instance;
            long bits = 0L;
            if (object instanceof OnboardingEditData) {
                instance = (OnboardingEditData)object;
                if ((bits & 2L) == 0L) {
                    this.mode(instance.mode());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.defaultChannelIds(instance.defaultChannelIds());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.enabled(instance.enabled());
                    bits |= 1L;
                }
                this.addAllPrompts(instance.prompts());
            }
            if (object instanceof BaseOnboardingData) {
                instance = (BaseOnboardingData)object;
                if ((bits & 2L) == 0L) {
                    this.mode(instance.mode());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.enabled(instance.enabled());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.defaultChannelIds(instance.defaultChannelIds());
                    bits |= 4L;
                }
            }
        }

        public Builder addDefaultChannelId(long element) {
            this.defaultChannelIds_getOrCreate().add(element);
            return this;
        }

        public Builder addDefaultChannelId(String element) {
            this.defaultChannelIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addDefaultChannelId(Id element) {
            this.defaultChannelIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllDefaultChannelIds(List<Long> elements) {
            this.defaultChannelIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="default_channel_ids")
        public Builder defaultChannelIds(List<Id> elements) {
            this.defaultChannelIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder defaultChannelIds(Iterable<Id> elements) {
            this.defaultChannelIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mode")
        public final Builder mode(int mode) {
            this.mode = mode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPrompt(OnboardingEditPromptData element) {
            this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            return this;
        }

        public final Builder addPrompts(OnboardingEditPromptData ... elements) {
            for (OnboardingEditPromptData element : elements) {
                this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            }
            return this;
        }

        @JsonProperty(value="prompts")
        public final Builder prompts(Iterable<? extends OnboardingEditPromptData> elements) {
            this.prompts.clear();
            return this.addAllPrompts(elements);
        }

        public final Builder addAllPrompts(Iterable<? extends OnboardingEditPromptData> elements) {
            for (OnboardingEditPromptData onboardingEditPromptData : elements) {
                this.prompts.add(Objects.requireNonNull(onboardingEditPromptData, "prompts element"));
            }
            return this;
        }

        public ImmutableOnboardingEditData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingEditData(null, this.defaultChannelIds_build(), this.enabled, this.mode, ImmutableOnboardingEditData.createUnmodifiableList(true, this.prompts));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mode");
            }
            return "Cannot build OnboardingEditData, some of required attributes are not set " + attributes;
        }

        private List<Id> defaultChannelIds_build() {
            return this.defaultChannelIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> defaultChannelIds_getOrCreate() {
            if (this.defaultChannelIds_list == null) {
                this.defaultChannelIds_list = new ArrayList<Long>();
            }
            return this.defaultChannelIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OnboardingEditData {
        @Nullable
        List<Id> defaultChannelIds;
        boolean enabled;
        boolean enabledIsSet;
        int mode;
        boolean modeIsSet;
        @Nullable
        List<OnboardingEditPromptData> prompts = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="default_channel_ids")
        public void setDefaultChannelIds(List<Id> defaultChannelIds) {
            this.defaultChannelIds = defaultChannelIds;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="mode")
        public void setMode(int mode) {
            this.mode = mode;
            this.modeIsSet = true;
        }

        @JsonProperty(value="prompts")
        public void setPrompts(List<OnboardingEditPromptData> prompts) {
            this.prompts = prompts;
        }

        @Override
        public List<Id> defaultChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int mode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OnboardingEditPromptData> prompts() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingEditData, attribute initializers form cycle " + attributes;
        }
    }
}

