/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.InstallParamsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableInstallParamsData
implements InstallParamsData {
    private final List<String> scopes;
    private final String permissions;

    private ImmutableInstallParamsData(Iterable<String> scopes, String permissions) {
        this.scopes = ImmutableInstallParamsData.createUnmodifiableList(false, ImmutableInstallParamsData.createSafeList(scopes, true, false));
        this.permissions = Objects.requireNonNull(permissions, "permissions");
    }

    private ImmutableInstallParamsData(ImmutableInstallParamsData original, List<String> scopes, String permissions) {
        this.scopes = scopes;
        this.permissions = permissions;
    }

    @Override
    @JsonProperty(value="scopes")
    public List<String> scopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="permissions")
    public String permissions() {
        return this.permissions;
    }

    public final ImmutableInstallParamsData withScopes(String ... elements) {
        List<String> newValue = ImmutableInstallParamsData.createUnmodifiableList(false, ImmutableInstallParamsData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInstallParamsData(this, newValue, this.permissions);
    }

    public final ImmutableInstallParamsData withScopes(Iterable<String> elements) {
        if (this.scopes == elements) {
            return this;
        }
        List<String> newValue = ImmutableInstallParamsData.createUnmodifiableList(false, ImmutableInstallParamsData.createSafeList(elements, true, false));
        return new ImmutableInstallParamsData(this, newValue, this.permissions);
    }

    public final ImmutableInstallParamsData withPermissions(String value) {
        String newValue = Objects.requireNonNull(value, "permissions");
        if (this.permissions.equals(newValue)) {
            return this;
        }
        return new ImmutableInstallParamsData(this, this.scopes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallParamsData && this.equalTo(0, (ImmutableInstallParamsData)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstallParamsData another) {
        return this.scopes.equals(another.scopes) && this.permissions.equals(another.permissions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        return h;
    }

    public String toString() {
        return "InstallParamsData{scopes=" + this.scopes + ", permissions=" + this.permissions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInstallParamsData fromJson(Json json) {
        Builder builder = ImmutableInstallParamsData.builder();
        if (json.scopes != null) {
            builder.addAllScopes(json.scopes);
        }
        if (json.permissions != null) {
            builder.permissions(json.permissions);
        }
        return builder.build();
    }

    public static ImmutableInstallParamsData of(List<String> scopes, String permissions) {
        return ImmutableInstallParamsData.of(scopes, permissions);
    }

    public static ImmutableInstallParamsData of(Iterable<String> scopes, String permissions) {
        return new ImmutableInstallParamsData(scopes, permissions);
    }

    public static ImmutableInstallParamsData copyOf(InstallParamsData instance) {
        if (instance instanceof ImmutableInstallParamsData) {
            return (ImmutableInstallParamsData)instance;
        }
        return ImmutableInstallParamsData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PERMISSIONS = 1L;
        private long initBits = 1L;
        private List<String> scopes = new ArrayList<String>();
        @Nullable
        private String permissions;

        private Builder() {
        }

        public final Builder from(InstallParamsData instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllScopes(instance.scopes());
            this.permissions(instance.permissions());
            return this;
        }

        public final Builder addScope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder addScopes(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="scopes")
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="permissions")
        public final Builder permissions(String permissions) {
            this.permissions = Objects.requireNonNull(permissions, "permissions");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInstallParamsData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstallParamsData(null, ImmutableInstallParamsData.createUnmodifiableList(true, this.scopes), this.permissions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("permissions");
            }
            return "Cannot build InstallParamsData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements InstallParamsData {
        @Nullable
        List<String> scopes = Collections.emptyList();
        @Nullable
        String permissions;

        Json() {
        }

        @JsonProperty(value="scopes")
        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @Override
        public List<String> scopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String permissions() {
            throw new UnsupportedOperationException();
        }
    }
}

