/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationEmojiDataList;
import discord4j.discordjson.json.EmojiData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableApplicationEmojiDataList
implements ApplicationEmojiDataList {
    private final List<EmojiData> items;

    private ImmutableApplicationEmojiDataList(Iterable<? extends EmojiData> items) {
        this.items = ImmutableApplicationEmojiDataList.createUnmodifiableList(false, ImmutableApplicationEmojiDataList.createSafeList(items, true, false));
    }

    private ImmutableApplicationEmojiDataList(ImmutableApplicationEmojiDataList original, List<EmojiData> items) {
        this.items = items;
    }

    @Override
    @JsonProperty(value="items")
    public List<EmojiData> items() {
        return this.items;
    }

    public final ImmutableApplicationEmojiDataList withItems(EmojiData ... elements) {
        List<EmojiData> newValue = ImmutableApplicationEmojiDataList.createUnmodifiableList(false, ImmutableApplicationEmojiDataList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApplicationEmojiDataList(this, newValue);
    }

    public final ImmutableApplicationEmojiDataList withItems(Iterable<? extends EmojiData> elements) {
        if (this.items == elements) {
            return this;
        }
        List<EmojiData> newValue = ImmutableApplicationEmojiDataList.createUnmodifiableList(false, ImmutableApplicationEmojiDataList.createSafeList(elements, true, false));
        return new ImmutableApplicationEmojiDataList(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationEmojiDataList && this.equalTo(0, (ImmutableApplicationEmojiDataList)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplicationEmojiDataList another) {
        return this.items.equals(another.items);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.items.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationEmojiDataList{items=" + this.items + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationEmojiDataList fromJson(Json json) {
        Builder builder = ImmutableApplicationEmojiDataList.builder();
        if (json.items != null) {
            builder.addAllItems(json.items);
        }
        return builder.build();
    }

    public static ImmutableApplicationEmojiDataList of(List<EmojiData> items) {
        return ImmutableApplicationEmojiDataList.of(items);
    }

    public static ImmutableApplicationEmojiDataList of(Iterable<? extends EmojiData> items) {
        return new ImmutableApplicationEmojiDataList(items);
    }

    public static ImmutableApplicationEmojiDataList copyOf(ApplicationEmojiDataList instance) {
        if (instance instanceof ImmutableApplicationEmojiDataList) {
            return (ImmutableApplicationEmojiDataList)instance;
        }
        return ImmutableApplicationEmojiDataList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<EmojiData> items = new ArrayList<EmojiData>();

        private Builder() {
        }

        public final Builder from(ApplicationEmojiDataList instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllItems(instance.items());
            return this;
        }

        public final Builder addItem(EmojiData element) {
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        public final Builder addItems(EmojiData ... elements) {
            for (EmojiData element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        @JsonProperty(value="items")
        public final Builder items(Iterable<? extends EmojiData> elements) {
            this.items.clear();
            return this.addAllItems(elements);
        }

        public final Builder addAllItems(Iterable<? extends EmojiData> elements) {
            for (EmojiData emojiData : elements) {
                this.items.add(Objects.requireNonNull(emojiData, "items element"));
            }
            return this;
        }

        public ImmutableApplicationEmojiDataList build() {
            return new ImmutableApplicationEmojiDataList(null, ImmutableApplicationEmojiDataList.createUnmodifiableList(true, this.items));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ApplicationEmojiDataList {
        @Nullable
        List<EmojiData> items = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="items")
        public void setItems(List<EmojiData> items) {
            this.items = items;
        }

        @Override
        public List<EmojiData> items() {
            throw new UnsupportedOperationException();
        }
    }
}

