/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.Activity;
import discord4j.discordjson.json.ActivityUpdateRequest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableActivityUpdateRequest
implements ActivityUpdateRequest {
    private final String name;
    private final int type;
    @Nullable
    private final String url;
    @Nullable
    private final String state;

    private ImmutableActivityUpdateRequest(String name, int type, Optional<String> url, Optional<String> state) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = type;
        this.url = url.orElse(null);
        this.state = state.orElse(null);
    }

    private ImmutableActivityUpdateRequest(ImmutableActivityUpdateRequest original, String name, int type, @Nullable String url, @Nullable String state) {
        this.name = name;
        this.type = type;
        this.url = url;
        this.state = state;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="url")
    public Optional<String> url() {
        return Optional.ofNullable(this.url);
    }

    @Override
    @JsonProperty(value="state")
    public Optional<String> state() {
        return Optional.ofNullable(this.state);
    }

    public final ImmutableActivityUpdateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, newValue, this.type, this.url, this.state);
    }

    public final ImmutableActivityUpdateRequest withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, value, this.url, this.state);
    }

    public final ImmutableActivityUpdateRequest withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, this.type, newValue, this.state);
    }

    public final ImmutableActivityUpdateRequest withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, this.type, value, this.state);
    }

    public final ImmutableActivityUpdateRequest withState(String value) {
        String newValue = Objects.requireNonNull(value, "state");
        if (Objects.equals(this.state, newValue)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, this.type, this.url, newValue);
    }

    public final ImmutableActivityUpdateRequest withState(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, this.type, this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableActivityUpdateRequest && this.equalTo(0, (ImmutableActivityUpdateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableActivityUpdateRequest another) {
        return this.name.equals(another.name) && this.type == another.type && Objects.equals(this.url, another.url) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ActivityUpdateRequest{");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.url != null) {
            builder.append(", ");
            builder.append("url=").append(this.url);
        }
        if (this.state != null) {
            builder.append(", ");
            builder.append("state=").append(this.state);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableActivityUpdateRequest fromJson(Json json) {
        Builder builder = ImmutableActivityUpdateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static ImmutableActivityUpdateRequest of(String name, int type, Optional<String> url, Optional<String> state) {
        return new ImmutableActivityUpdateRequest(name, type, url, state);
    }

    public static ImmutableActivityUpdateRequest copyOf(ActivityUpdateRequest instance) {
        if (instance instanceof ImmutableActivityUpdateRequest) {
            return (ImmutableActivityUpdateRequest)instance;
        }
        return ImmutableActivityUpdateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private int type;
        @Nullable
        private String url;
        @Nullable
        private String state;

        private Builder() {
        }

        public final Builder from(ActivityUpdateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Activity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Activity instance;
            long bits = 0L;
            if (object instanceof ActivityUpdateRequest) {
                Optional<String> urlOptional;
                Optional<String> stateOptional;
                instance = (ActivityUpdateRequest)object;
                if ((bits & 2L) == 0L) {
                    this.name(instance.name());
                    bits |= 2L;
                }
                if ((stateOptional = instance.state()).isPresent()) {
                    this.state(stateOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((urlOptional = instance.url()).isPresent()) {
                    this.url(urlOptional);
                }
            }
            if (object instanceof Activity) {
                instance = (Activity)object;
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.name(instance.name());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            return this;
        }

        @JsonProperty(value="url")
        public final Builder url(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public final Builder state(String state) {
            this.state = Objects.requireNonNull(state, "state");
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(Optional<String> state) {
            this.state = state.orElse(null);
            return this;
        }

        public ImmutableActivityUpdateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableActivityUpdateRequest(null, this.name, this.type, this.url, this.state);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ActivityUpdateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ActivityUpdateRequest {
        @Nullable
        String name;
        int type;
        boolean typeIsSet;
        @Nullable
        Optional<String> url = Optional.empty();
        @Nullable
        Optional<String> state = Optional.empty();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="url")
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @JsonProperty(value="state")
        public void setState(Optional<String> state) {
            this.state = state;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> state() {
            throw new UnsupportedOperationException();
        }
    }
}

