/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.jdk;

import com.austinv11.servicer.WireService;
import discord4j.store.api.Store;
import discord4j.store.api.primitive.ForwardingStore;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.StoreContext;
import discord4j.store.jdk.JdkStore;
import reactor.core.publisher.Mono;

@WireService(value=StoreService.class)
public class JdkStoreService
implements StoreService {
    volatile Class<?> messageClass;

    public boolean hasGenericStores() {
        return true;
    }

    public <K extends Comparable<K>, V> Store<K, V> provideGenericStore(Class<K> keyClass, Class<V> valueClass) {
        return new JdkStore(!valueClass.equals(this.messageClass));
    }

    public boolean hasLongObjStores() {
        return false;
    }

    public <V> LongObjStore<V> provideLongObjStore(Class<V> valueClass) {
        return new ForwardingStore(this.provideGenericStore(Long.class, valueClass));
    }

    public void init(StoreContext context) {
        Object messageClass = context.getHints().get("messageClass");
        this.messageClass = messageClass instanceof Class ? (Class<Object>)messageClass : Void.class;
    }

    public Mono<Void> dispose() {
        return Mono.empty();
    }
}

