/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.SubscriptionData;
import discord4j.discordjson.json.gateway.SubscriptionCreate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSubscriptionCreate
implements SubscriptionCreate {
    private final SubscriptionData subscription;

    private ImmutableSubscriptionCreate(SubscriptionData subscription) {
        this.subscription = Objects.requireNonNull(subscription, "subscription");
    }

    private ImmutableSubscriptionCreate(ImmutableSubscriptionCreate original, SubscriptionData subscription) {
        this.subscription = subscription;
    }

    @Override
    @JsonProperty(value="subscription")
    @JsonUnwrapped
    public SubscriptionData subscription() {
        return this.subscription;
    }

    public final ImmutableSubscriptionCreate withSubscription(SubscriptionData value) {
        if (this.subscription == value) {
            return this;
        }
        SubscriptionData newValue = Objects.requireNonNull(value, "subscription");
        return new ImmutableSubscriptionCreate(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubscriptionCreate && this.equalTo(0, (ImmutableSubscriptionCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubscriptionCreate another) {
        return this.subscription.equals(another.subscription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.subscription.hashCode();
        return h;
    }

    public String toString() {
        return "SubscriptionCreate{subscription=" + this.subscription + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSubscriptionCreate fromJson(Json json) {
        Builder builder = ImmutableSubscriptionCreate.builder();
        if (json.subscription != null) {
            builder.subscription(json.subscription);
        }
        return builder.build();
    }

    public static ImmutableSubscriptionCreate of(SubscriptionData subscription) {
        return new ImmutableSubscriptionCreate(subscription);
    }

    public static ImmutableSubscriptionCreate copyOf(SubscriptionCreate instance) {
        if (instance instanceof ImmutableSubscriptionCreate) {
            return (ImmutableSubscriptionCreate)instance;
        }
        return ImmutableSubscriptionCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SUBSCRIPTION = 1L;
        private long initBits = 1L;
        @Nullable
        private SubscriptionData subscription;

        private Builder() {
        }

        public final Builder from(SubscriptionCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.subscription(instance.subscription());
            return this;
        }

        @JsonProperty(value="subscription")
        @JsonUnwrapped
        public final Builder subscription(SubscriptionData subscription) {
            this.subscription = Objects.requireNonNull(subscription, "subscription");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSubscriptionCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubscriptionCreate(null, this.subscription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subscription");
            }
            return "Cannot build SubscriptionCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SubscriptionCreate {
        @Nullable
        SubscriptionData subscription;

        Json() {
        }

        @JsonProperty(value="subscription")
        @JsonUnwrapped
        public void setSubscription(SubscriptionData subscription) {
            this.subscription = subscription;
        }

        @Override
        public SubscriptionData subscription() {
            throw new UnsupportedOperationException();
        }
    }
}

