/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.PollVoteAdd;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutablePollVoteAdd
implements PollVoteAdd {
    private final long userId_value;
    private final long channelId_value;
    private final long messageId_value;
    private final long guildId_value;
    private final boolean guildId_present;
    private final int answerId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollVoteAdd(Id userId, Id channelId, Id messageId, Optional<Id> guildId, int answerId) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Optional<Id> guildId$impl = guildId;
        this.answerId = answerId;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.map(Id::asLong).orElse(0L);
        this.guildId_present = guildId$impl.isPresent();
        this.initShim = null;
    }

    private ImmutablePollVoteAdd(ImmutablePollVoteAdd original, Id userId, Id channelId, Id messageId, Optional<Id> guildId, int answerId) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Optional<Id> guildId$impl = guildId;
        this.answerId = answerId;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.map(Id::asLong).orElse(0L);
        this.guildId_present = guildId$impl.isPresent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user_id")
    public Id userId() {
        return Id.of((long)this.userId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="message_id")
    public Id messageId() {
        return Id.of((long)this.messageId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Optional<Id> guildId() {
        return this.guildId_present ? Optional.of(Id.of((long)this.guildId_value)) : Optional.empty();
    }

    @Override
    @JsonProperty(value="answer_id")
    public int answerId() {
        return this.answerId;
    }

    public ImmutablePollVoteAdd withUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutablePollVoteAdd(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutablePollVoteAdd withUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutablePollVoteAdd(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutablePollVoteAdd withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutablePollVoteAdd(this, this.userId(), newValue, this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutablePollVoteAdd withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutablePollVoteAdd(this, this.userId(), newValue, this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutablePollVoteAdd withMessageId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutablePollVoteAdd(this, this.userId(), this.channelId(), newValue, this.guildId(), this.answerId);
    }

    public ImmutablePollVoteAdd withMessageId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutablePollVoteAdd(this, this.userId(), this.channelId(), newValue, this.guildId(), this.answerId);
    }

    public ImmutablePollVoteAdd withGuildId(Optional<Id> value) {
        Optional<Id> newValue = Objects.requireNonNull(value);
        return new ImmutablePollVoteAdd(this, this.userId(), this.channelId(), this.messageId(), newValue, this.answerId);
    }

    public ImmutablePollVoteAdd withGuildId(long value) {
        Optional<Id> newValue = Optional.of(Id.of((long)value));
        return new ImmutablePollVoteAdd(this, this.userId(), this.channelId(), this.messageId(), newValue, this.answerId);
    }

    public final ImmutablePollVoteAdd withAnswerId(int value) {
        if (this.answerId == value) {
            return this;
        }
        return new ImmutablePollVoteAdd(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollVoteAdd && this.equalTo(0, (ImmutablePollVoteAdd)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollVoteAdd another) {
        return Objects.equals(this.userId_value, another.userId_value) && Objects.equals(this.channelId_value, another.channelId_value) && Objects.equals(this.messageId_value, another.messageId_value) && this.guildId().equals(another.guildId()) && this.answerId == another.answerId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId_value);
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + Objects.hashCode(this.messageId_value);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.answerId;
        return h;
    }

    public String toString() {
        return "PollVoteAdd{userId=" + Objects.toString(this.userId_value) + ", channelId=" + Objects.toString(this.channelId_value) + ", messageId=" + Objects.toString(this.messageId_value) + ", guildId=" + this.guildId().toString() + ", answerId=" + this.answerId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollVoteAdd fromJson(Json json) {
        ImmutablePollVoteAdd instance = ImmutablePollVoteAdd.of(json.userId, json.channelId, json.messageId, json.guildId, json.answerId);
        return instance;
    }

    public static ImmutablePollVoteAdd of(Id userId, Id channelId, Id messageId, Optional<Id> guildId, int answerId) {
        return new ImmutablePollVoteAdd(userId, channelId, messageId, guildId, answerId);
    }

    public static ImmutablePollVoteAdd copyOf(PollVoteAdd instance) {
        if (instance instanceof ImmutablePollVoteAdd) {
            return (ImmutablePollVoteAdd)instance;
        }
        return ImmutablePollVoteAdd.of(instance.userId(), instance.channelId(), instance.messageId(), instance.guildId(), instance.answerId());
    }

    public boolean isGuildIdPresent() {
        return this.guildId_present;
    }

    public long guildIdOrElse(long defaultValue) {
        return this.guildId_present ? this.guildId_value : defaultValue;
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollVoteAdd {
        @Nullable
        Id userId;
        @Nullable
        Id channelId;
        @Nullable
        Id messageId;
        Optional<Id> guildId = Optional.empty();
        int answerId;
        boolean answerIdIsSet;

        Json() {
        }

        @JsonProperty(value="user_id")
        public void setUserId(Id userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(Id messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Optional<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="answer_id")
        public void setAnswerId(int answerId) {
            this.answerId = answerId;
            this.answerIdIsSet = true;
        }

        @Override
        public Id userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int answerId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollVoteAdd, attribute initializers form cycle " + attributes;
        }
    }
}

