/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.GuildStickerCreateRequest;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableGuildStickerCreateRequest
implements GuildStickerCreateRequest {
    private final String name;
    private final String description;
    private final String tags;
    private final String file;

    private ImmutableGuildStickerCreateRequest(String name, String description, String tags, String file) {
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        this.tags = Objects.requireNonNull(tags, "tags");
        this.file = Objects.requireNonNull(file, "file");
    }

    private ImmutableGuildStickerCreateRequest(ImmutableGuildStickerCreateRequest original, String name, String description, String tags, String file) {
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.file = file;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="tags")
    public String tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="file")
    public String file() {
        return this.file;
    }

    public final ImmutableGuildStickerCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildStickerCreateRequest(this, newValue, this.description, this.tags, this.file);
    }

    public final ImmutableGuildStickerCreateRequest withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildStickerCreateRequest(this, this.name, newValue, this.tags, this.file);
    }

    public final ImmutableGuildStickerCreateRequest withTags(String value) {
        String newValue = Objects.requireNonNull(value, "tags");
        if (this.tags.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildStickerCreateRequest(this, this.name, this.description, newValue, this.file);
    }

    public final ImmutableGuildStickerCreateRequest withFile(String value) {
        String newValue = Objects.requireNonNull(value, "file");
        if (this.file.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildStickerCreateRequest(this, this.name, this.description, this.tags, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildStickerCreateRequest && this.equalTo(0, (ImmutableGuildStickerCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildStickerCreateRequest another) {
        return this.name.equals(another.name) && this.description.equals(another.description) && this.tags.equals(another.tags) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "GuildStickerCreateRequest{name=" + this.name + ", description=" + this.description + ", tags=" + this.tags + ", file=" + this.file + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildStickerCreateRequest fromJson(Json json) {
        Builder builder = ImmutableGuildStickerCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.file != null) {
            builder.file(json.file);
        }
        return builder.build();
    }

    public static ImmutableGuildStickerCreateRequest of(String name, String description, String tags, String file) {
        return new ImmutableGuildStickerCreateRequest(name, description, tags, file);
    }

    public static ImmutableGuildStickerCreateRequest copyOf(GuildStickerCreateRequest instance) {
        if (instance instanceof ImmutableGuildStickerCreateRequest) {
            return (ImmutableGuildStickerCreateRequest)instance;
        }
        return ImmutableGuildStickerCreateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_TAGS = 4L;
        private static final long INIT_BIT_FILE = 8L;
        private long initBits = 15L;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String tags;
        @Nullable
        private String file;

        private Builder() {
        }

        public final Builder from(GuildStickerCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.description(instance.description());
            this.tags(instance.tags());
            this.file(instance.file());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(String tags) {
            this.tags = Objects.requireNonNull(tags, "tags");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="file")
        public final Builder file(String file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGuildStickerCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildStickerCreateRequest(null, this.name, this.description, this.tags, this.file);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tags");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build GuildStickerCreateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildStickerCreateRequest {
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        String tags;
        @Nullable
        String file;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="tags")
        public void setTags(String tags) {
            this.tags = tags;
        }

        @JsonProperty(value="file")
        public void setFile(String file) {
            this.file = file;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String file() {
            throw new UnsupportedOperationException();
        }
    }
}

