/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmbedAuthorData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableEmbedAuthorData
implements EmbedAuthorData {
    private final String name_value;
    private final boolean name_absent;
    private final String url_value;
    private final boolean url_absent;
    private final String iconUrl_value;
    private final boolean iconUrl_absent;
    private final String proxyIconUrl_value;
    private final boolean proxyIconUrl_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEmbedAuthorData(Possible<String> name, Possible<Optional<String>> url, Possible<String> iconUrl, Possible<String> proxyIconUrl) {
        Possible<String> name$impl = name;
        Possible<Optional<String>> url$impl = url;
        Possible<String> iconUrl$impl = iconUrl;
        Possible<String> proxyIconUrl$impl = proxyIconUrl;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.url_value = Possible.flatOpt(url$impl).orElse(null);
        this.url_absent = url$impl.isAbsent();
        this.iconUrl_value = iconUrl$impl.toOptional().orElse(null);
        this.iconUrl_absent = iconUrl$impl.isAbsent();
        this.proxyIconUrl_value = proxyIconUrl$impl.toOptional().orElse(null);
        this.proxyIconUrl_absent = proxyIconUrl$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableEmbedAuthorData(ImmutableEmbedAuthorData original, Possible<String> name, Possible<Optional<String>> url, Possible<String> iconUrl, Possible<String> proxyIconUrl) {
        Possible<String> name$impl = name;
        Possible<Optional<String>> url$impl = url;
        Possible<String> iconUrl$impl = iconUrl;
        Possible<String> proxyIconUrl$impl = proxyIconUrl;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.url_value = Possible.flatOpt(url$impl).orElse(null);
        this.url_absent = url$impl.isAbsent();
        this.iconUrl_value = iconUrl$impl.toOptional().orElse(null);
        this.iconUrl_absent = iconUrl$impl.isAbsent();
        this.proxyIconUrl_value = proxyIconUrl$impl.toOptional().orElse(null);
        this.proxyIconUrl_absent = proxyIconUrl$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    @JsonProperty(value="url")
    public Possible<Optional<String>> url() {
        return this.url_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.url_value));
    }

    @Override
    @JsonProperty(value="icon_url")
    public Possible<String> iconUrl() {
        return this.iconUrl_absent ? Possible.absent() : Possible.of((Object)this.iconUrl_value);
    }

    @Override
    @JsonProperty(value="proxy_icon_url")
    public Possible<String> proxyIconUrl() {
        return this.proxyIconUrl_absent ? Possible.absent() : Possible.of((Object)this.proxyIconUrl_value);
    }

    public ImmutableEmbedAuthorData withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableEmbedAuthorData(this, newValue, this.url(), this.iconUrl(), this.proxyIconUrl());
    }

    public ImmutableEmbedAuthorData withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableEmbedAuthorData(this, (Possible<String>)newValue, this.url(), this.iconUrl(), this.proxyIconUrl());
    }

    public ImmutableEmbedAuthorData withUrl(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableEmbedAuthorData(this, this.name(), newValue, this.iconUrl(), this.proxyIconUrl());
    }

    @Deprecated
    public ImmutableEmbedAuthorData withUrl(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableEmbedAuthorData(this, this.name(), (Possible<Optional<String>>)newValue, this.iconUrl(), this.proxyIconUrl());
    }

    public ImmutableEmbedAuthorData withUrlOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableEmbedAuthorData(this, this.name(), (Possible<Optional<String>>)newValue, this.iconUrl(), this.proxyIconUrl());
    }

    public ImmutableEmbedAuthorData withIconUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableEmbedAuthorData(this, this.name(), this.url(), newValue, this.proxyIconUrl());
    }

    public ImmutableEmbedAuthorData withIconUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableEmbedAuthorData(this, this.name(), this.url(), (Possible<String>)newValue, this.proxyIconUrl());
    }

    public ImmutableEmbedAuthorData withProxyIconUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableEmbedAuthorData(this, this.name(), this.url(), this.iconUrl(), newValue);
    }

    public ImmutableEmbedAuthorData withProxyIconUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableEmbedAuthorData(this, this.name(), this.url(), this.iconUrl(), (Possible<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmbedAuthorData && this.equalTo(0, (ImmutableEmbedAuthorData)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbedAuthorData another) {
        return this.name().equals(another.name()) && this.url().equals(another.url()) && this.iconUrl().equals(another.iconUrl()) && this.proxyIconUrl().equals(another.proxyIconUrl());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.url().hashCode();
        h += (h << 5) + this.iconUrl().hashCode();
        h += (h << 5) + this.proxyIconUrl().hashCode();
        return h;
    }

    public String toString() {
        return "EmbedAuthorData{name=" + this.name().toString() + ", url=" + this.url().toString() + ", iconUrl=" + this.iconUrl().toString() + ", proxyIconUrl=" + this.proxyIconUrl().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEmbedAuthorData fromJson(Json json) {
        Builder builder = ImmutableEmbedAuthorData.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.iconUrl != null) {
            builder.iconUrl(json.iconUrl);
        }
        if (json.proxyIconUrl != null) {
            builder.proxyIconUrl(json.proxyIconUrl);
        }
        return builder.build();
    }

    public static ImmutableEmbedAuthorData of(Possible<String> name, Possible<Optional<String>> url, Possible<String> iconUrl, Possible<String> proxyIconUrl) {
        return new ImmutableEmbedAuthorData(name, url, iconUrl, proxyIconUrl);
    }

    public static ImmutableEmbedAuthorData copyOf(EmbedAuthorData instance) {
        if (instance instanceof ImmutableEmbedAuthorData) {
            return (ImmutableEmbedAuthorData)instance;
        }
        return ImmutableEmbedAuthorData.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isUrlPresent() {
        return !this.url_absent;
    }

    public String urlOrElse(String defaultValue) {
        return !this.url_absent ? this.url_value : defaultValue;
    }

    public boolean isIconUrlPresent() {
        return !this.iconUrl_absent;
    }

    public String iconUrlOrElse(String defaultValue) {
        return !this.iconUrl_absent ? this.iconUrl_value : defaultValue;
    }

    public boolean isProxyIconUrlPresent() {
        return !this.proxyIconUrl_absent;
    }

    public String proxyIconUrlOrElse(String defaultValue) {
        return !this.proxyIconUrl_absent ? this.proxyIconUrl_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Optional<String>> url_possible = Possible.absent();
        private Possible<String> iconUrl_possible = Possible.absent();
        private Possible<String> proxyIconUrl_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(EmbedAuthorData instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.url(instance.url());
            this.iconUrl(instance.iconUrl());
            this.proxyIconUrl(instance.proxyIconUrl());
            return this;
        }

        @JsonProperty(value="name")
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="url")
        public Builder url(Possible<Optional<String>> value) {
            this.url_possible = value;
            return this;
        }

        @Deprecated
        public Builder url(@Nullable String value) {
            this.url_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder urlOrNull(@Nullable String value) {
            this.url_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="icon_url")
        public Builder iconUrl(Possible<String> value) {
            this.iconUrl_possible = value;
            return this;
        }

        public Builder iconUrl(String value) {
            this.iconUrl_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="proxy_icon_url")
        public Builder proxyIconUrl(Possible<String> value) {
            this.proxyIconUrl_possible = value;
            return this;
        }

        public Builder proxyIconUrl(String value) {
            this.proxyIconUrl_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableEmbedAuthorData build() {
            return new ImmutableEmbedAuthorData(null, this.name_build(), this.url_build(), this.iconUrl_build(), this.proxyIconUrl_build());
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Optional<String>> url_build() {
            return this.url_possible;
        }

        private Possible<String> iconUrl_build() {
            return this.iconUrl_possible;
        }

        private Possible<String> proxyIconUrl_build() {
            return this.proxyIconUrl_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EmbedAuthorData {
        Possible<String> name = Possible.absent();
        Possible<Optional<String>> url = Possible.absent();
        Possible<String> iconUrl = Possible.absent();
        Possible<String> proxyIconUrl = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(Possible<String> name) {
            this.name = name;
        }

        @JsonProperty(value="url")
        public void setUrl(Possible<Optional<String>> url) {
            this.url = url;
        }

        @JsonProperty(value="icon_url")
        public void setIconUrl(Possible<String> iconUrl) {
            this.iconUrl = iconUrl;
        }

        @JsonProperty(value="proxy_icon_url")
        public void setProxyIconUrl(Possible<String> proxyIconUrl) {
            this.proxyIconUrl = proxyIconUrl;
        }

        @Override
        public Possible<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> iconUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> proxyIconUrl() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build EmbedAuthorData, attribute initializers form cycle " + attributes;
        }
    }
}

