/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingPromptOptionData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableBaseOnboardingPromptOptionData
implements BaseOnboardingPromptOptionData {
    private final long[] channelsIds_value;
    private final long[] rolesIds_value;
    private final String title;
    @Nullable
    private final String description;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseOnboardingPromptOptionData(List<Id> channelsIds, List<Id> rolesIds, String title, Optional<String> description) {
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.title = Objects.requireNonNull(title, "title");
        this.description = description.orElse(null);
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableBaseOnboardingPromptOptionData(ImmutableBaseOnboardingPromptOptionData original, List<Id> channelsIds, List<Id> rolesIds, String title, @Nullable String description) {
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.title = title;
        this.description = description;
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_ids")
    public List<Id> channelsIds() {
        return LongStream.of(this.channelsIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="role_ids")
    public List<Id> rolesIds() {
        return LongStream.of(this.rolesIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public ImmutableBaseOnboardingPromptOptionData withChannelsIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableBaseOnboardingPromptOptionData(this, newValue, this.rolesIds(), this.title, this.description);
    }

    public ImmutableBaseOnboardingPromptOptionData withRolesIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableBaseOnboardingPromptOptionData(this, this.channelsIds(), newValue, this.title, this.description);
    }

    public final ImmutableBaseOnboardingPromptOptionData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), newValue, this.description);
    }

    public final ImmutableBaseOnboardingPromptOptionData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, newValue);
    }

    public final ImmutableBaseOnboardingPromptOptionData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableBaseOnboardingPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseOnboardingPromptOptionData && this.equalTo(0, (ImmutableBaseOnboardingPromptOptionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseOnboardingPromptOptionData another) {
        return Objects.equals(this.channelsIds_value, another.channelsIds_value) && Objects.equals(this.rolesIds_value, another.rolesIds_value) && this.title.equals(another.title) && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.channelsIds_value);
        h += (h << 5) + Objects.hashCode(this.rolesIds_value);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BaseOnboardingPromptOptionData{");
        builder.append("channelsIds=").append(Objects.toString(this.channelsIds_value));
        builder.append(", ");
        builder.append("rolesIds=").append(Objects.toString(this.rolesIds_value));
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBaseOnboardingPromptOptionData fromJson(Json json) {
        Builder builder = ImmutableBaseOnboardingPromptOptionData.builder();
        if (json.channelsIds != null) {
            builder.channelsIds(json.channelsIds);
        }
        if (json.rolesIds != null) {
            builder.rolesIds(json.rolesIds);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableBaseOnboardingPromptOptionData of(List<Id> channelsIds, List<Id> rolesIds, String title, Optional<String> description) {
        return new ImmutableBaseOnboardingPromptOptionData(channelsIds, rolesIds, title, description);
    }

    public static ImmutableBaseOnboardingPromptOptionData copyOf(BaseOnboardingPromptOptionData instance) {
        if (instance instanceof ImmutableBaseOnboardingPromptOptionData) {
            return (ImmutableBaseOnboardingPromptOptionData)instance;
        }
        return ImmutableBaseOnboardingPromptOptionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        private List<Long> channelsIds_list = null;
        private List<Long> rolesIds_list = null;
        @Nullable
        private String title;
        @Nullable
        private String description;

        private Builder() {
        }

        public final Builder from(BaseOnboardingPromptOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelsIds(instance.channelsIds());
            this.rolesIds(instance.rolesIds());
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            return this;
        }

        public Builder addChannelsId(long element) {
            this.channelsIds_getOrCreate().add(element);
            return this;
        }

        public Builder addChannelsId(String element) {
            this.channelsIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addChannelsId(Id element) {
            this.channelsIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllChannelsIds(List<Long> elements) {
            this.channelsIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="channel_ids")
        public Builder channelsIds(List<Id> elements) {
            this.channelsIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder channelsIds(Iterable<Id> elements) {
            this.channelsIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addRolesId(long element) {
            this.rolesIds_getOrCreate().add(element);
            return this;
        }

        public Builder addRolesId(String element) {
            this.rolesIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addRolesId(Id element) {
            this.rolesIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRolesIds(List<Long> elements) {
            this.rolesIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="role_ids")
        public Builder rolesIds(List<Id> elements) {
            this.rolesIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder rolesIds(Iterable<Id> elements) {
            this.rolesIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public ImmutableBaseOnboardingPromptOptionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseOnboardingPromptOptionData(null, this.channelsIds_build(), this.rolesIds_build(), this.title, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build BaseOnboardingPromptOptionData, some of required attributes are not set " + attributes;
        }

        private List<Id> channelsIds_build() {
            return this.channelsIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> channelsIds_getOrCreate() {
            if (this.channelsIds_list == null) {
                this.channelsIds_list = new ArrayList<Long>();
            }
            return this.channelsIds_list;
        }

        private List<Id> rolesIds_build() {
            return this.rolesIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> rolesIds_getOrCreate() {
            if (this.rolesIds_list == null) {
                this.rolesIds_list = new ArrayList<Long>();
            }
            return this.rolesIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BaseOnboardingPromptOptionData {
        @Nullable
        List<Id> channelsIds;
        @Nullable
        List<Id> rolesIds;
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel_ids")
        public void setChannelsIds(List<Id> channelsIds) {
            this.channelsIds = channelsIds;
        }

        @JsonProperty(value="role_ids")
        public void setRolesIds(List<Id> rolesIds) {
            this.rolesIds = rolesIds;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @Override
        public List<Id> channelsIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> rolesIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build BaseOnboardingPromptOptionData, attribute initializers form cycle " + attributes;
        }
    }
}

